/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpRetryException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class Wiki
implements Serializable {
    public static final int MEDIA_NAMESPACE = -2;
    public static final int SPECIAL_NAMESPACE = -1;
    public static final int MAIN_NAMESPACE = 0;
    public static final int TALK_NAMESPACE = 1;
    public static final int USER_NAMESPACE = 2;
    public static final int USER_TALK_NAMESPACE = 3;
    public static final int PROJECT_NAMESPACE = 4;
    public static final int PROJECT_TALK_NAMESPACE = 5;
    public static final int FILE_NAMESPACE = 6;
    public static final int FILE_TALK_NAMESPACE = 7;
    @Deprecated
    public static final int IMAGE_NAMESPACE = 6;
    @Deprecated
    public static final int IMAGE_TALK_NAMESPACE = 7;
    public static final int MEDIAWIKI_NAMESPACE = 8;
    public static final int MEDIAWIKI_TALK_NAMESPACE = 9;
    public static final int TEMPLATE_NAMESPACE = 10;
    public static final int TEMPLATE_TALK_NAMESPACE = 11;
    public static final int HELP_NAMESPACE = 12;
    public static final int HELP_TALK_NAMESPACE = 13;
    public static final int CATEGORY_NAMESPACE = 14;
    public static final int CATEGORY_TALK_NAMESPACE = 15;
    public static final int ALL_NAMESPACES = 167317762;
    public static final String ALL_LOGS = "";
    public static final String USER_CREATION_LOG = "newusers";
    public static final String UPLOAD_LOG = "upload";
    public static final String DELETION_LOG = "delete";
    public static final String MOVE_LOG = "move";
    public static final String BLOCK_LOG = "block";
    public static final String PROTECTION_LOG = "protect";
    public static final String USER_RIGHTS_LOG = "rights";
    public static final String USER_RENAME_LOG = "renameuser";
    public static final String IMPORT_LOG = "import";
    public static final String PATROL_LOG = "patrol";
    public static final int NO_PROTECTION = -1;
    public static final int SEMI_PROTECTION = 1;
    public static final int FULL_PROTECTION = 2;
    public static final int MOVE_PROTECTION = 3;
    public static final int SEMI_AND_MOVE_PROTECTION = 4;
    public static final int PROTECTED_DELETED_PAGE = 5;
    public static final int UPLOAD_PROTECTION = 6;
    public static final int ASSERT_NONE = 0;
    public static final int ASSERT_LOGGED_IN = 1;
    public static final int ASSERT_BOT = 2;
    public static final int ASSERT_NO_MESSAGES = 4;
    public static final int HIDE_ANON = 1;
    public static final int HIDE_BOT = 2;
    public static final int HIDE_SELF = 4;
    public static final int HIDE_MINOR = 8;
    public static final int HIDE_PATROLLED = 16;
    public static final long NEXT_REVISION = -1L;
    public static final long CURRENT_REVISION = -2L;
    public static final long PREVIOUS_REVISION = -3L;
    private static final String version = "0.27";
    private String domain;
    protected String query;
    protected String base;
    protected String apiUrl;
    protected String scriptPath = "/w";
    private HashMap<String, String> cookies = new HashMap(12);
    private User user;
    private int statuscounter = 0;
    private HashMap<String, Integer> namespaces = null;
    private ArrayList<String> watchlist = null;
    private int max = 500;
    protected static final Logger logger = Logger.getLogger("wiki");
    private int throttle = 10000;
    private int maxlag = 5;
    private int assertion = 0;
    private int statusinterval = 100;
    private String useragent = "Wiki.java 0.27";
    private boolean zipped = true;
    private boolean markminor = false;
    private boolean markbot = false;
    private boolean resolveredirect = false;
    private boolean retry = true;
    private static final long serialVersionUID = -8745212681497644126L;
    private static final int CONNECTION_CONNECT_TIMEOUT_MSEC = 30000;
    private static final int CONNECTION_READ_TIMEOUT_MSEC = 180000;
    private static final int LOG2_CHUNK_SIZE = 22;

    public Wiki() {
        this(ALL_LOGS);
    }

    public Wiki(String string) {
        if (string == null || string.isEmpty()) {
            string = "en.wikipedia.org";
        }
        this.domain = string;
        this.initVars();
    }

    public Wiki(String string, String string2) {
        this.domain = string;
        this.scriptPath = string2;
        this.initVars();
    }

    protected void initVars() {
        String string = "http://" + this.domain + this.scriptPath;
        if (this.maxlag >= 0) {
            this.apiUrl = string + "/api.php?maxlag=" + this.maxlag + "&format=xml&";
            this.base = string + "/index.php?maxlag=" + this.maxlag + "&title=";
        } else {
            this.apiUrl = string + "/api.php?format=xml&";
            this.base = string + "/index.php?title=";
        }
        this.query = this.apiUrl + "action=query&";
        if (this.resolveredirect) {
            this.query = this.query + "redirects&";
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public void setThrottle(int n) {
        this.throttle = n;
        this.log(Level.CONFIG, "Throttle set to " + n + " milliseconds", "setThrottle");
    }

    public String getScriptPath() throws IOException {
        this.scriptPath = this.parseAndCleanup("{{SCRIPTPATH}}");
        this.initVars();
        return this.scriptPath;
    }

    public void setUserAgent(String string) {
        this.useragent = string;
    }

    public String getUserAgent() {
        return this.useragent;
    }

    public void setUsingCompressedRequests(boolean bl) {
        this.zipped = bl;
    }

    public boolean isUsingCompressedRequests() {
        return this.zipped;
    }

    public boolean isResolvingRedirects() {
        return this.resolveredirect;
    }

    public void setResolveRedirects(boolean bl) {
        this.resolveredirect = bl;
        this.initVars();
    }

    public void setMarkBot(boolean bl) {
        this.markbot = bl;
    }

    public boolean isMarkBot() {
        return this.markbot;
    }

    public void setMarkMinor(boolean bl) {
        this.markminor = bl;
    }

    public boolean isMarkMinor() {
        return this.markminor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Wiki)) {
            return false;
        }
        return this.domain.equals(((Wiki)object).domain);
    }

    public int hashCode() {
        return this.domain.hashCode() * this.maxlag - this.throttle;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Wiki[domain=");
        stringBuilder.append(this.domain);
        stringBuilder.append(",user=");
        stringBuilder.append(this.user != null ? this.user.toString() : "null");
        stringBuilder.append(",");
        stringBuilder.append("throttle=");
        stringBuilder.append(this.throttle);
        stringBuilder.append(",maxlag=");
        stringBuilder.append(this.maxlag);
        stringBuilder.append(",assertionMode=");
        stringBuilder.append(this.assertion);
        stringBuilder.append(",statusCheckInterval=");
        stringBuilder.append(this.statusinterval);
        stringBuilder.append(",cookies=");
        stringBuilder.append(this.cookies);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int getMaxLag() {
        return this.maxlag;
    }

    public void setMaxLag(int n) {
        this.maxlag = n;
        this.log(Level.CONFIG, "Setting maximum allowable database lag to " + n, "setMaxLag");
        this.initVars();
    }

    public int getAssertionMode() {
        return this.assertion;
    }

    public void setAssertionMode(int n) {
        this.assertion = n;
        this.log(Level.CONFIG, "Set assertion mode to " + n, "setAssertionMode");
    }

    public int getStatusCheckInterval() {
        return this.statusinterval;
    }

    public void setStatusCheckInterval(int n) {
        this.statusinterval = n;
        this.log(Level.CONFIG, "Status check interval set to " + n, "setStatusCheckInterval");
    }

    public synchronized void login(String string, char[] cArray) throws IOException, FailedLoginException {
        String string2 = this.fetch(this.base + "Special:Userlogin", "login");
        int n = string2.indexOf("wpLoginToken") + 21;
        int n2 = string2.indexOf(34, n);
        String string3 = string2.substring(n, n2);
        string = this.normalize(string);
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("lgname=");
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append("&lgpassword=");
        stringBuilder.append(URLEncoder.encode(new String(cArray), "UTF-8"));
        stringBuilder.append("&lgtoken=");
        stringBuilder.append(URLEncoder.encode(string3, "UTF-8"));
        String string4 = this.post(this.apiUrl + "action=login", stringBuilder.toString(), "login");
        stringBuilder = null;
        if (!string4.contains("result=\"Success\"")) {
            this.log(Level.WARNING, "Failed to log in as " + string, "login");
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (string4.contains("WrongPass") || string4.contains("WrongPluginPass")) {
                throw new FailedLoginException("Login failed: incorrect password.");
            }
            if (string4.contains("NotExists")) {
                throw new FailedLoginException("Login failed: user does not exist.");
            }
            throw new FailedLoginException("Login failed: unknown reason.");
        }
        this.user = new User(string);
        boolean bl = this.user.isAllowedTo("apihighlimits");
        this.max = bl ? 5000 : 500;
        this.log(Level.INFO, "Successfully logged in as " + string + ", highLimit = " + bl, "login");
    }

    public synchronized void logout() {
        this.cookies.clear();
        this.user = null;
        this.max = 500;
        this.log(Level.INFO, "Logged out", "logout");
    }

    public synchronized void logoutServerSide() throws IOException {
        this.fetch(this.apiUrl + "action=logout", "logoutServerSide");
        this.logout();
    }

    public boolean hasNewMessages() throws IOException {
        String string = this.query + "meta=userinfo&uiprop=hasmsg";
        return this.fetch(string, "hasNewMessages").contains("messages=\"\"");
    }

    public int getCurrentDatabaseLag() throws IOException {
        String string = this.fetch(this.query + "meta=siteinfo&siprop=dbrepllag", "getCurrentDatabaseLag");
        int n = string.indexOf("lag=\"") + 5;
        String string2 = string.substring(n, string.indexOf("\" />", n));
        this.log(Level.INFO, "Current database replication lag is " + string2 + " seconds", "getCurrentDatabaseLag");
        return Integer.parseInt(string2);
    }

    public HashMap<String, Integer> getSiteStatistics() throws IOException {
        String string = this.parseAndCleanup("{{NUMBEROFARTICLES:R}} {{NUMBEROFPAGES:R}} {{NUMBEROFFILES:R}} {{NUMBEROFEDITS:R}} {{NUMBEROFUSERS:R}} {{NUMBEROFADMINS:R}}");
        String[] stringArray = string.split("\\s");
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(12);
        String[] stringArray2 = new String[]{"articles", "pages", "files", "edits", "users", "admins"};
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = new Integer(stringArray[i]);
            hashMap.put(stringArray2[i], n);
        }
        return hashMap;
    }

    public String version() throws IOException {
        return this.parseAndCleanup("{{CURRENTVERSION}}");
    }

    public String parse(String string) throws IOException {
        String string2 = this.post(this.apiUrl + "action=parse", "prop=text&text=" + URLEncoder.encode(string, "UTF-8"), "parse");
        int n = string2.indexOf(62, string2.indexOf("<text")) + 1;
        int n2 = string2.indexOf("</text>");
        return this.decode(string2.substring(n, n2));
    }

    protected String parseAndCleanup(String string) throws IOException {
        String string2 = this.parse(string);
        string2 = string2.replace("<p>", ALL_LOGS).replace("</p>", ALL_LOGS);
        string2 = string2.replace("\n", ALL_LOGS);
        int n = string2.indexOf("<!--");
        return string2.substring(0, n);
    }

    public String random() throws IOException {
        return this.random(0);
    }

    public String random(int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=random");
        this.constructNamespaceString(stringBuilder, "rn", nArray);
        String string = this.fetch(stringBuilder.toString(), "random");
        int n = string.indexOf("title=\"") + 7;
        int n2 = string.indexOf(34, n);
        return string.substring(n, n2);
    }

    public static String[] intersection(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(5000);
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.retainAll(Arrays.asList(stringArray2));
        return arrayList.toArray(new String[0]);
    }

    public static String[] relativeComplement(String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>(5000);
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.removeAll(Arrays.asList(stringArray2));
        return arrayList.toArray(new String[0]);
    }

    public String getTalkPage(String string) throws IOException {
        int n = this.namespace(string);
        if (n % 2 == 1) {
            throw new IllegalArgumentException("Cannot fetch talk page of a talk page!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Special: and Media: pages do not have talk pages!");
        }
        if (n != 0) {
            string = string.substring(string.indexOf(58) + 1);
        }
        return this.namespaceIdentifier(n + 1) + ":" + string;
    }

    public HashMap<String, Object> getPageInfo(String string) throws IOException {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=info&intoken=edit%7Cwatch&inprop=protection%7Cdisplaytitle&titles=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        String string2 = this.fetch(stringBuilder.toString(), "getPageInfo");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(15);
        boolean bl = !string2.contains("missing=\"\"");
        hashMap.put("exists", bl);
        if (bl) {
            n2 = string2.indexOf("touched=\"") + 9;
            n = string2.indexOf(34, n2);
            hashMap.put("lastpurged", this.timestampToCalendar(this.convertTimestamp(string2.substring(n2, n))));
            n2 = string2.indexOf("lastrevid=\"") + 11;
            n = string2.indexOf(34, n2);
            hashMap.put("lastrevid", Long.parseLong(string2.substring(n2, n)));
            n2 = string2.indexOf("length=\"") + 8;
            n = string2.indexOf(34, n2);
            hashMap.put("size", Integer.parseInt(string2.substring(n2, n)));
            int n3 = string2.indexOf("type=\"edit\"");
            if (n3 != -1) {
                String string3 = string2.substring(n3, n3 + 30);
                if (string3.contains("sysop")) {
                    hashMap.put("protection", 2);
                } else {
                    string3 = string2.substring(n3 + 30);
                    hashMap.put("protection", string2.contains("level=\"sysop\"") ? 4 : 1);
                }
            } else {
                hashMap.put("protection", string2.contains("type=\"move\"") ? 3 : -1);
            }
        } else {
            hashMap.put("lastedited", null);
            hashMap.put("lastrevid", -1L);
            hashMap.put("size", -1);
            hashMap.put("protection", string2.contains("type=\"create\"") ? 5 : -1);
        }
        hashMap.put("cascade", string2.contains("cascade=\"\""));
        n2 = string2.indexOf("displaytitle=\"") + 14;
        n = string2.indexOf(34, n2);
        hashMap.put("displaytitle", string2.substring(n2, n));
        n2 = string2.indexOf("edittoken=\"") + 11;
        n = string2.indexOf(34, n2);
        hashMap.put("token", string2.substring(n2, n));
        n2 = string2.indexOf("watchtoken=\"") + 12;
        n = string2.indexOf(34, n2);
        hashMap.put("watchtoken", string2.substring(n2, n));
        hashMap.put("timestamp", this.makeCalendar());
        this.log(Level.INFO, "Successfully retrieved page info for " + string, "getPageInfo");
        return hashMap;
    }

    public int getProtectionLevel(String string) throws IOException {
        HashMap<String, Object> hashMap = this.getPageInfo(string);
        if (((Boolean)hashMap.get("cascade")).booleanValue()) {
            return 2;
        }
        return (Integer)hashMap.get("protection");
    }

    public int namespace(String string) throws IOException {
        if (!(string = this.normalize(string)).contains(":")) {
            return 0;
        }
        String string2 = string.substring(0, string.indexOf(58));
        if (string2.equals("Project_talk")) {
            return 5;
        }
        if (string2.equals("Project")) {
            return 4;
        }
        if (this.namespaces == null) {
            this.populateNamespaceCache();
        }
        if (!this.namespaces.containsKey(string2)) {
            return 0;
        }
        return this.namespaces.get(string2);
    }

    public String namespaceIdentifier(int n) throws IOException {
        if (this.namespaces == null) {
            this.populateNamespaceCache();
        }
        if (!this.namespaces.containsValue(n)) {
            return ALL_LOGS;
        }
        for (Map.Entry<String, Integer> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals(n)) continue;
            return entry.getKey();
        }
        return ALL_LOGS;
    }

    protected void populateNamespaceCache() throws IOException {
        String string = this.fetch(this.query + "meta=siteinfo&siprop=namespaces", "namespace");
        this.namespaces = new HashMap(30);
        while (string.contains("<ns")) {
            int n = string.indexOf("<ns id=");
            if (string.charAt(n + 8) == '0') {
                string = string.substring(13);
                continue;
            }
            int n2 = string.indexOf("</ns>");
            String string2 = string.substring(n + 8, n2);
            int n3 = Integer.parseInt(string2.substring(0, string2.indexOf(34)));
            String string3 = string2.substring(string2.indexOf(62) + 1);
            this.namespaces.put(this.normalize(string3), new Integer(n3));
            string = string.substring(n2 + 5);
        }
        this.log(Level.INFO, "Successfully retrieved namespace list (" + (this.namespaces.size() + 1) + " namespaces)", "namespace");
    }

    public boolean[] exists(String ... stringArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(15000);
        StringBuilder stringBuilder2 = new StringBuilder(1000);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("{{#ifexist:");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("|1|0}}");
            if (i % 500 != 499 && i != stringArray.length - 1) continue;
            stringBuilder2.append(this.parseAndCleanup(stringBuilder.toString()));
            stringBuilder = new StringBuilder(15000);
        }
        char[] cArray = stringBuilder2.toString().toCharArray();
        boolean[] blArray = new boolean[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '1' && cArray[i] != '0') {
                throw new UnknownError("Unable to parse output. Perhaps the ParserFunctions extension is not installed, or this is a bug.");
            }
            blArray[i] = cArray[i] == '1';
        }
        return blArray;
    }

    public String getPageText(String string) throws IOException {
        if (this.namespace(string) < 0) {
            throw new UnsupportedOperationException("Cannot retrieve Special: or Media: pages!");
        }
        String string2 = this.base + URLEncoder.encode(this.normalize(string), "UTF-8") + "&action=raw";
        String string3 = this.fetch(string2, "getPageText");
        this.log(Level.INFO, "Successfully retrieved text of " + string, "getPageText");
        return this.decode(string3);
    }

    public String getSectionText(String string, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=revisions&rvprop=content&titles=");
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append("&rvsection=");
        stringBuilder.append(n);
        String string2 = this.fetch(stringBuilder.toString(), "getSectionText");
        if (string2.contains("<error code=\"rvnosuchsection\"")) {
            throw new IllegalArgumentException("There is no section " + n + " in the page " + string);
        }
        if (!string2.contains("</rev>")) {
            return ALL_LOGS;
        }
        int n2 = string2.indexOf("xml:space=\"preserve\">") + 21;
        int n3 = string2.indexOf("</rev>", n2);
        return this.decode(string2.substring(n2, n3));
    }

    public String getRenderedText(String string) throws IOException {
        return this.parse("{{:" + string + "}}");
    }

    public void edit(String string, String string2, String string3) throws IOException, LoginException {
        this.edit(string, string2, string3, this.markminor, this.markbot, -2, null);
    }

    public void edit(String string, String string2, String string3, Calendar calendar) throws IOException, LoginException {
        this.edit(string, string2, string3, this.markminor, this.markbot, -2, calendar);
    }

    public void edit(String string, String string2, String string3, int n) throws IOException, LoginException {
        this.edit(string, string2, string3, this.markminor, this.markbot, n, null);
    }

    public void edit(String string, String string2, String string3, int n, Calendar calendar) throws IOException, LoginException {
        this.edit(string, string2, string3, this.markminor, this.markbot, n, calendar);
    }

    public synchronized void edit(String string, String string2, String string3, boolean bl, boolean bl2, int n, Calendar calendar) throws IOException, LoginException {
        long l = System.currentTimeMillis();
        this.statusCheck();
        HashMap<String, Object> hashMap = this.getPageInfo(string);
        int n2 = (Integer)hashMap.get("protection");
        if (!this.checkRights(n2, false)) {
            CredentialException credentialException = new CredentialException("Permission denied: page is protected.");
            logger.logp(Level.WARNING, "Wiki", "edit()", "[" + this.getDomain() + "] Cannot edit - permission denied.", credentialException);
            throw credentialException;
        }
        String string4 = (String)hashMap.get("token");
        StringBuilder stringBuilder = new StringBuilder(300000);
        stringBuilder.append("title=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        stringBuilder.append("&text=");
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
        stringBuilder.append("&summary=");
        stringBuilder.append(URLEncoder.encode(string3, "UTF-8"));
        stringBuilder.append("&token=");
        stringBuilder.append(URLEncoder.encode(string4, "UTF-8"));
        if (calendar != null) {
            stringBuilder.append("&starttimestamp=");
            stringBuilder.append(this.calendarToTimestamp((Calendar)hashMap.get("timestamp")));
            stringBuilder.append("&basetimestamp=");
            stringBuilder.append(this.calendarToTimestamp(calendar));
        }
        if (bl) {
            stringBuilder.append("&minor=1");
        }
        if (bl2 && this.user.isAllowedTo("bot")) {
            stringBuilder.append("&bot=1");
        }
        if (n == -1) {
            stringBuilder.append("&section=new");
        } else if (n != -2) {
            stringBuilder.append("&section=");
            stringBuilder.append(n);
        }
        String string5 = this.post(this.apiUrl + "action=edit", stringBuilder.toString(), "edit");
        if (string5.contains("error code=\"editconflict\"")) {
            this.log(Level.WARNING, "Edit conflict on " + string, "edit");
            return;
        }
        try {
            this.checkErrors(string5, "edit");
        }
        catch (IOException iOException) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "Exception: " + iOException.getMessage() + " Retrying...", "edit");
                this.edit(string, string2, string3, bl, bl2, n, calendar);
            }
            logger.logp(Level.SEVERE, "Wiki", "edit()", "[" + this.domain + "] EXCEPTION:  ", iOException);
            throw iOException;
        }
        if (this.retry) {
            this.log(Level.INFO, "Successfully edited " + string, "edit");
        }
        this.retry = true;
        try {
            long l2 = (long)this.throttle - System.currentTimeMillis() + l;
            if (l2 > 0L) {
                Thread.sleep(l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void newSection(String string, String string2, String string3, boolean bl, boolean bl2) throws IOException, LoginException {
        this.edit(string, string3, string2, bl, bl2, -1, null);
    }

    public void prepend(String string, String string2, String string3, boolean bl, boolean bl2) throws IOException, LoginException {
        StringBuilder stringBuilder = new StringBuilder(100000);
        stringBuilder.append(string2);
        stringBuilder.append(this.getSectionText(string, 0));
        this.edit(string, stringBuilder.toString(), string3, bl, bl2, 0, null);
    }

    public synchronized void delete(String string, String string2) throws IOException, LoginException {
        long l = System.currentTimeMillis();
        this.statusCheck();
        if (this.user == null || !this.user.isAllowedTo(DELETION_LOG)) {
            throw new CredentialNotFoundException("Cannot delete: Permission denied");
        }
        HashMap<String, Object> hashMap = this.getPageInfo(string);
        if (!((Boolean)hashMap.get("exists")).booleanValue()) {
            logger.log(Level.INFO, "Page \"{0}\" does not exist.", string);
            return;
        }
        String string3 = (String)hashMap.get("token");
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("title=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        stringBuilder.append("&reason=");
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
        stringBuilder.append("&token=");
        stringBuilder.append(URLEncoder.encode(string3, "UTF-8"));
        String string4 = this.post(this.apiUrl + "action=delete", stringBuilder.toString(), DELETION_LOG);
        try {
            if (!string4.contains("<delete title=")) {
                this.checkErrors(string4, DELETION_LOG);
            }
        }
        catch (IOException iOException) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "Exception: " + iOException.getMessage() + " Retrying...", DELETION_LOG);
                this.delete(string, string2);
            }
            logger.logp(Level.SEVERE, "Wiki", "delete()", "[" + this.domain + "] EXCEPTION:  ", iOException);
            throw iOException;
        }
        if (this.retry) {
            this.log(Level.INFO, "Successfully deleted " + string, DELETION_LOG);
        }
        this.retry = true;
        try {
            long l2 = (long)this.throttle - System.currentTimeMillis() + l;
            if (l2 > 0L) {
                Thread.sleep(l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void purge(boolean bl, String ... stringArray) throws IOException, CredentialNotFoundException {
        if (this.user == null) {
            throw new CredentialNotFoundException("You need to be logged in to purge pages via the API.");
        }
        StringBuilder stringBuilder = new StringBuilder(this.apiUrl);
        StringBuilder stringBuilder2 = new StringBuilder("Successfully purged { \"");
        stringBuilder.append("action=purge");
        if (bl) {
            stringBuilder.append("&forcelinkupdate");
        }
        stringBuilder.append("&titles=");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(URLEncoder.encode(stringArray[i], "UTF-8"));
            stringBuilder2.append(stringArray[i]);
            if (i != stringArray.length - 1) {
                stringBuilder.append("%7C");
                stringBuilder2.append("\", ");
                continue;
            }
            stringBuilder2.append("\" }");
        }
        this.fetch(stringBuilder.toString(), "purge");
        this.log(Level.INFO, stringBuilder2.toString(), "purge");
    }

    public String[] getImagesOnPage(String string) throws IOException {
        String string2 = this.query + "prop=images&imlimit=max&titles=" + URLEncoder.encode(this.normalize(string), "UTF-8");
        String string3 = this.fetch(string2, "getImagesOnPage");
        ArrayList<String> arrayList = new ArrayList<String>(750);
        int n = string3.indexOf("title=\"");
        while (n >= 0) {
            int n2 = string3.indexOf("\" ", n);
            arrayList.add(this.decode(string3.substring(n + 7, n2)));
            n = n2;
            n = string3.indexOf("title=\"", n);
        }
        arrayList.remove(0);
        this.log(Level.INFO, "Successfully retrieved images used on " + string + " (" + arrayList.size() + " images)", "getImagesOnPage");
        return arrayList.toArray(new String[0]);
    }

    public String[] getCategories(String string) throws IOException {
        String string2 = this.query + "prop=categories&cllimit=max&titles=" + URLEncoder.encode(string, "UTF-8");
        String string3 = this.fetch(string2, "getCategories");
        ArrayList<String> arrayList = new ArrayList<String>(750);
        while (string3.contains("title=\"Category:")) {
            int n = string3.indexOf("title=\"Category:") + 7;
            int n2 = string3.indexOf(34, n);
            arrayList.add(string3.substring(n, n2));
            string3 = string3.substring(n2);
        }
        this.log(Level.INFO, "Successfully retrieved categories of " + string + " (" + arrayList.size() + " categories)", "getCategories");
        return arrayList.toArray(new String[0]);
    }

    public String[] getTemplates(String string, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=templates&tllimit=max&titles=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        this.constructNamespaceString(stringBuilder, "tl", nArray);
        String string2 = this.fetch(stringBuilder.toString(), "getTemplates");
        ArrayList<String> arrayList = new ArrayList<String>(750);
        string2 = string2.substring(string2.indexOf("<templates>"));
        while (string2.contains("title=\"")) {
            int n = string2.indexOf("title=\"") + 7;
            int n2 = string2.indexOf(34, n);
            arrayList.add(this.decode(string2.substring(n, n2)));
            string2 = string2.substring(n2);
        }
        this.log(Level.INFO, "Successfully retrieved templates used on " + string + " (" + arrayList.size() + " templates)", "getTemplates");
        return arrayList.toArray(new String[0]);
    }

    public HashMap<String, String> getInterwikiLinks(String string) throws IOException {
        String string2 = this.apiUrl + "action=parse&prop=langlinks&llimit=max&page=" + URLEncoder.encode(string, "UTF-8");
        String string3 = this.fetch(string2, "getInterwikiLinks");
        HashMap<String, String> hashMap = new HashMap<String, String>(750);
        while (string3.contains("lang=\"")) {
            int n = string3.indexOf("lang=\"") + 6;
            int n2 = string3.indexOf(34, n);
            String string4 = string3.substring(n, n2);
            n = string3.indexOf(62, n) + 1;
            n2 = string3.indexOf(60, n);
            String string5 = this.decode(string3.substring(n, n2));
            hashMap.put(string4, string5);
            string3 = string3.substring(n2);
        }
        this.log(Level.INFO, "Successfully retrieved categories used on " + string, "getCategories");
        return hashMap;
    }

    public String[] getLinksOnPage(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=links&pllimit=max&titles=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        String string2 = ALL_LOGS;
        ArrayList<String> arrayList = new ArrayList<String>(750);
        do {
            int n;
            int n2;
            String string3;
            if (!string2.isEmpty()) {
                stringBuilder.append("&plcontinue=");
                stringBuilder.append(string2);
            }
            if ((string3 = this.fetch(stringBuilder.toString(), "getLinksOnPage")).contains("plcontinue")) {
                n2 = string3.indexOf("plcontinue=\"") + 12;
                n = string3.indexOf(34, n2);
                string2 = URLEncoder.encode(string3.substring(n2, n), "UTF-8");
            } else {
                string2 = null;
            }
            n2 = string3.indexOf("title=\"");
            while (n2 >= 0) {
                n = string3.indexOf("\" ", n2);
                arrayList.add(this.decode(string3.substring(n2 + 7, n)));
                n2 = n;
                n2 = string3.indexOf("title=\"", n2);
            }
        } while (string2 != null);
        arrayList.remove(0);
        this.log(Level.INFO, "Successfully retrieved links used on " + string + " (" + arrayList.size() + " links)", "getLinksOnPage");
        return arrayList.toArray(new String[0]);
    }

    public LinkedHashMap<String, String> getSectionMap(String string) throws IOException {
        String string2 = this.apiUrl + "action=parse&text={{:" + URLEncoder.encode(string, "UTF-8") + "}}__TOC__&prop=sections";
        String string3 = this.fetch(string2, "getSectionMap");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(30);
        while (string3.contains("<s ")) {
            int n = string3.indexOf("line=\"") + 6;
            int n2 = string3.indexOf(34, n);
            String string4 = this.decode(string3.substring(n, n2));
            n = string3.indexOf("number=") + 8;
            n2 = string3.indexOf(34, n);
            String string5 = string3.substring(n, n2);
            linkedHashMap.put(string5, string4);
            string3 = string3.substring(n2);
        }
        this.log(Level.INFO, "Successfully retrieved section map for " + string, "getSectionMap");
        return linkedHashMap;
    }

    public Revision getTopRevision(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=revisions&rvlimit=1&rvtoken=rollback&titles=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        stringBuilder.append("&rvprop=timestamp%7Cuser%7Cids%7Cflags%7Csize%7Ccomment");
        String string2 = this.fetch(stringBuilder.toString(), "getTopRevision");
        int n = string2.indexOf("<rev");
        int n2 = string2.indexOf("/>", n);
        if (n < 0) {
            return null;
        }
        return this.parseRevision(string2.substring(n, n2), string);
    }

    public Revision getFirstRevision(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=revisions&rvlimit=1&rvdir=newer&titles=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        stringBuilder.append("&rvprop=timestamp%7Cuser%7Cids%7Cflags%7Csize%7Ccomment");
        String string2 = this.fetch(stringBuilder.toString(), "getFirstRevision");
        int n = string2.indexOf("<rev");
        int n2 = string2.indexOf("/>", n);
        if (n < 0) {
            return null;
        }
        return this.parseRevision(string2.substring(n, n2), string);
    }

    public Revision[] getPageHistory(String string) throws IOException {
        return this.getPageHistory(string, null, null);
    }

    public Revision[] getPageHistory(String string, Calendar calendar, Calendar calendar2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=revisions&rvlimit=max&titles=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        stringBuilder.append("&rvprop=timestamp%7Cuser%7Cids%7Cflags%7Csize%7Ccomment");
        if (calendar2 != null) {
            stringBuilder.append("&rvend=");
            stringBuilder.append(this.calendarToTimestamp(calendar2));
        }
        stringBuilder.append("&rvstart");
        String string2 = "=" + this.calendarToTimestamp(calendar == null ? this.makeCalendar() : calendar);
        ArrayList<Revision> arrayList = new ArrayList<Revision>(1500);
        do {
            int n;
            int n2;
            String string3 = stringBuilder.toString();
            string3 = string2.charAt(0) != '=' ? string3 + "id=" + string2 : string3 + string2;
            String string4 = this.fetch(string3, "getPageHistory");
            if (string4.contains("rvstartid=\"")) {
                n2 = string4.indexOf("rvstartid") + 11;
                n = string4.indexOf(34, n2);
                string2 = string4.substring(n2, n);
            } else {
                string2 = null;
            }
            while (string4.contains("<rev ")) {
                n2 = string4.indexOf("<rev");
                n = string4.indexOf("/>", n2);
                arrayList.add(this.parseRevision(string4.substring(n2, n), string));
                string4 = string4.substring(n);
            }
        } while (string2 != null);
        this.log(Level.INFO, "Successfully retrieved page history of " + string + " (" + arrayList.size() + " revisions)", "getPageHistory");
        return arrayList.toArray(new Revision[0]);
    }

    public void move(String string, String string2, String string3) throws IOException, LoginException {
        this.move(string, string2, string3, false, true, false);
    }

    public synchronized void move(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws IOException, LoginException {
        long l = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo(MOVE_LOG)) {
            CredentialNotFoundException credentialNotFoundException = new CredentialNotFoundException("Permission denied: cannot move pages.");
            logger.logp(Level.SEVERE, "Wiki", "move()", "[" + this.domain + "] Cannot move - permission denied.", credentialNotFoundException);
            throw credentialNotFoundException;
        }
        this.statusCheck();
        int n = this.namespace(string);
        if (n == 6 || n == 14) {
            throw new UnsupportedOperationException("Tried to move a category/image.");
        }
        HashMap<String, Object> hashMap = this.getPageInfo(string);
        if (!((Boolean)hashMap.get("exists")).booleanValue()) {
            throw new IllegalArgumentException("Tried to move a non-existant page!");
        }
        int n2 = (Integer)hashMap.get("protection");
        if (!this.checkRights(n2, true)) {
            CredentialException credentialException = new CredentialException("Permission denied: page is protected.");
            logger.logp(Level.WARNING, "Wiki", "move()", "[" + this.getDomain() + "] Cannot move - permission denied.", credentialException);
            throw credentialException;
        }
        String string4 = (String)hashMap.get("token");
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("from=");
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append("&to=");
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
        stringBuilder.append("&reason=");
        stringBuilder.append(URLEncoder.encode(string3, "UTF-8"));
        stringBuilder.append("&token=");
        stringBuilder.append(URLEncoder.encode(string4, "UTF-8"));
        if (bl2) {
            stringBuilder.append("&movetalk=1");
        }
        if (bl && this.user.isAllowedTo("suppressredirect")) {
            stringBuilder.append("&noredirect=1");
        }
        if (bl3 && this.user.isAllowedTo("move-subpages")) {
            stringBuilder.append("&movesubpages=1");
        }
        String string5 = this.post(this.apiUrl + "action=move", stringBuilder.toString(), MOVE_LOG);
        try {
            if (!string5.contains("move from")) {
                this.checkErrors(string5, MOVE_LOG);
            }
        }
        catch (IOException iOException) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "Exception: " + iOException.getMessage() + " Retrying...", MOVE_LOG);
                this.move(string, string2, string3, bl, bl2, bl3);
            }
            logger.logp(Level.SEVERE, "Wiki", "move()", "[" + this.domain + "] EXCEPTION:  ", iOException);
            throw iOException;
        }
        if (this.retry) {
            this.log(Level.INFO, "Successfully moved " + string + " to " + string2, MOVE_LOG);
        }
        this.retry = true;
        try {
            long l2 = (long)this.throttle - System.currentTimeMillis() + l;
            if (l2 > 0L) {
                Thread.sleep(l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String export(String string) throws IOException {
        return this.fetch(this.query + "export&exportnowrap&titles=" + URLEncoder.encode(this.normalize(string), "UTF-8"), "export");
    }

    public Revision getRevision(long l) throws IOException {
        String string = this.query + "prop=revisions&rvprop=ids%7Ctimestamp%7Cuser%7Ccomment%7Cflags%7Csize&revids=" + l;
        String string2 = this.fetch(string, "getRevision");
        if (string2.contains("<badrevids>")) {
            return null;
        }
        return this.parseRevision(string2, ALL_LOGS);
    }

    public void rollback(Revision revision) throws IOException, LoginException {
        this.rollback(revision, this.markbot, ALL_LOGS);
    }

    public synchronized void rollback(Revision revision, boolean bl, String string) throws IOException, LoginException {
        if (this.user == null || !this.user.isAllowedTo("rollback")) {
            throw new CredentialNotFoundException("Permission denied: cannot rollback.");
        }
        this.statusCheck();
        if (!this.cookies.containsValue(this.user.getUsername())) {
            logger.log(Level.SEVERE, "Cookies have expired.");
            this.logout();
            throw new CredentialExpiredException("Cookies have expired.");
        }
        Revision revision2 = this.getTopRevision(revision.getPage());
        if (!revision2.equals(revision)) {
            this.log(Level.INFO, "Rollback failed: revision is not the most recent", "rollback");
            return;
        }
        String string2 = URLEncoder.encode(revision2.getRollbackToken(), "UTF-8");
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("title=");
        stringBuilder.append(revision.getPage());
        stringBuilder.append("&user=");
        stringBuilder.append(revision.getUser());
        stringBuilder.append("&token=");
        stringBuilder.append(string2);
        if (bl && this.user.isAllowedTo("markbotedits")) {
            stringBuilder.append("&markbot=1");
        }
        if (!string.isEmpty()) {
            stringBuilder.append("&summary=");
            stringBuilder.append(string);
        }
        String string3 = this.post(this.apiUrl + "action=rollback", stringBuilder.toString(), "rollback");
        try {
            if (string3.contains("alreadyrolled")) {
                this.log(Level.INFO, "Edit has already been rolled back.", "rollback");
            } else if (string3.contains("onlyauthor")) {
                this.log(Level.INFO, "Cannot rollback as the page only has one author.", "rollback");
            } else if (!string3.contains("rollback title=")) {
                this.checkErrors(string3, "rollback");
            }
        }
        catch (IOException iOException) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "Exception: " + iOException.getMessage() + " Retrying...", "rollback");
                this.rollback(revision, bl, string);
            }
            logger.logp(Level.SEVERE, "Wiki", "rollback()", "[" + this.domain + "] EXCEPTION:  ", iOException);
            throw iOException;
        }
        if (this.retry) {
            this.log(Level.INFO, "Successfully reverted edits by " + this.user + " on " + revision.getPage(), "rollback");
        }
        this.retry = true;
    }

    public synchronized void undo(Revision revision, Revision revision2, String string, boolean bl, boolean bl2) throws IOException, LoginException {
        long l = System.currentTimeMillis();
        this.statusCheck();
        if (revision2 != null && !revision.getPage().equals(revision2.getPage())) {
            throw new IllegalArgumentException("Cannot undo - the revisions supplied are not on the same page!");
        }
        HashMap<String, Object> hashMap = this.getPageInfo(revision.getPage());
        int n = (Integer)hashMap.get("protection");
        if (!this.checkRights(n, false)) {
            CredentialException credentialException = new CredentialException("Permission denied: page is protected.");
            logger.logp(Level.WARNING, "Wiki", "undo()", "[" + this.getDomain() + "] Cannot edit - permission denied.", credentialException);
            throw credentialException;
        }
        String string2 = (String)hashMap.get("token");
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append("title=");
        stringBuilder.append(revision.getPage());
        if (!string.isEmpty()) {
            stringBuilder.append("&summary=");
            stringBuilder.append(string);
        }
        stringBuilder.append("&undo=");
        stringBuilder.append(revision.getRevid());
        if (revision2 != null) {
            stringBuilder.append("&undoafter=");
            stringBuilder.append(revision2.getRevid());
        }
        if (bl) {
            stringBuilder.append("&minor=1");
        }
        if (bl2) {
            stringBuilder.append("&bot=1");
        }
        stringBuilder.append("&token=");
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
        String string3 = this.post(this.apiUrl + "action=edit", stringBuilder.toString(), "undo");
        try {
            this.checkErrors(string3, "undo");
        }
        catch (IOException iOException) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "Exception: " + iOException.getMessage() + " Retrying...", "undo");
                this.undo(revision, revision2, string, bl, bl2);
            }
            logger.logp(Level.SEVERE, "Wiki", "undo()", "[" + this.domain + "] EXCEPTION:  ", iOException);
            throw iOException;
        }
        if (this.retry) {
            String string4 = "Successfully undid revision(s) " + revision.getRevid();
            if (revision2 != null) {
                string4 = string4 + " - " + revision2.getRevid();
            }
            this.log(Level.INFO, string4, "undo");
        }
        this.retry = true;
        try {
            long l2 = (long)this.throttle - System.currentTimeMillis() + l;
            if (l2 > 0L) {
                Thread.sleep(l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Revision parseRevision(String string, String string2) {
        int n;
        int n2 = string.indexOf(" revid=\"") + 8;
        int n3 = string.indexOf(34, n2);
        long l = Long.parseLong(string.substring(n2, n3));
        n2 = string.indexOf("timestamp=\"") + 11;
        n3 = string.indexOf(34, n2);
        Calendar calendar = this.timestampToCalendar(this.convertTimestamp(string.substring(n2, n3)));
        if (string2.isEmpty()) {
            n2 = string.indexOf("title=\"") + 7;
            n3 = string.indexOf(34, n2);
            string2 = this.decode(string.substring(n2, n3));
        }
        String string3 = null;
        if (!string.contains("commenthidden=\"")) {
            n2 = string.indexOf("comment=\"") + 9;
            n3 = string.indexOf(34, n2);
            string3 = n2 == 8 ? ALL_LOGS : this.decode(string.substring(n2, n3));
        }
        String string4 = null;
        if (string.contains("user=\"")) {
            n2 = string.indexOf("user=\"") + 6;
            n3 = string.indexOf(34, n2);
            string4 = this.decode(string.substring(n2, n3));
        }
        boolean bl = string.contains("minor=\"\"");
        boolean bl2 = string.contains("bot=\"\"");
        boolean bl3 = string.contains("new=\"\"");
        if (string.contains("newlen=")) {
            n2 = string.indexOf("newlen=\"") + 8;
            n3 = string.indexOf(34, n2);
            n = Integer.parseInt(string.substring(n2, n3));
        } else if (string.contains("size=\"")) {
            n2 = string.indexOf("size=\"") + 6;
            n3 = string.indexOf(34, n2);
            n = Integer.parseInt(string.substring(n2, n3));
        } else {
            n = 0;
        }
        Revision revision = new Revision(l, calendar, string2, string3, string4, bl, bl2, bl3, n);
        if (string.contains("rcid=\"")) {
            n2 = string.indexOf("rcid=\"") + 6;
            n3 = string.indexOf(34, n2);
            revision.setRcid(Long.parseLong(string.substring(n2, n3)));
        }
        if (string.contains("rollbacktoken=\"")) {
            n2 = string.indexOf("rollbacktoken=\"") + 15;
            n3 = string.indexOf(34, n2);
            revision.setRollbackToken(string.substring(n2, n3));
        }
        return revision;
    }

    public byte[] getImage(String string) throws IOException {
        return this.getImage(string, -1, -1);
    }

    public byte[] getImage(String string, int n, int n2) throws IOException {
        int n3;
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("prop=imageinfo&iiprop=url&titles=File:");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        stringBuilder.append("&iiurlwidth=");
        stringBuilder.append(n);
        stringBuilder.append("&iiurlheight=");
        stringBuilder.append(n2);
        String string2 = this.fetch(stringBuilder.toString(), "getImage");
        int n4 = string2.indexOf("url=\"") + 5;
        int n5 = string2.indexOf(34, n4);
        String string3 = string2.substring(n4, n5);
        this.logurl(string3, "getImage");
        URLConnection uRLConnection = new URL(string3).openConnection();
        this.setCookies(uRLConnection);
        uRLConnection.connect();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n3 = bufferedInputStream.read()) != -1) {
            byteArrayOutputStream.write(n3);
        }
        this.log(Level.INFO, "Successfully retrieved image \"" + string + "\"", "getImage");
        return byteArrayOutputStream.toByteArray();
    }

    public HashMap<String, Object> getFileMetadata(String string) throws IOException {
        String string2 = this.query + "prop=imageinfo&iiprop=size%7Cmime%7Cmetadata&titles=File:" + URLEncoder.encode(this.normalize(string), "UTF-8");
        String string3 = this.fetch(string2, "getFileMetadata");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(30);
        int n = string3.indexOf("size=\"") + 6;
        int n2 = string3.indexOf(34, n);
        hashMap.put("size", new Integer(string3.substring(n, n2)));
        n = string3.indexOf("width=\"") + 7;
        n2 = string3.indexOf(34, n);
        hashMap.put("width", new Integer(string3.substring(n, n2)));
        n = string3.indexOf("height=\"") + 8;
        n2 = string3.indexOf(34, n);
        hashMap.put("height", new Integer(string3.substring(n, n2)));
        n = string3.indexOf("mime=\"") + 6;
        n2 = string3.indexOf(34, n);
        hashMap.put("mime", string3.substring(n, n2));
        while (string3.contains("metadata name=\"")) {
            n = string3.indexOf("name=\"") + 6;
            n2 = string3.indexOf(34, n);
            String string4 = string3.substring(n, n2);
            n = string3.indexOf("value=\"") + 7;
            n2 = string3.indexOf(34, n);
            String string5 = string3.substring(n, n2);
            hashMap.put(string4, string5);
            string3 = string3.substring(n2);
        }
        return hashMap;
    }

    public String[] getDuplicates(String string) throws IOException {
        String string2 = this.query + "prop=duplicatefiles&dflimit=max&titles=File:" + URLEncoder.encode(string, "UTF-8");
        String string3 = this.fetch(string2, "getDuplicates");
        ArrayList<String> arrayList = new ArrayList<String>(10);
        while (string3.contains("<df ")) {
            int n = string3.indexOf("name=") + 6;
            int n2 = string3.indexOf(34, n);
            arrayList.add("File:" + string3.substring(n, n2));
            string3 = string3.substring(n2);
        }
        this.log(Level.INFO, "Successfully retrieved duplicates of File:" + string + " (" + arrayList.size() + " files)", "getDuplicates");
        return arrayList.toArray(new String[0]);
    }

    public LogEntry[] getImageHistory(String string) throws IOException {
        String string2 = this.query + "prop=imageinfo&iiprop=timestamp%7Cuser%7Ccomment&iilimit=max&titles=File:" + URLEncoder.encode(this.normalize(string), "UTF-8");
        String string3 = this.fetch(string2, "getImageHistory");
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>(40);
        while (string3.contains("<ii ")) {
            int n = string3.indexOf("<ii");
            int n2 = string3.indexOf(62, n);
            LogEntry logEntry = this.parseLogEntry(string3.substring(n, n2), 2);
            logEntry.target = string;
            arrayList.add(logEntry);
            string3 = string3.substring(n2);
        }
        LogEntry logEntry = (LogEntry)arrayList.get(arrayList.size() - 1);
        logEntry.action = UPLOAD_LOG;
        arrayList.set(arrayList.size() - 1, logEntry);
        return arrayList.toArray(new LogEntry[0]);
    }

    public byte[] getOldImage(LogEntry logEntry) throws IOException {
        if (!logEntry.getType().equals(UPLOAD_LOG)) {
            throw new IllegalArgumentException("You must provide an upload log entry!");
        }
        String string = logEntry.getTarget();
        String string2 = this.query + "prop=imageinfo&iilimit=max&iiprop=timestamp%7Curl%7Carchivename&titles=File:" + string;
        String string3 = this.fetch(string2, "getOldImage");
        while (string3.contains("<ii ")) {
            int n;
            int n2 = string3.indexOf("timestamp=") + 11;
            String string4 = this.convertTimestamp(string3.substring(n2, n = string3.indexOf(34, n2)));
            if (string4.equals(this.calendarToTimestamp(logEntry.getTimestamp()))) {
                int n3;
                n2 = string3.indexOf(" url=\"") + 6;
                n = string3.indexOf(34, n2);
                string2 = string3.substring(n2, n);
                this.logurl(string2, "getOldImage");
                URLConnection uRLConnection = new URL(string2).openConnection();
                this.setCookies(uRLConnection);
                uRLConnection.connect();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n3 = bufferedInputStream.read()) != -1) {
                    byteArrayOutputStream.write(n3);
                }
                n2 = string3.indexOf("archivename=\"") + 13;
                n = string3.indexOf(34, n2);
                String string5 = string3.substring(n2, n);
                this.log(Level.INFO, "Successfully retrieved old image \"" + string5 + "\"", "getImage");
                return byteArrayOutputStream.toByteArray();
            }
            string3 = string3.substring(n + 10);
        }
        return null;
    }

    public synchronized void upload(File file, String string, String string2, String string3) throws IOException, LoginException {
        Object object;
        long l = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo(UPLOAD_LOG)) {
            CredentialNotFoundException credentialNotFoundException = new CredentialNotFoundException("Permission denied: cannot upload files.");
            logger.logp(Level.SEVERE, "Wiki", "upload()", "[" + this.domain + "] Cannot upload - permission denied.", credentialNotFoundException);
            throw credentialNotFoundException;
        }
        this.statusCheck();
        HashMap<String, Object> hashMap = this.getPageInfo("File:" + string);
        int n = (Integer)hashMap.get("protection");
        if (!this.checkRights(n, false)) {
            CredentialException credentialException = new CredentialException("Permission denied: page is protected.");
            logger.logp(Level.WARNING, "Wiki", "upload()", "[" + this.getDomain() + "] Cannot upload - permission denied.", credentialException);
            throw credentialException;
        }
        String string4 = (String)hashMap.get("token");
        long l2 = file.length();
        long l3 = (l2 >> 22) + 1L;
        FileInputStream fileInputStream = new FileInputStream(file);
        String string5 = ALL_LOGS;
        int n2 = 0;
        while ((long)n2 < l3) {
            Object object2;
            object = new HashMap<String, Object>(50);
            ((HashMap)object).put("filename", string);
            ((HashMap)object).put("token", string4);
            ((HashMap)object).put("ignorewarnings", "true");
            if (l3 == 1L) {
                ((HashMap)object).put("text", string2);
                if (!string3.isEmpty()) {
                    ((HashMap)object).put("comment", string3);
                }
                object2 = new byte[fileInputStream.available()];
                fileInputStream.read((byte[])object2);
                ((HashMap)object).put("file\"; filename=\"" + file.getName(), object2);
            } else {
                long l4 = n2 << 22;
                ((HashMap)object).put("stash", "1");
                ((HashMap)object).put("offset", ALL_LOGS + l4);
                ((HashMap)object).put("filesize", ALL_LOGS + l2);
                if (n2 != 0) {
                    ((HashMap)object).put("filekey", string5);
                }
                long l5 = Math.min(0x400000L, l2 - l4);
                byte[] byArray = new byte[(int)l5];
                fileInputStream.read(byArray);
                ((HashMap)object).put("chunk\"; filename=\"" + file.getName(), byArray);
                string4 = (String)this.getPageInfo("File:" + string).get("token");
            }
            object2 = this.multipartPost(this.apiUrl + "action=upload", (Map<String, ?>)object, UPLOAD_LOG);
            try {
                if (l3 > 1L) {
                    int n3 = ((String)object2).indexOf("filekey=\"") + 9;
                    if (n3 < 0) {
                        throw new IOException("No filekey present! Server response was " + (String)object2);
                    }
                    string5 = ((String)object2).substring(n3, ((String)object2).indexOf(34, n3));
                } else {
                    if (((String)object2).contains("error code=\"fileexists-shared-forbidden\"")) {
                        CredentialException credentialException = new CredentialException("Cannot overwrite file hosted on central repository.");
                        logger.logp(Level.WARNING, "Wiki", "upload()", "[" + this.getDomain() + "] Cannot upload - permission denied.", credentialException);
                        throw credentialException;
                    }
                    this.checkErrors((String)object2, UPLOAD_LOG);
                }
            }
            catch (IOException iOException) {
                fileInputStream.close();
                logger.logp(Level.SEVERE, "Wiki", "upload()", "[" + this.domain + "] EXCEPTION:  ", iOException);
                throw iOException;
            }
            ++n2;
        }
        fileInputStream.close();
        if (l3 > 1L) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>(50);
            hashMap2.put("filename", string);
            hashMap2.put("token", string4);
            hashMap2.put("text", string2);
            if (!string3.isEmpty()) {
                hashMap2.put("comment", string3);
            }
            hashMap2.put("ignorewarnings", "true");
            hashMap2.put("filekey", string5);
            object = this.multipartPost(this.apiUrl + "action=upload", hashMap2, UPLOAD_LOG);
            this.checkErrors((String)object, UPLOAD_LOG);
        }
        try {
            long l6 = (long)this.throttle - System.currentTimeMillis() + l;
            if (l6 > 0L) {
                Thread.sleep(l6);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log(Level.INFO, "Successfully uploaded to File:" + string + ".", UPLOAD_LOG);
    }

    public boolean userExists(String string) throws IOException {
        string = URLEncoder.encode(this.normalize(string), "UTF-8");
        return this.fetch(this.query + "list=users&ususers=" + string, "userExists").contains("userid=\"");
    }

    public String[] allUsers(String string, int n) throws IOException {
        String string2 = this.query + "list=allusers&aulimit=" + (n > this.max ? this.max : n) + "&aufrom=";
        ArrayList<String> arrayList = new ArrayList<String>(6667);
        String string3 = URLEncoder.encode(string, "UTF-8");
        do {
            string3 = URLEncoder.encode(string3, "UTF-8");
            String string4 = this.fetch(string2 + string3, "allUsers");
            int n2 = string4.indexOf("aufrom=\"") + 8;
            string3 = string4.substring(n2, string4.indexOf("\" />", n2));
            int n3 = string4.indexOf("<u ");
            while (n3 >= 0 && arrayList.size() < n) {
                int n4 = string4.indexOf("name=\"", n3) + 6;
                int n5 = string4.indexOf("\"", n4);
                arrayList.add(string4.substring(n4, n5));
                n3 = n5;
                n3 = string4.indexOf("<u ", n3);
            }
        } while (arrayList.size() < n);
        this.log(Level.INFO, "Successfully retrieved user list (" + n + " users starting at " + string + ")", "allUsers");
        return arrayList.toArray(new String[0]);
    }

    public User getUser(String string) throws IOException {
        return this.userExists(string) ? new User(this.normalize(string)) : null;
    }

    public User getCurrentUser() {
        return this.user;
    }

    public Revision[] contribs(String string, int ... nArray) throws IOException {
        return this.contribs(string, ALL_LOGS, null, null, nArray);
    }

    @Deprecated
    public Revision[] rangeContribs(String string) throws IOException {
        int n = string.indexOf(47);
        if (n < 7) {
            throw new NumberFormatException("Not a valid CIDR range!");
        }
        int n2 = Integer.parseInt(string.substring(n + 1));
        String[] stringArray = string.substring(0, n).split("\\.");
        if (stringArray.length != 4) {
            throw new NumberFormatException("Not a valid CIDR range!");
        }
        switch (n2) {
            case 8: {
                return this.contribs(ALL_LOGS, stringArray[0] + ".", null, null, new int[0]);
            }
            case 16: {
                return this.contribs(ALL_LOGS, stringArray[0] + "." + stringArray[1] + ".", null, null, new int[0]);
            }
            case 24: {
                return this.contribs(ALL_LOGS, stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + ".", null, null, new int[0]);
            }
            case 32: {
                return this.contribs(string.substring(0, string.length() - 3), ALL_LOGS, null, null, new int[0]);
            }
        }
        throw new NumberFormatException("Range is not supported.");
    }

    public Revision[] contribs(String string, String string2, Calendar calendar, Calendar calendar2, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=usercontribs&uclimit=max&ucprop=title%7Ctimestamp%7Cflags%7Ccomment%7Cids%7Csize&");
        if (string2.isEmpty()) {
            stringBuilder.append("ucuser=");
            stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        } else {
            stringBuilder.append("ucuserprefix=");
            stringBuilder.append(string2);
        }
        this.constructNamespaceString(stringBuilder, "uc", nArray);
        if (calendar != null) {
            stringBuilder.append("&ucend=");
            stringBuilder.append(this.calendarToTimestamp(calendar));
        }
        if (calendar2 != null) {
            stringBuilder.append("&ucstart=");
            stringBuilder.append(this.calendarToTimestamp(calendar2));
        }
        ArrayList<Revision> arrayList = new ArrayList<Revision>(7500);
        String string3 = ALL_LOGS;
        do {
            int n;
            String string4;
            int n2;
            if ((n2 = (string4 = this.fetch(stringBuilder.toString() + string3, "contribs")).indexOf("uccontinue=\"") + 12) < 12) {
                string3 = null;
            } else {
                n = string4.indexOf(34, n2);
                string3 = "&uccontinue=" + URLEncoder.encode(string4.substring(n2, n), "UTF-8");
            }
            while (string4.contains("<item")) {
                n = string4.indexOf("<item");
                int n3 = string4.indexOf(" />", n);
                arrayList.add(this.parseRevision(string4.substring(n, n3), ALL_LOGS));
                string4 = string4.substring(n3);
            }
        } while (string3 != null);
        this.log(Level.INFO, "Successfully retrived contributions for " + (string2.isEmpty() ? string : string2) + " (" + arrayList.size() + " edits)", "contribs");
        return arrayList.toArray(new Revision[0]);
    }

    public synchronized void emailUser(User user, String string, String string2, boolean bl) throws IOException, LoginException {
        long l = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo("sendemail")) {
            throw new CredentialNotFoundException("Permission denied: cannot email.");
        }
        if (!((Boolean)user.getUserInfo().get("emailable")).booleanValue()) {
            logger.log(Level.WARNING, "User {0} is not emailable", user.getUsername());
            return;
        }
        String string3 = (String)this.getPageInfo("User:" + user.getUsername()).get("token");
        if (!this.cookies.containsValue(user.getUsername())) {
            logger.log(Level.SEVERE, "Cookies have expired.");
            this.logout();
            throw new CredentialExpiredException("Cookies have expired.");
        }
        StringBuilder stringBuilder = new StringBuilder(20000);
        stringBuilder.append("token=");
        stringBuilder.append(URLEncoder.encode(string3, "UTF-8"));
        stringBuilder.append("&target=");
        stringBuilder.append(URLEncoder.encode(user.getUsername(), "UTF-8"));
        if (bl) {
            stringBuilder.append("&ccme=true");
        }
        stringBuilder.append("&text=");
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append("&subject=");
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
        String string4 = this.post(this.apiUrl + "action=emailuser", stringBuilder.toString(), "emailUser");
        this.checkErrors(string4, "email");
        if (string4.contains("error code=\"cantsend\"")) {
            throw new UnsupportedOperationException("Email is disabled for this wiki or you do not have a confirmed email address.");
        }
        try {
            long l2 = (long)this.throttle - System.currentTimeMillis() + l;
            if (l2 > 0L) {
                Thread.sleep(l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log(Level.INFO, "Successfully emailed " + user.getUsername() + ".", "emailUser");
    }

    public void watch(String string) throws IOException, CredentialNotFoundException {
        this.watchInternal(string, false);
        this.watchlist.add(string);
    }

    public void unwatch(String string) throws IOException, CredentialNotFoundException {
        this.watchInternal(string, true);
        this.watchlist.remove(string);
    }

    protected void watchInternal(String string, boolean bl) throws IOException, CredentialNotFoundException {
        String string2;
        String string3 = string2 = bl ? "unwatch" : "watch";
        if (this.watchlist == null) {
            this.getRawWatchlist();
        }
        StringBuilder stringBuilder = new StringBuilder("title=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        if (bl) {
            stringBuilder.append("&unwatch");
        }
        String string4 = (String)this.getPageInfo(string).get("watchtoken");
        stringBuilder.append("&token=");
        stringBuilder.append(URLEncoder.encode(string4, "UTF-8"));
        this.post(this.apiUrl + "action=watch", stringBuilder.toString(), string2);
        this.log(Level.INFO, "Successfully " + string2 + "ed " + string, string2);
    }

    public String[] getRawWatchlist() throws IOException, CredentialNotFoundException {
        return this.getRawWatchlist(true);
    }

    public String[] getRawWatchlist(boolean bl) throws IOException, CredentialNotFoundException {
        if (this.user == null) {
            throw new CredentialNotFoundException("The watchlist is available for registered users only.");
        }
        if (this.watchlist != null && bl) {
            return this.watchlist.toArray(new String[0]);
        }
        String string = this.query + "list=watchlistraw&wrlimit=max";
        String string2 = ALL_LOGS;
        this.watchlist = new ArrayList(750);
        do {
            int n;
            String string3;
            int n2;
            if ((n2 = (string3 = this.fetch(string + string2, "getRawWatchlist")).indexOf("wrcontinue=\"") + 12) > 12) {
                n = string3.indexOf(34, n2);
                string2 = "&wrcontinue=" + URLEncoder.encode(string3.substring(n2, n), "UTF-8");
            } else {
                string2 = null;
            }
            while (string3.contains("<wr ")) {
                n2 = string3.indexOf("title=\"") + 7;
                String string4 = string3.substring(n2, n = string3.indexOf(34, n2));
                if (this.namespace(string4) % 2 == 0) {
                    this.watchlist.add(string4);
                }
                string3 = string3.substring(n);
            }
        } while (string2 != null);
        this.log(Level.INFO, "Successfully retrieved raw watchlist (" + this.watchlist.size() + " items)", "getRawWatchlist");
        return this.watchlist.toArray(new String[0]);
    }

    public boolean isWatched(String string) throws IOException, CredentialNotFoundException {
        if (this.watchlist == null) {
            this.getRawWatchlist();
        }
        return this.watchlist.contains(string);
    }

    public Revision[] watchlist() throws IOException, CredentialNotFoundException {
        return this.watchlist(false, new int[0]);
    }

    public Revision[] watchlist(boolean bl, int ... nArray) throws IOException, CredentialNotFoundException {
        if (this.user == null) {
            throw new CredentialNotFoundException("Not logged in");
        }
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=watchlist&wlprop=ids%7Ctitle%7Ctimestamp%7Cuser%7Ccomment%7Csizes&wllimit=max");
        if (bl) {
            stringBuilder.append("&wlallrev=true");
        }
        this.constructNamespaceString(stringBuilder, "wl", nArray);
        ArrayList<Revision> arrayList = new ArrayList<Revision>(667);
        boolean bl2 = false;
        String string = ALL_LOGS;
        do {
            int n;
            String string2;
            if ((string2 = this.fetch(stringBuilder.toString() + "&wlstart=" + string, "watchlist")).contains("wlstart")) {
                n = string2.indexOf("wlstart") + 9;
                string = string2.substring(n, string2.indexOf(34, n));
            } else {
                bl2 = true;
            }
            n = string2.indexOf("<item ");
            while (n >= 0) {
                int n2 = string2.indexOf("/>", n);
                arrayList.add(this.parseRevision(string2.substring(n, n2), ALL_LOGS));
                n = n2;
                n = string2.indexOf("<item ", n);
            }
        } while (!bl2);
        this.log(Level.INFO, "Successfully retrieved watchlist (" + arrayList.size() + " items)", "watchlist");
        return arrayList.toArray(new Revision[0]);
    }

    public String[][] search(String string, int ... nArray) throws IOException {
        if (nArray.length == 0) {
            nArray = new int[]{0};
        }
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=search&srwhat=text&srprop=snippet%7Csectionsnippet&srlimit=max&srsearch=");
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        this.constructNamespaceString(stringBuilder, "sr", nArray);
        stringBuilder.append("&sroffset=");
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(5000);
        while (!bl) {
            String string2 = this.fetch(stringBuilder.toString() + arrayList.size(), "search");
            if (!string2.contains("sroffset=\"")) {
                bl = true;
            }
            int n = string2.indexOf(" title=\"");
            while (n >= 0) {
                String[] stringArray = new String[3];
                int n2 = n + 8;
                int n3 = string2.indexOf(34, n2);
                stringArray[0] = string2.substring(n2, n3);
                if (string2.contains("sectionsnippet=\"")) {
                    n2 = string2.indexOf("sectionsnippet=\"", n) + 16;
                    n3 = string2.indexOf(34, n2);
                    stringArray[1] = this.decode(string2.substring(n2, n3));
                } else {
                    stringArray[1] = ALL_LOGS;
                }
                n2 = string2.indexOf("snippet=\"", n) + 9;
                n3 = string2.indexOf(34, n2);
                stringArray[2] = this.decode(string2.substring(n2, n3));
                arrayList.add(stringArray);
                n = n2;
                n = string2.indexOf(" title=\"", n);
            }
        }
        this.log(Level.INFO, "Successfully searched for string \"" + string + "\" (" + arrayList.size() + " items found)", "search");
        return (String[][])arrayList.toArray((T[])new String[0][0]);
    }

    public String[] imageUsage(String string, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=imageusage&iulimit=max&iutitle=File:");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        this.constructNamespaceString(stringBuilder, "iu", nArray);
        ArrayList<String> arrayList = new ArrayList<String>(1333);
        String string2 = ALL_LOGS;
        do {
            int n;
            String string3;
            if (!arrayList.isEmpty()) {
                string2 = "&iucontinue=" + string2;
            }
            if ((string3 = this.fetch(stringBuilder + string2, "imageUsage")).contains("iucontinue")) {
                n = string3.indexOf("iucontinue") + 12;
                string2 = string3.substring(n, string3.indexOf("\" />", n));
            } else {
                string2 = null;
            }
            while (string3.contains("title")) {
                n = string3.indexOf("title=\"");
                int n2 = string3.indexOf("\" />", n);
                arrayList.add(this.decode(string3.substring(n + 7, n2)));
                string3 = string3.substring(n2 + 4);
            }
        } while (string2 != null);
        this.log(Level.INFO, "Successfully retrieved usages of File:" + string + " (" + arrayList.size() + " items)", "imageUsage");
        return arrayList.toArray(new String[0]);
    }

    public String[] whatLinksHere(String string, int ... nArray) throws IOException {
        return this.whatLinksHere(string, false, nArray);
    }

    public String[] whatLinksHere(String string, boolean bl, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=backlinks&bllimit=max&bltitle=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        this.constructNamespaceString(stringBuilder, "bl", nArray);
        if (bl) {
            stringBuilder.append("&blfilterredir=redirects");
        }
        ArrayList<String> arrayList = new ArrayList<String>(6667);
        String string2 = stringBuilder.toString();
        String string3 = ALL_LOGS;
        do {
            int n;
            int n2;
            String string4;
            if ((string4 = this.fetch(string2 + string3, "whatLinksHere")).contains("blcontinue")) {
                n2 = string4.indexOf("blcontinue=\"") + 12;
                n = string4.indexOf(34, n2);
                string3 = "&blcontinue=" + string4.substring(n2, n);
            } else {
                string3 = null;
            }
            while (string4.contains("title")) {
                n2 = string4.indexOf("title=\"");
                n = string4.indexOf("\" ", n2);
                arrayList.add(this.decode(string4.substring(n2 + 7, n)));
                string4 = string4.substring(n + 4);
            }
        } while (string3 != null);
        this.log(Level.INFO, "Successfully retrieved " + (bl ? "redirects to " : "links to ") + string + " (" + arrayList.size() + " items)", "whatLinksHere");
        return arrayList.toArray(new String[0]);
    }

    public String[] whatTranscludesHere(String string, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=embeddedin&eilimit=max&eititle=");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        this.constructNamespaceString(stringBuilder, "ei", nArray);
        ArrayList<String> arrayList = new ArrayList<String>(6667);
        String string2 = ALL_LOGS;
        do {
            int n;
            int n2;
            String string3;
            if ((string3 = this.fetch(stringBuilder + string2, "whatTranscludesHere")).contains("eicontinue")) {
                n2 = string3.indexOf("eicontinue=\"") + 12;
                n = string3.indexOf(34, n2);
                string2 = "&eicontinue=" + string3.substring(n2, n);
            } else {
                string2 = "done";
            }
            while (string3.contains("title")) {
                n2 = string3.indexOf("title=\"");
                n = string3.indexOf("\" ", n2);
                arrayList.add(this.decode(string3.substring(n2 + 7, n)));
                string3 = string3.substring(n + 4);
            }
        } while (!string2.equals("done"));
        this.log(Level.INFO, "Successfully retrieved transclusions of " + string + " (" + arrayList.size() + " items)", "whatTranscludesHere");
        return arrayList.toArray(new String[0]);
    }

    public String[] getCategoryMembers(String string, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=categorymembers&cmprop=title&cmlimit=max&cmtitle=Category:");
        stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        this.constructNamespaceString(stringBuilder, "cm", nArray);
        ArrayList<String> arrayList = new ArrayList<String>(6667);
        String string2 = ALL_LOGS;
        do {
            int n;
            String string3;
            if (!arrayList.isEmpty()) {
                string2 = "&cmcontinue=" + URLEncoder.encode(string2, "UTF-8");
            }
            if ((string3 = this.fetch(stringBuilder.toString() + string2, "getCategoryMembers")).contains("cmcontinue")) {
                n = string3.indexOf("cmcontinue") + 12;
                string2 = string3.substring(n, string3.indexOf("\" />", n));
            } else {
                string2 = null;
            }
            n = string3.indexOf("title=\"");
            while (n >= 0) {
                int n2 = string3.indexOf("\" />", n);
                arrayList.add(this.decode(string3.substring(n + 7, n2)));
                n = n2;
                n = string3.indexOf("title=\"", n);
            }
        } while (string2 != null);
        this.log(Level.INFO, "Successfully retrieved contents of Category:" + string + " (" + arrayList.size() + " items)", "getCategoryMembers");
        return arrayList.toArray(new String[0]);
    }

    public ArrayList[] linksearch(String string) throws IOException {
        return this.linksearch(string, "http", new int[0]);
    }

    public ArrayList[] linksearch(String string, String string2, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=exturlusage&euprop=title%7curl&euquery=");
        stringBuilder.append(string);
        stringBuilder.append("&euprotocol=");
        stringBuilder.append(string2);
        stringBuilder.append("&eulimit=max");
        this.constructNamespaceString(stringBuilder, "eu", nArray);
        stringBuilder.append("&euoffset=");
        boolean bl = false;
        ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(667), new ArrayList(667)};
        while (!bl) {
            String string3 = this.fetch(stringBuilder.toString() + arrayListArray[0].size(), "linksearch");
            if (!string3.contains("euoffset=\"")) {
                bl = true;
            }
            int n = string3.indexOf("title=\"");
            while (n >= 0) {
                int n2 = string3.indexOf("\" url=\"", n);
                int n3 = string3.indexOf("\" />", n2);
                String string4 = string3.substring(n + 7, n2);
                String string5 = string3.substring(n2 + 7, n3);
                arrayListArray[0].add(this.decode(string4));
                if (string5.charAt(0) == '/') {
                    arrayListArray[1].add(new URL(string2 + ":" + string5));
                } else {
                    arrayListArray[1].add(new URL(string5));
                }
                n = n3;
                n = string3.indexOf("title=\"", n);
            }
        }
        this.log(Level.INFO, "Successfully returned instances of external link " + string + " (" + arrayListArray[0].size() + " links)", "linksearch");
        return arrayListArray;
    }

    public LogEntry[] getIPBlockList(String string) throws IOException {
        return this.getIPBlockList(string, null, null, 1);
    }

    public LogEntry[] getIPBlockList(Calendar calendar, Calendar calendar2) throws IOException {
        return this.getIPBlockList(ALL_LOGS, calendar, calendar2, Integer.MAX_VALUE);
    }

    protected LogEntry[] getIPBlockList(String string, Calendar calendar, Calendar calendar2, int n) throws IOException {
        CharSequence charSequence;
        if (calendar != null && calendar2 != null && calendar.before(calendar2)) {
            throw new IllegalArgumentException("Specified start date is before specified end date!");
        }
        String string2 = this.calendarToTimestamp(calendar == null ? this.makeCalendar() : calendar);
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=blocks");
        if (calendar2 != null) {
            stringBuilder.append("&bkend=");
            stringBuilder.append(this.calendarToTimestamp(calendar2));
        }
        if (!string.isEmpty()) {
            stringBuilder.append("&bkusers=");
            stringBuilder.append(string);
        }
        stringBuilder.append("&bklimit=");
        stringBuilder.append(n < this.max ? n : this.max);
        stringBuilder.append("&bkstart=");
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>(1333);
        do {
            int n2;
            if (((String)(charSequence = this.fetch(stringBuilder.toString() + string2, "getIPBlockList"))).contains("bkstart")) {
                n2 = ((String)charSequence).indexOf("bkstart=\"") + 9;
                string2 = ((String)charSequence).substring(n2, ((String)charSequence).indexOf(34, n2));
            } else {
                string2 = null;
            }
            while (arrayList.size() < n && ((String)charSequence).contains("<block ")) {
                n2 = ((String)charSequence).indexOf("<block ");
                int n3 = ((String)charSequence).indexOf("/>", n2);
                arrayList.add(this.parseLogEntry(((String)charSequence).substring(n2, n3), 1));
                charSequence = ((String)charSequence).substring(n3);
            }
        } while (string2 != null && arrayList.size() < n);
        charSequence = new StringBuilder("Successfully fetched IP block list ");
        if (!string.isEmpty()) {
            ((StringBuilder)charSequence).append(" for ");
            ((StringBuilder)charSequence).append(string);
        }
        if (calendar != null) {
            ((StringBuilder)charSequence).append(" from ");
            ((StringBuilder)charSequence).append(calendar.getTime().toString());
        }
        if (calendar2 != null) {
            ((StringBuilder)charSequence).append(" to ");
            ((StringBuilder)charSequence).append(calendar2.getTime().toString());
        }
        ((StringBuilder)charSequence).append(" (");
        ((StringBuilder)charSequence).append(arrayList.size());
        ((StringBuilder)charSequence).append(" entries)");
        this.log(Level.INFO, ((StringBuilder)charSequence).toString(), "getIPBlockList");
        return arrayList.toArray(new LogEntry[0]);
    }

    public LogEntry[] getLogEntries(int n) throws IOException {
        return this.getLogEntries(null, null, n, ALL_LOGS, null, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(User user) throws IOException {
        return this.getLogEntries(null, null, Integer.MAX_VALUE, ALL_LOGS, user, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(String string) throws IOException {
        return this.getLogEntries(null, null, Integer.MAX_VALUE, ALL_LOGS, null, string, 167317762);
    }

    public LogEntry[] getLogEntries(Calendar calendar, Calendar calendar2) throws IOException {
        return this.getLogEntries(calendar, calendar2, Integer.MAX_VALUE, ALL_LOGS, null, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(int n, String string) throws IOException {
        return this.getLogEntries(null, null, n, string, null, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(Calendar calendar, Calendar calendar2, int n, String string, User user, String string2, int n2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=logevents&leprop=title%7Ctype%7Cuser%7Ctimestamp%7Ccomment%7Cdetails");
        StringBuilder stringBuilder2 = new StringBuilder("Successfully retrieved ");
        if (n < 1) {
            throw new IllegalArgumentException("Tried to retrieve less than one log entry!");
        }
        if (!string.equals(ALL_LOGS)) {
            stringBuilder.append("&letype=");
            stringBuilder.append(string);
        }
        if (string.equals(USER_CREATION_LOG)) {
            stringBuilder2.append("user creation");
        } else if (string.equals(DELETION_LOG)) {
            stringBuilder2.append("deletion");
        } else if (string.equals(PROTECTION_LOG)) {
            stringBuilder2.append("protection");
        } else if (string.equals(USER_RIGHTS_LOG)) {
            stringBuilder2.append("user rights");
        } else if (string.equals(USER_RENAME_LOG)) {
            stringBuilder2.append("user rename");
        } else {
            stringBuilder2.append(" ");
            stringBuilder2.append(string);
        }
        stringBuilder2.append(" log ");
        if (user != null) {
            stringBuilder.append("&leuser=");
            stringBuilder.append(URLEncoder.encode(user.getUsername(), "UTF-8"));
            stringBuilder2.append("for ");
            stringBuilder2.append(user.getUsername());
            stringBuilder2.append(" ");
        }
        if (!string2.isEmpty()) {
            stringBuilder.append("&letitle=");
            stringBuilder.append(URLEncoder.encode(this.normalize(string2), "UTF-8"));
            stringBuilder2.append("on ");
            stringBuilder2.append(string2);
            stringBuilder2.append(" ");
        }
        stringBuilder.append("&lelimit=");
        stringBuilder.append(n > this.max || n2 != 167317762 ? this.max : n);
        String string3 = ALL_LOGS;
        if (calendar != null) {
            if (calendar2 != null && calendar.before(calendar2)) {
                throw new IllegalArgumentException("Specified start date is before specified end date!");
            }
            string3 = this.calendarToTimestamp(calendar).toString();
            stringBuilder2.append("from ");
            stringBuilder2.append(calendar.getTime().toString());
            stringBuilder2.append(" ");
        }
        if (calendar2 != null) {
            stringBuilder.append("&leend=");
            stringBuilder.append(this.calendarToTimestamp(calendar2));
            stringBuilder2.append("to ");
            stringBuilder2.append(calendar2.getTime().toString());
            stringBuilder2.append(" ");
        }
        ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>(6667);
        do {
            int n3;
            String string4;
            if ((string4 = this.fetch(stringBuilder.toString() + "&lestart=" + string3, "getLogEntries")).contains("lestart=\"")) {
                n3 = string4.indexOf("lestart=\"") + 9;
                string3 = string4.substring(n3, string4.indexOf(34, n3));
            } else {
                string3 = null;
            }
            while (string4.contains("<item") && arrayList.size() < n) {
                n3 = string4.indexOf("<item");
                int n4 = string4.indexOf("><item", n3);
                if (n4 < 0) {
                    n4 = string4.length();
                }
                LogEntry logEntry = this.parseLogEntry(string4.substring(n3, n4), 0);
                string4 = string4.substring(n4);
                if (n2 != 167317762 && this.namespace(logEntry.getTarget()) != n2) continue;
                arrayList.add(logEntry);
            }
        } while (arrayList.size() < n && string3 != null);
        stringBuilder2.append(" (");
        stringBuilder2.append(arrayList.size());
        stringBuilder2.append(" entries)");
        this.log(Level.INFO, stringBuilder2.toString(), "getLogEntries");
        return arrayList.toArray(new LogEntry[0]);
    }

    protected LogEntry parseLogEntry(String string, int n) {
        int n2;
        int n3;
        String string2;
        int n4;
        String string3;
        String string4 = null;
        if (n == 1) {
            string3 = BLOCK_LOG;
            string4 = BLOCK_LOG;
        } else if (n == 2) {
            string3 = UPLOAD_LOG;
            string4 = "overwrite";
        } else {
            int n5 = string.indexOf("type=\"") + 6;
            n4 = string.indexOf("\" ", n5);
            string3 = string.substring(n5, n4);
            if (!string.contains("actionhidden=\"")) {
                n5 = string.indexOf("action=\"") + 8;
                n4 = string.indexOf("\" ", n5);
                string4 = string.substring(n5, n4);
            }
        }
        if (string.contains("commenthidden=\"")) {
            string2 = null;
        } else if (string3.equals(USER_CREATION_LOG)) {
            string2 = ALL_LOGS;
        } else {
            n4 = n == 1 ? string.indexOf("reason=\"") + 8 : string.indexOf("comment=\"") + 9;
            int n6 = string.indexOf(34, n4);
            string2 = this.decode(string.substring(n4, n6));
        }
        String string5 = null;
        User user = null;
        if (n == 1) {
            n3 = string.indexOf("by=\"") + 4;
            n2 = string.indexOf(34, n3);
            user = new User(this.decode(string.substring(n3, n2)));
            n3 = string.indexOf("user=\"") + 6;
            if (n3 < 6) {
                n3 = string.indexOf("id=\"") + 4;
                n2 = string.indexOf("\" ", n3);
                string5 = "#" + string.substring(n3, n2);
            } else {
                n2 = string.indexOf("\" ", n3);
                string5 = this.decode(string.substring(n3, n2));
            }
        } else if (!string.contains("userhidden=\"") && string.contains("title=\"")) {
            n3 = string.indexOf("user=\"") + 6;
            n2 = string.indexOf("\" ", n3);
            user = new User(this.decode(string.substring(n3, n2)));
            n3 = string.indexOf("title=\"") + 7;
            n2 = string.indexOf("\" ", n3);
            string5 = this.decode(string.substring(n3, n2));
        } else if (n == 2) {
            n3 = string.indexOf("user=\"") + 6;
            n2 = string.indexOf("\" ", n3);
            user = new User(this.decode(string.substring(n3, n2)));
        }
        n3 = string.indexOf("timestamp=\"") + 11;
        n2 = n3 + 20;
        String string6 = this.convertTimestamp(string.substring(n3, n2));
        Object object = null;
        if (string.contains("commenthidden")) {
            object = null;
        } else if (string3.equals(MOVE_LOG)) {
            n3 = string.indexOf("new_title=\"") + 11;
            n2 = string.indexOf("\" />", n3);
            object = this.decode(this.decode(string.substring(n3, n2)));
        } else if (string3.equals(BLOCK_LOG)) {
            int n7;
            n3 = string.indexOf("<block") + 7;
            String string7 = string.substring(n3);
            int n8 = n7 = n == 1 ? string7.indexOf("expiry=") + 8 : string7.indexOf("duration=") + 10;
            if (n7 > 10) {
                int n9 = string7.indexOf(34, n7);
                object = new Object[]{string7.contains("anononly"), string7.contains("nocreate"), string7.contains("noautoblock"), string7.contains("noemail"), string7.contains("nousertalk"), string7.substring(n7, n9)};
            }
        } else if (string3.equals(PROTECTION_LOG)) {
            if (string4.equals("unprotect")) {
                object = null;
            } else {
                n3 = string.indexOf("<param>") + 7;
                n2 = string.indexOf("</param>", n3);
                String string8 = string.substring(n3, n2);
                if (string4.equals("move_prot")) {
                    object = string8;
                } else if (string4.equals(PROTECTION_LOG) || string4.equals("modify")) {
                    object = string8.contains("create=sysop") ? Integer.valueOf(5) : (string8.contains("edit=sysop") ? Integer.valueOf(2) : (string8.contains("move=autoconfirmed") ? Integer.valueOf(1) : (string8.contains("edit=autoconfirmed") ? Integer.valueOf(4) : (string8.contains("move=sysop") ? Integer.valueOf(3) : Integer.valueOf(-2)))));
                }
            }
        } else if (string3.equals(USER_RENAME_LOG)) {
            n3 = string.indexOf("<param>") + 7;
            n2 = string.indexOf("</param>", n3);
            object = this.decode(string.substring(n3, n2));
        } else if (string3.equals(USER_RIGHTS_LOG)) {
            n3 = string.indexOf("new=\"") + 5;
            n2 = string.indexOf(34, n3);
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n3, n2), ", ");
            ArrayList<String> arrayList = new ArrayList<String>(10);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            object = arrayList.toArray(new String[0]);
        }
        return new LogEntry(string3, string4, string2, user, string5, string6, object);
    }

    public String[] prefixIndex(String string) throws IOException {
        return this.listPages(string, -1, 167317762, -1, -1);
    }

    public String[] shortPages(int n) throws IOException {
        return this.listPages(ALL_LOGS, -1, 0, -1, n);
    }

    public String[] shortPages(int n, int n2) throws IOException {
        return this.listPages(ALL_LOGS, -1, n2, -1, n);
    }

    public String[] longPages(int n) throws IOException {
        return this.listPages(ALL_LOGS, -1, 0, n, -1);
    }

    public String[] longPages(int n, int n2) throws IOException {
        return this.listPages(ALL_LOGS, -1, n2, n, -1);
    }

    public String[] listPages(String string, int n, int n2) throws IOException {
        return this.listPages(string, n, n2, -1, -1);
    }

    public String[] listPages(String string, int n, int n2, int n3, int n4) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=allpages&aplimit=max");
        if (!string.isEmpty()) {
            n2 = this.namespace(string);
            if (string.contains(":") && n2 != 0) {
                string = string.substring(string.indexOf(58) + 1);
            }
            stringBuilder.append("&apprefix=");
            stringBuilder.append(URLEncoder.encode(this.normalize(string), "UTF-8"));
        } else if (n2 == 167317762) {
            throw new UnsupportedOperationException("ALL_NAMESPACES not supported in MediaWiki API.");
        }
        stringBuilder.append("&apnamespace=");
        stringBuilder.append(n2);
        switch (n) {
            case -1: {
                break;
            }
            case 1: {
                stringBuilder.append("&apprlevel=autoconfirmed&apprtype=edit");
                break;
            }
            case 2: {
                stringBuilder.append("&apprlevel=sysop&apprtype=edit");
                break;
            }
            case 3: {
                stringBuilder.append("&apprlevel=sysop&apprtype=move");
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid protection level!");
            }
        }
        if (n3 != -1) {
            stringBuilder.append("&apminsize=");
            stringBuilder.append(n3);
        }
        if (n4 != -1) {
            stringBuilder.append("&apmaxsize=");
            stringBuilder.append(n4);
        }
        ArrayList<String> arrayList = new ArrayList<String>(6667);
        String string2 = ALL_LOGS;
        do {
            int n5;
            int n6;
            String string3 = stringBuilder.toString();
            if (!string2.isEmpty()) {
                string3 = string3 + "&apfrom=" + string2;
            }
            String string4 = this.fetch(string3, "listPages");
            if (n4 < 0 && n3 < 0 && string.isEmpty() && n == -1) {
                string2 = null;
            } else if (string4.contains("apfrom=")) {
                n6 = string4.indexOf("apfrom=\"") + 8;
                n5 = string4.indexOf(34, n6);
                string2 = URLEncoder.encode(string4.substring(n6, n5), "UTF-8");
            } else {
                string2 = null;
            }
            while (string4.contains("<p ")) {
                n6 = string4.indexOf("title=\"") + 7;
                n5 = string4.indexOf("\" />", n6);
                arrayList.add(this.decode(string4.substring(n6, n5)));
                string4 = string4.substring(n5);
            }
        } while (string2 != null);
        this.log(Level.INFO, "Successfully retrieved page list (" + arrayList.size() + " pages)", "listPages");
        return arrayList.toArray(new String[0]);
    }

    public String[] queryPage(String string) throws IOException, CredentialNotFoundException {
        if (string.equals("Unwatchedpages") && (this.user == null || !this.user.isAllowedTo("unwatchedpages"))) {
            throw new CredentialNotFoundException("User does not have the \"unwatchedpages\" permission.");
        }
        String string2 = this.query + "action=query&list=querypage&qplimit=max&qppage=" + string + "&qpcontinue=";
        String string3 = ALL_LOGS;
        ArrayList<String> arrayList = new ArrayList<String>(1333);
        do {
            int n;
            int n2;
            String string4;
            if ((string4 = this.fetch(string2 + string3, "queryPage")).contains("qpoffset")) {
                n2 = string4.indexOf("qpoffset=\"") + 10;
                n = string4.indexOf("\"", n2);
                string3 = string4.substring(n2, n);
            } else {
                string3 = null;
            }
            n2 = string4.indexOf(" title=\"") + 8;
            while (n2 >= 8) {
                n = string4.indexOf("\"", n2);
                arrayList.add(this.decode(string4.substring(n2, n)));
                n2 = n;
                n2 = string4.indexOf(" title=\"", n2) + 8;
            }
        } while (string3 != null);
        int n = arrayList.size();
        this.log(Level.INFO, "Successfully retrieved [[Special:" + string + "]] (" + n + " pages)", "queryPage");
        return arrayList.toArray(new String[n]);
    }

    public Revision[] newPages(int n) throws IOException {
        return this.recentChanges(n, 0, true, 0);
    }

    public Revision[] newPages(int n, int n2) throws IOException {
        return this.recentChanges(n, n2, true, 0);
    }

    public Revision[] newPages(int n, int n2, int ... nArray) throws IOException {
        return this.recentChanges(n, n2, true, nArray);
    }

    public Revision[] recentChanges(int n) throws IOException {
        return this.recentChanges(n, 0, false, 0);
    }

    public Revision[] recentChanges(int n, int ... nArray) throws IOException {
        return this.recentChanges(n, 0, false, nArray);
    }

    public Revision[] recentChanges(int n, int n2, int ... nArray) throws IOException {
        return this.recentChanges(n, n2, false, nArray);
    }

    protected Revision[] recentChanges(int n, int n2, boolean bl, int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=recentchanges&rcprop=title%7Cids%7Cuser%7Ctimestamp%7Cflags%7Ccomment%7Csizes&rclimit=max");
        this.constructNamespaceString(stringBuilder, "rc", nArray);
        if (bl) {
            stringBuilder.append("&rctype=new");
        }
        if (n2 > 0) {
            stringBuilder.append("&rcshow=");
            if ((n2 & 1) == 1) {
                stringBuilder.append("!anon%7C");
            }
            if ((n2 & 4) == 4) {
                stringBuilder.append("!self%7C");
            }
            if ((n2 & 8) == 8) {
                stringBuilder.append("!minor%7C");
            }
            if ((n2 & 0x10) == 16) {
                stringBuilder.append("!patrolled%7C");
            }
            if ((n2 & 2) == 2) {
                stringBuilder.append("!bot%7C");
            }
            stringBuilder.delete(stringBuilder.length() - 3, stringBuilder.length());
        }
        stringBuilder.append("&rcstart=");
        String string = this.calendarToTimestamp(this.makeCalendar());
        ArrayList<Revision> arrayList = new ArrayList<Revision>(750);
        do {
            String string2 = stringBuilder.toString();
            String string3 = this.fetch(string2 + string, bl ? "newPages" : "recentChanges");
            int n3 = string3.indexOf("rcstart=\"") + 9;
            int n4 = string3.indexOf(34, n3);
            string = string3.substring(n3, n4);
            int n5 = string3.indexOf("<rc ");
            while (n5 >= 0 && arrayList.size() < n) {
                int n6 = string3.indexOf("/>", n5);
                arrayList.add(this.parseRevision(string3.substring(n5, n6), ALL_LOGS));
                n5 = n6;
                n5 = string3.indexOf("<rc ", n5);
            }
        } while (arrayList.size() < n);
        int n7 = arrayList.size();
        this.log(Level.INFO, "Successfully retrieved recent changes (" + n7 + " revisions)", "recentChanges");
        return arrayList.toArray(new Revision[n7]);
    }

    public String[][] getInterWikiBacklinks(String string) throws IOException {
        return this.getInterWikiBacklinks(string, "|");
    }

    public String[][] getInterWikiBacklinks(String string, String string2) throws IOException {
        if (string2.equals("|") && string.isEmpty()) {
            throw new IllegalArgumentException("Interwiki backlinks: title specified without prefix!");
        }
        StringBuilder stringBuilder = new StringBuilder(this.query);
        stringBuilder.append("list=iwbacklinks&iwbllimit=max&iwblprefix=");
        stringBuilder.append(string);
        if (!string2.equals("|")) {
            stringBuilder.append("&iwbltitle=");
            stringBuilder.append(string2);
        }
        stringBuilder.append("&iwblprop=iwtitle%7Ciwprefix");
        String string3 = ALL_LOGS;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(500);
        do {
            int n;
            int n2;
            String string4 = ALL_LOGS;
            string4 = string3.isEmpty() ? this.fetch(stringBuilder.toString(), "getInterWikiBacklinks") : this.fetch(stringBuilder.toString() + "&iwblcontinue=" + string3, "getInterWikiBacklinks");
            if (string4.contains("iwblcontinue")) {
                n2 = string4.indexOf("iwblcontinue=\"") + 14;
                n = string4.indexOf(34, n2);
                string3 = string4.substring(n2, n);
            } else {
                string3 = null;
            }
            n2 = string4.indexOf("<iw ");
            while (n2 >= 0) {
                n = string4.indexOf("title=\"", n2) + 7;
                int n3 = string4.indexOf(34, n);
                int n4 = string4.indexOf("iwprefix=\"", n2) + 10;
                int n5 = string4.indexOf(34, n4);
                int n6 = string4.indexOf("iwtitle=\"", n2) + 9;
                int n7 = string4.indexOf(34, n6);
                arrayList.add(new String[]{string4.substring(n, n3), string4.substring(n4, n5) + ':' + string4.substring(n6, n7)});
                n2 = n7;
                n2 = string4.indexOf("<iw ", n2);
            }
        } while (string3 != null);
        this.log(Level.INFO, "Successfully retrieved interwiki backlinks (" + arrayList.size() + " interwikis)", "getInterWikiBacklinks");
        return (String[][])arrayList.toArray((T[])new String[0][0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetch(String string, String string2) throws IOException {
        String string3;
        this.logurl(string, string2);
        URLConnection uRLConnection = new URL(string).openConnection();
        uRLConnection.setConnectTimeout(30000);
        uRLConnection.setReadTimeout(180000);
        this.setCookies(uRLConnection);
        uRLConnection.connect();
        this.grabCookies(uRLConnection);
        int n = uRLConnection.getHeaderFieldInt("X-Database-Lag", -5);
        if (n > this.maxlag) {
            try {
                Wiki wiki = this;
                synchronized (wiki) {
                    int n2 = uRLConnection.getHeaderFieldInt("Retry-After", 10);
                    this.log(Level.WARNING, "Current database lag " + n + " s exceeds " + this.maxlag + " s, waiting " + n2 + " s.", string2);
                    Thread.sleep(n2 * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.fetch(string, string2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.zipped ? new GZIPInputStream(uRLConnection.getInputStream()) : uRLConnection.getInputStream(), "UTF-8"));
        StringBuilder stringBuilder = new StringBuilder(100000);
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string3);
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        String string4 = stringBuilder.toString();
        if (string4.contains("<error code=")) {
            throw new UnknownError("MW API error. Server response was: " + string4);
        }
        return string4;
    }

    protected String post(String string, String string2, String string3) throws IOException {
        String string4;
        this.logurl(string, string3);
        URLConnection uRLConnection = new URL(string).openConnection();
        this.setCookies(uRLConnection);
        uRLConnection.setDoOutput(true);
        uRLConnection.connect();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream(), "UTF-8");
        outputStreamWriter.write(string2);
        outputStreamWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.zipped ? new GZIPInputStream(uRLConnection.getInputStream()) : uRLConnection.getInputStream(), "UTF-8"));
        this.grabCookies(uRLConnection);
        StringBuilder stringBuilder = new StringBuilder(100000);
        while ((string4 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string4);
            stringBuilder.append("\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    protected String multipartPost(String string, Map<String, ?> map, String string2) throws IOException {
        Object object;
        String string3;
        this.logurl(string, string2);
        URLConnection uRLConnection = new URL(string).openConnection();
        String string4 = "----------NEXT PART----------";
        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string4);
        this.setCookies(uRLConnection);
        uRLConnection.setDoOutput(true);
        uRLConnection.connect();
        string4 = "--" + string4 + "\r\n";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeBytes(string4);
        for (Map.Entry<String, ?> object22 : map.entrySet()) {
            string3 = object22.getKey();
            object = object22.getValue();
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + string3 + "\"\r\n");
            if (object instanceof String) {
                dataOutputStream.writeBytes("Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                dataOutputStream.write(((String)object).getBytes("UTF-8"));
            } else if (object instanceof byte[]) {
                dataOutputStream.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
                dataOutputStream.write((byte[])object);
            } else {
                throw new UnsupportedOperationException("Unrecognized data type");
            }
            dataOutputStream.writeBytes("\r\n");
            dataOutputStream.writeBytes(string4);
        }
        dataOutputStream.writeBytes("--\r\n");
        dataOutputStream.close();
        OutputStream outputStream = uRLConnection.getOutputStream();
        outputStream.write(byteArrayOutputStream.toByteArray());
        outputStream.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.zipped ? new GZIPInputStream(uRLConnection.getInputStream()) : uRLConnection.getInputStream(), "UTF-8"));
        this.grabCookies(uRLConnection);
        object = new StringBuilder(100000);
        while ((string3 = bufferedReader.readLine()) != null) {
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append("\n");
        }
        bufferedReader.close();
        return ((StringBuilder)object).toString();
    }

    protected void checkErrors(String string, String string2) throws IOException, LoginException {
        if (string.isEmpty()) {
            throw new UnknownError("Received empty response from server!");
        }
        if (string.contains("result=\"Success\"")) {
            return;
        }
        if (string.contains("error code=\"ratelimited\"")) {
            this.log(Level.WARNING, "Server-side throttle hit.", string2);
            throw new HttpRetryException("Action throttled.", 503);
        }
        if (string.contains("error code=\"blocked") || string.contains("error code=\"autoblocked\"")) {
            this.log(Level.SEVERE, "Cannot " + string2 + " - user is blocked!.", string2);
            throw new AccountLockedException("Current user is blocked!");
        }
        if (string.contains("error code=\"cascadeprotected\"")) {
            this.log(Level.WARNING, "Cannot " + string2 + " - page is subject to cascading protection.", string2);
            throw new CredentialException("Page is cascade protected");
        }
        if (string.contains("error code=\"readonly\"")) {
            this.log(Level.WARNING, "Database locked!", string2);
            throw new HttpRetryException("Database locked!", 503);
        }
        if (string.contains("error code=\"unknownerror\"")) {
            throw new UnknownError("Unknown MediaWiki API error, response was " + string);
        }
        throw new IOException("MediaWiki error, response was " + string);
    }

    protected String decode(String string) {
        string = string.replace("&lt;", "<").replace("&gt;", ">");
        string = string.replace("&amp;", "&");
        string = string.replace("&quot;", "\"");
        string = string.replace("&#039;", "'");
        return string;
    }

    protected void constructNamespaceString(StringBuilder stringBuilder, String string, int ... nArray) {
        if (nArray.length == 0) {
            return;
        }
        stringBuilder.append("&");
        stringBuilder.append(string);
        stringBuilder.append("namespace=");
        for (int n : nArray) {
            stringBuilder.append(n);
            stringBuilder.append("%7C");
        }
        stringBuilder.delete(stringBuilder.length() - 3, stringBuilder.length());
    }

    public String normalize(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    throw new IllegalArgumentException(string + " is an illegal title");
                }
                case ' ': {
                    cArray[i] = 95;
                }
            }
        }
        return new String(cArray);
    }

    protected boolean checkRights(int n, boolean bl) throws IOException, CredentialException {
        String string = URLEncoder.encode(this.user.getUsername().replace('_', ' '), "UTF-8");
        if (!this.cookies.containsValue(string)) {
            logger.log(Level.SEVERE, "Cookies have expired");
            this.logout();
            throw new CredentialExpiredException("Cookies have expired.");
        }
        if (this.user.isA("sysop")) {
            return true;
        }
        switch (n) {
            case -1: {
                return true;
            }
            case 1: {
                return this.user != null;
            }
            case 3: 
            case 4: {
                return !bl;
            }
        }
        return false;
    }

    protected void statusCheck() throws IOException, CredentialException {
        if (this.statuscounter > this.statusinterval) {
            if (this.user != null) {
                this.user.getUserInfo();
            }
            if ((this.assertion & 4) == 4) assert (!this.hasNewMessages()) : "User has new messages";
            this.statuscounter = 0;
        } else {
            ++this.statuscounter;
        }
        if ((this.assertion & 1) == 1) assert (this.user != null) : "Not logged in";
        if ((this.assertion & 2) == 2) assert (this.user.isA("bot")) : "Not a bot";
    }

    protected void setCookies(URLConnection uRLConnection) {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("; ");
        }
        uRLConnection.setRequestProperty("Cookie", stringBuilder.toString());
        if (this.zipped) {
            uRLConnection.setRequestProperty("Accept-encoding", "gzip");
        }
        uRLConnection.setRequestProperty("User-Agent", this.useragent);
    }

    private void grabCookies(URLConnection uRLConnection) {
        String string = null;
        int n = 1;
        while ((string = uRLConnection.getHeaderFieldKey(n)) != null) {
            if (string.equals("Set-Cookie")) {
                String string2 = uRLConnection.getHeaderField(n);
                string2 = string2.substring(0, string2.indexOf(59));
                String string3 = string2.substring(0, string2.indexOf(61));
                String string4 = string2.substring(string2.indexOf(61) + 1, string2.length());
                this.cookies.put(string3, string4);
            }
            ++n;
        }
    }

    protected void log(Level level, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append('[');
        stringBuilder.append(this.domain);
        stringBuilder.append("] ");
        stringBuilder.append(string);
        stringBuilder.append('.');
        logger.logp(level, "Wiki", string2 + "()", stringBuilder.toString());
    }

    @Deprecated
    public void setLogLevel(Level level) {
        logger.setLevel(level);
    }

    protected void logurl(String string, String string2) {
        logger.logp(Level.FINE, "Wiki", string2 + "()", "Fetching URL " + string);
    }

    public Calendar makeCalendar() {
        return new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    }

    protected String calendarToTimestamp(Calendar calendar) {
        return String.format("%04d%02d%02d%02d%02d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    protected final Calendar timestampToCalendar(String string) {
        Calendar calendar = this.makeCalendar();
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(8, 10));
        int n5 = Integer.parseInt(string.substring(10, 12));
        int n6 = Integer.parseInt(string.substring(12, 14));
        calendar.set(n, n2, n3, n4, n5, n6);
        return calendar;
    }

    protected String convertTimestamp(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, 4));
        stringBuilder.append(string.substring(5, 7));
        stringBuilder.append(string.substring(8, 10));
        stringBuilder.append(string.substring(11, 13));
        stringBuilder.append(string.substring(14, 16));
        stringBuilder.append(string.substring(17, 19));
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.user.getUsername());
        objectOutputStream.writeObject(this.cookies);
        objectOutputStream.writeInt(this.throttle);
        objectOutputStream.writeInt(this.maxlag);
        objectOutputStream.writeInt(this.assertion);
        objectOutputStream.writeObject(this.scriptPath);
        objectOutputStream.writeObject(this.domain);
        objectOutputStream.writeObject(this.namespaces);
        objectOutputStream.writeInt(this.statusinterval);
        objectOutputStream.writeObject(this.useragent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = (String)objectInputStream.readObject();
        this.user = new User(string);
        this.cookies = (HashMap)objectInputStream.readObject();
        this.throttle = objectInputStream.readInt();
        this.maxlag = objectInputStream.readInt();
        this.assertion = objectInputStream.readInt();
        this.scriptPath = (String)objectInputStream.readObject();
        this.domain = (String)objectInputStream.readObject();
        this.namespaces = (HashMap)objectInputStream.readObject();
        this.statusinterval = objectInputStream.readInt();
        this.useragent = (String)objectInputStream.readObject();
        this.initVars();
        this.statuscounter = this.statusinterval;
    }

    static {
        logger.logp(Level.CONFIG, "Wiki", "<init>", "Using Wiki.java 0.27");
    }

    public class Revision
    implements Comparable<Revision> {
        private boolean minor;
        private boolean bot;
        private boolean rvnew;
        private String summary;
        private long revid;
        private long rcid = -1L;
        private Calendar timestamp;
        private String user;
        private String title;
        private String rollbacktoken = null;
        private int size = 0;

        public Revision(long l, Calendar calendar, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n) {
            this.revid = l;
            this.timestamp = calendar;
            this.summary = string2;
            this.minor = bl;
            this.user = string3;
            this.title = string;
            this.bot = bl2;
            this.rvnew = bl3;
            this.size = n;
        }

        public String getText() throws IOException {
            if (this.revid == 0L) {
                throw new IllegalArgumentException("Log entries have no valid content!");
            }
            String string = Wiki.this.base + URLEncoder.encode(this.title, "UTF-8") + "&oldid=" + this.revid + "&action=raw";
            String string2 = Wiki.this.fetch(string, "Revision.getText");
            Wiki.this.log(Level.INFO, "Successfully retrieved text of revision " + this.revid, "Revision.getText");
            return Wiki.this.decode(string2);
        }

        public String getRenderedText() throws IOException {
            if (this.revid == 0L) {
                throw new IllegalArgumentException("Log entries have no valid content!");
            }
            String string = Wiki.this.base + URLEncoder.encode(this.title, "UTF-8") + "&oldid=" + this.revid + "&action=render";
            String string2 = Wiki.this.fetch(string, "Revision.getRenderedText");
            Wiki.this.log(Level.INFO, "Successfully retrieved rendered text of revision " + this.revid, "Revision.getRenderedText");
            return Wiki.this.decode(string2);
        }

        public String diff(Revision revision) throws IOException {
            return this.diff(revision.revid, Wiki.ALL_LOGS);
        }

        public String diff(String string) throws IOException {
            return this.diff(0L, string);
        }

        public String diff(long l) throws IOException {
            return this.diff(l, Wiki.ALL_LOGS);
        }

        protected String diff(long l, String string) throws IOException {
            StringBuilder stringBuilder = new StringBuilder("prop=revisions&revids=");
            stringBuilder.append(this.revid);
            if (l == -1L) {
                stringBuilder.append("&rvdiffto=next");
            } else if (l == -2L) {
                stringBuilder.append("&rvdiffto=cur");
            } else if (l == -3L) {
                stringBuilder.append("&rvdiffto=prev");
            } else if (l == 0L) {
                stringBuilder.append("&rvdifftotext=");
                stringBuilder.append(string);
            } else {
                stringBuilder.append("&rvdiffto=");
                stringBuilder.append(l);
            }
            String string2 = Wiki.this.post(Wiki.this.query, stringBuilder.toString(), "Revision.diff");
            int n = string2.indexOf("<diff");
            n = string2.indexOf(">", n) + 1;
            int n2 = string2.indexOf("</diff>", n);
            return Wiki.this.decode(string2.substring(n, n2));
        }

        public boolean equals(Object object) {
            if (!(object instanceof Revision)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public int hashCode() {
            return (int)this.revid * 2 - Wiki.this.hashCode();
        }

        public boolean isMinor() {
            return this.minor;
        }

        public boolean isBot() {
            return this.bot;
        }

        public boolean isNew() {
            return this.rvnew;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getUser() {
            return this.user;
        }

        public String getPage() {
            return this.title;
        }

        public long getRevid() {
            return this.revid;
        }

        public Calendar getTimestamp() {
            return this.timestamp;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Revision[oldid=");
            stringBuilder.append(this.revid);
            stringBuilder.append(",page=\"");
            stringBuilder.append(this.title);
            stringBuilder.append("\",user=");
            stringBuilder.append(this.user == null ? "[hidden]" : this.user);
            stringBuilder.append(",timestamp=");
            stringBuilder.append(Wiki.this.calendarToTimestamp(this.timestamp));
            stringBuilder.append(",summary=\"");
            stringBuilder.append(this.summary == null ? "[hidden]" : this.summary);
            stringBuilder.append("\",minor=");
            stringBuilder.append(this.minor);
            stringBuilder.append(",bot=");
            stringBuilder.append(this.bot);
            stringBuilder.append(",size=");
            stringBuilder.append(this.size);
            stringBuilder.append(",rcid=");
            stringBuilder.append(this.rcid == -1L ? "unset" : Long.valueOf(this.rcid));
            stringBuilder.append(",rollbacktoken=");
            stringBuilder.append(this.rollbacktoken == null ? "null" : this.rollbacktoken);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(Revision revision) {
            if (this.timestamp.equals(revision.timestamp)) {
                return 0;
            }
            return this.timestamp.after(revision.timestamp) ? 1 : -1;
        }

        public void setRcid(long l) {
            this.rcid = l;
        }

        public long getRcid() {
            return this.rcid;
        }

        public void setRollbackToken(String string) {
            this.rollbacktoken = string;
        }

        public String getRollbackToken() {
            return this.rollbacktoken;
        }

        public void rollback() throws IOException, LoginException {
            Wiki.this.rollback(this, false, Wiki.ALL_LOGS);
        }

        public void rollback(boolean bl, String string) throws IOException, LoginException {
            Wiki.this.rollback(this, bl, string);
        }
    }

    public class LogEntry
    implements Comparable<LogEntry> {
        private String type;
        private String action;
        private String reason;
        private User user;
        private String target;
        private Calendar timestamp;
        private Object details;

        protected LogEntry(String string, String string2, String string3, User user, String string4, String string5, Object object) {
            this.type = string;
            this.action = string2;
            this.reason = string3;
            this.user = user;
            this.target = string4;
            this.timestamp = Wiki.this.timestampToCalendar(string5);
            this.details = object;
        }

        public String getType() {
            return this.type;
        }

        public String getAction() {
            return this.action;
        }

        public String getReason() {
            return this.reason;
        }

        public User getUser() {
            return this.user;
        }

        public String getTarget() {
            return this.target;
        }

        public Calendar getTimestamp() {
            return this.timestamp;
        }

        public Object getDetails() {
            return this.details;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("LogEntry[type=");
            stringBuilder.append(this.type);
            stringBuilder.append(",action=");
            stringBuilder.append(this.action == null ? "[hidden]" : this.action);
            stringBuilder.append(",user=");
            stringBuilder.append(this.user == null ? "[hidden]" : this.user.getUsername());
            stringBuilder.append(",timestamp=");
            stringBuilder.append(Wiki.this.calendarToTimestamp(this.timestamp));
            stringBuilder.append(",target=");
            stringBuilder.append(this.target == null ? "[hidden]" : this.target);
            stringBuilder.append(",reason=");
            stringBuilder.append(this.reason == null ? "[hidden]" : this.reason);
            stringBuilder.append(",details=");
            if (this.details instanceof Object[]) {
                stringBuilder.append(Arrays.asList((Object[])this.details));
            } else {
                stringBuilder.append(this.details);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(LogEntry logEntry) {
            if (this.timestamp.equals(logEntry.timestamp)) {
                return 0;
            }
            return this.timestamp.after(logEntry.timestamp) ? 1 : -1;
        }
    }

    public class User
    implements Cloneable {
        private String username;
        private String[] rights = null;
        private String[] groups = null;

        protected User(String string) {
            this.username = string;
        }

        public String getUsername() {
            return this.username;
        }

        public HashMap<String, Object> getUserInfo() throws IOException {
            int n;
            String string = Wiki.this.fetch(Wiki.this.query + "list=users&usprop=editcount%7Cgroups%7Crights%7Cemailable%7Cblockinfo%7Cgender%7Cregistration&ususers=" + URLEncoder.encode(this.username, "UTF-8"), "getUserInfo");
            HashMap<String, Object> hashMap = new HashMap<String, Object>(10);
            hashMap.put("blocked", string.contains("blockedby=\""));
            hashMap.put("emailable", string.contains("emailable=\""));
            int n2 = string.indexOf("editcount=\"") + 11;
            int n3 = string.indexOf(34, n2);
            hashMap.put("editcount", Integer.parseInt(string.substring(n2, n3)));
            n2 = string.indexOf("gender=\"") + 8;
            n3 = string.indexOf(34, n2);
            hashMap.put("gender", (Object)Gender.valueOf(string.substring(n2, n3)));
            n2 = string.indexOf("registration=\"") + 14;
            n3 = string.indexOf(34, n2);
            hashMap.put("created", Wiki.this.timestampToCalendar(Wiki.this.convertTimestamp(string.substring(n2, n3))));
            ArrayList<String> arrayList = new ArrayList<String>(50);
            int n4 = string.indexOf("<g>");
            while (n4 >= 0) {
                n = string.indexOf("</g>", n4);
                arrayList.add(string.substring(n4 + 3, n));
                n4 = n;
                n4 = string.indexOf("<g>", n4);
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            if (this.equals(Wiki.this.getCurrentUser())) {
                this.groups = stringArray;
            }
            hashMap.put("groups", stringArray);
            arrayList.clear();
            n = string.indexOf("<r>");
            while (n >= 0) {
                int n5 = string.indexOf("</r>", n);
                arrayList.add(string.substring(n + 3, n5));
                n = n5;
                n = string.indexOf("<r>", n);
            }
            stringArray = arrayList.toArray(new String[0]);
            if (this.equals(Wiki.this.getCurrentUser())) {
                this.rights = stringArray;
            }
            hashMap.put(Wiki.USER_RIGHTS_LOG, stringArray);
            return hashMap;
        }

        public boolean isAllowedTo(String string) throws IOException {
            if (this.rights == null) {
                this.rights = (String[])this.getUserInfo().get(Wiki.USER_RIGHTS_LOG);
            }
            for (String string2 : this.rights) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public boolean isA(String string) throws IOException {
            if (this.groups == null) {
                this.groups = (String[])this.getUserInfo().get("groups");
            }
            for (String string2 : this.groups) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public LogEntry[] blockLog() throws IOException {
            return Wiki.this.getLogEntries(null, null, Integer.MAX_VALUE, Wiki.BLOCK_LOG, null, "User:" + this.username, 2);
        }

        public boolean isBlocked() throws IOException {
            return Wiki.this.getIPBlockList(this.username, null, null, 1).length != 0;
        }

        public int countEdits() throws IOException {
            return (Integer)this.getUserInfo().get("editcount");
        }

        public Revision[] contribs(int ... nArray) throws IOException {
            return Wiki.this.contribs(this.username, nArray);
        }

        public User clone() {
            try {
                return (User)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean equals(Object object) {
            return object instanceof User && this.username.equals(((User)object).username);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("User[username=");
            stringBuilder.append(this.username);
            stringBuilder.append("groups=");
            stringBuilder.append(this.groups != null ? Arrays.toString(this.groups) : "unset");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public int hashCode() {
            return this.username.hashCode() * 2 + 1;
        }
    }

    public static enum Gender {
        male,
        female,
        unknown;

    }
}

