/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.InternetDownloadTask;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;

public class WikiImageManager {
    private HashSet<String> mDownlaodTask = new HashSet();
    private static volatile WikiImageManager single;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WikiImageManager getInstance() {
        if (single != null) return single;
        Class<WikiImageManager> clazz = WikiImageManager.class;
        synchronized (WikiImageManager.class) {
            if (single != null) return single;
            single = new WikiImageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void addDownloadTask(String string) {
        if (this.mDownlaodTask.contains(string)) {
            return;
        }
        File file = WikiImageManager.getImageFile(string);
        try {
            InternetDownloadTask internetDownloadTask = new InternetDownloadTask(WikiImageManager.getImageWikiUrl(string));
            if (!file.exists() || file.length() != (long)internetDownloadTask.getFileSize()) {
                this.mDownlaodTask.add(string);
                file.getParentFile().mkdirs();
                internetDownloadTask.setDestFileStream(new FileOutputStream(file));
                internetDownloadTask.setDownloadProgressListener(new WikiDownloadListener(string));
                internetDownloadTask.execute();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String getImageWikiUrl(String string) {
        return "http://wiki.dev.xiaomi.com" + string;
    }

    private static File getImageFile(String string) {
        try {
            string = "/" + string.substring(string.indexOf("images"));
            string = new String(URLDecoder.decode(string, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        String string2 = ThemeHelper.getTmpFolder() + File.separator + "theme_values" + ThemeHelper.assurePath(string);
        return new File(string2);
    }

    public String getImageUrl(String string) {
        File file = WikiImageManager.getImageFile(string);
        if (this.mDownlaodTask.contains(string) || !file.exists()) {
            return null;
        }
        if (OS.getOS() == 2 || OS.getOS() == 3) {
            return "file://" + file.getAbsolutePath();
        }
        if (OS.getOS() == 1) {
            return "file:///" + file.getAbsolutePath();
        }
        return "";
    }

    class WikiDownloadListener
    implements DownloadProgressListener {
        private String mPath;

        public WikiDownloadListener(String string) {
            this.mPath = string;
        }

        @Override
        public void progress(long l, long l2) {
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void done(Object object) {
            WikiImageManager.this.mDownlaodTask.remove(this.mPath);
        }
    }
}

