/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.wallpaper;

import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.wallpaper.ReplaceListener;
import com.miui.theme.tool.wallpaper.ReplacePanel;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;

public class CenterWallpaper
extends CommonRightPanel {
    BufferedImage mWallpaper;
    protected String mDefaultWallpaper = "wallpaper/wallpaper_000.jpg";
    protected String mDefaultWallpaperOverlay = "wallpaper/wallpaper_overlay.png";
    BufferedImage mPhone;
    int mPhoneTop = 73;
    int mPhoneMiddle = 537;
    int mPhoneBottom;
    protected ReplacePanel mReplacePanel;
    private ReplaceListener mReplaceListener = new ReplaceListener(){

        @Override
        public void onReplace(String string) {
            File file = new File(string);
            BufferedImage bufferedImage = GUIUtil.getImage(file);
            CenterWallpaper.this.setWallPaper(bufferedImage);
            if (file.getAbsolutePath() != CenterWallpaper.this.mWallpaperFile.getAbsolutePath()) {
                GUIUtil.saveImage(bufferedImage, CenterWallpaper.this.mWallpaperFile);
            }
        }
    };
    protected File mWallpaperFile;

    protected CenterWallpaper() {
    }

    public void init() {
        double[][] dArrayArray = new double[][]{{605.0, 43.0, 268.0}, {73.0, 537.0, 89.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.mReplacePanel = new ReplacePanel();
        this.mReplacePanel.setReplaceListener(this.mReplaceListener);
        this.add((Component)this.mReplacePanel, "2, 1");
        this.mPhone = ResourceFactory.getInstance().getImage(this.getDefaultWallpaperOverlay());
        this.mPhoneBottom = this.mPhone.getHeight() - this.mPhoneTop - this.mPhoneMiddle;
        this.mWallpaperFile = new File(this.getWallpaper());
        if (this.mWallpaperFile.exists()) {
            this.setWallPaper(GUIUtil.getImage(this.mWallpaperFile));
        } else {
            this.setWallPaper(ResourceFactory.getInstance().getImage(this.getDefaultWallpaper()));
        }
    }

    protected String getDefaultWallpaperOverlay() {
        return this.mDefaultWallpaperOverlay;
    }

    protected String getDefaultWallpaper() {
        return this.mDefaultWallpaper;
    }

    protected String getWallpaper() {
        return ThemeHelper.getWallpaper();
    }

    public static CenterWallpaper create() {
        CenterWallpaper centerWallpaper = new CenterWallpaper();
        centerWallpaper.init();
        return centerWallpaper;
    }

    public void setWallPaper(BufferedImage bufferedImage) {
        this.mWallpaper = bufferedImage;
        int n = (int)(1.0 * (double)this.mWallpaper.getWidth() * (double)this.mPhoneMiddle / (double)this.mWallpaper.getHeight());
        this.mWallpaper = GUIUtil.scale(this.mWallpaper, n, this.mPhoneMiddle);
        this.updateUI();
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getWidth() == 0 || this.mWallpaper == null || this.mPhone == null) {
            return;
        }
        this.drawWallpaper(graphics);
    }

    protected void drawWallpaper(Graphics graphics) {
        int n = (this.mWallpaper.getWidth() - this.mPhone.getWidth()) / 2;
        graphics.drawImage(this.mWallpaper, 0, this.mPhoneTop, null);
        graphics.drawImage(this.mPhone, n - 3, 0, null);
    }
}

