/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.wallpaper;

import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.wallpaper.ReplaceListener;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ReplacePanel
extends TransparentPanel {
    public JPanel mDragPanel;
    private static ImageIcon sReplaceButtonNormalIcon = ResourceFactory.getInstance().getImageIcon("wallpaper/change_btn_n.png");
    private static ImageIcon sReplaceButtonHoverlIcon = ResourceFactory.getInstance().getImageIcon("wallpaper/change_btn_h.png");
    private static ImageIcon sReplaceButtonPressedIcon = ResourceFactory.getInstance().getImageIcon("wallpaper/change_btn_p.png");
    private JButton mReplaceButton = GUIUtil.createTransparentButton(sReplaceButtonNormalIcon, sReplaceButtonHoverlIcon, sReplaceButtonPressedIcon, null);
    private JLabel mDragLabel;
    protected JLabel mDescriptionLabel;
    private ReplaceListener mReplaceListener;
    private FileDrop.Listener mFileDropListener = new FileDrop.Listener(){

        @Override
        public void filesDropped(File[] fileArray) {
            if (ReplacePanel.this.mReplaceListener != null && fileArray.length > 0) {
                ReplacePanel.this.mReplaceListener.onReplace(fileArray[0].getAbsolutePath());
            }
        }
    };
    private ActionListener mActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setVisible(true);
            jFileChooser.setCurrentDirectory(new File(ConfigUtil.getThemePath()).getParentFile());
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && (file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".jpg"));
                }

                @Override
                public String getDescription() {
                    return "wallpaper file";
                }
            });
            int n = jFileChooser.showOpenDialog(NewMainFrame.getInstance());
            if (n == 0) {
                ReplacePanel.this.mReplaceListener.onReplace(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    };

    public void setReplaceListener(ReplaceListener replaceListener) {
        this.mReplaceListener = replaceListener;
    }

    public ReplacePanel() {
        double[][] dArrayArray = new double[][]{{-1.0, -2.0, -1.0}, {238.0, 30.0, 42.0, 20.0, -2.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.mDragPanel = new JPanel();
        this.mDragPanel.setBackground(GUIUtil.hex2color("#e7e9ec"));
        this.mDragPanel.setBorder(BorderFactory.createLineBorder(GUIUtil.hex2color("#d9dadc"), 1, true));
        this.mDragPanel.setLayout(new BorderLayout());
        this.mDragLabel = new JLabel(ResourceFactory.getString("WallpaperDragLabel"));
        this.mDragLabel.setForeground(GUIUtil.hex2color("#b2b3b4"));
        this.mDragLabel.setHorizontalAlignment(0);
        this.mDragPanel.add((Component)this.mDragLabel, "Center");
        this.add((Component)this.mDragPanel, "0, 0, 2, 0");
        this.mReplaceButton.setText(ResourceFactory.getString("WallpaperReplace"));
        this.mReplaceButton.setHorizontalTextPosition(0);
        this.mReplaceButton.setForeground(Color.WHITE);
        this.mReplaceButton.addActionListener(this.mActionListener);
        this.add((Component)this.mReplaceButton, "1, 2");
        this.mDescriptionLabel = new JLabel(ResourceFactory.getString("WallpaperDescription"));
        this.mDescriptionLabel.setForeground(GUIUtil.hex2color("#aeafb0"));
        this.add((Component)this.mDescriptionLabel, "1, 4");
        new FileDrop(this.mDragPanel, this.mFileDropListener);
    }
}

