/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.graphics.Bitmap;
import java.awt.image.BufferedImage;

public class ImageData {
    int[] pixels;
    int width;
    int height;
    private int[] backPixels;
    private int mHashCode = 0;

    public ImageData(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.pixels = new int[n * n2];
    }

    public int generalRandomNum(int n) {
        if (this.mHashCode == 0) {
            for (int i = 1; i < 7; ++i) {
                this.mHashCode ^= this.pixels[this.pixels.length / 7 * i];
            }
            if (this.mHashCode == 0) {
                this.mHashCode = n;
            }
            if (this.mHashCode < 0) {
                this.mHashCode = -this.mHashCode;
            }
        }
        return this.mHashCode % n;
    }

    public int[] getBackPixels() {
        if (this.backPixels == null || this.backPixels.length != this.pixels.length) {
            this.backPixels = new int[this.pixels.length];
        }
        return this.backPixels;
    }

    public void swapPixels() {
        int[] nArray = this.pixels;
        this.pixels = this.backPixels;
        this.backPixels = nArray;
    }

    public static ImageData bitmapToImageData(BufferedImage bufferedImage) {
        ImageData imageData = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight());
        for (int i = 0; i < imageData.width; ++i) {
            for (int j = 0; j < imageData.height; ++j) {
                imageData.pixels[i * imageData.width + j] = bufferedImage.getRGB(i, j);
            }
        }
        return imageData;
    }

    public static Bitmap imageDataToBitmap(ImageData imageData) {
        Bitmap bitmap = new Bitmap(imageData.width, imageData.height, 6);
        for (int i = 0; i < imageData.width; ++i) {
            for (int j = 0; j < imageData.height; ++j) {
                bitmap.setRGB(i, j, imageData.pixels[i * imageData.width + j]);
            }
        }
        return bitmap;
    }
}

