/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import android.graphics.Bitmap;
import android.util.Log;
import java.lang.reflect.Method;
import miui.content.res.IconCustomizer;
import miui.imagefilters.FilterParamType;
import miui.imagefilters.IImageFilter;

public class ImageFilterUtils {
    static final float COLOR_TO_GRAYSCALE_FACTOR_R = 0.299f;
    static final float COLOR_TO_GRAYSCALE_FACTOR_G = 0.587f;
    static final float COLOR_TO_GRAYSCALE_FACTOR_B = 0.114f;
    static final String TAG = "ImageFilterUtils";

    public static int HslToRgb(float[] fArray) {
        return ImageFilterUtils.HslToRgb(fArray[0], fArray[1], fArray[2]);
    }

    public static int HslToRgb(float f, float f2, float f3) {
        int n;
        int n2;
        int n3;
        if (f2 == 0.0f) {
            n2 = n3 = (int)(f3 * 255.0f);
            n = n3;
        } else {
            float f4 = f3 < 0.5f ? f3 * (1.0f + f2) : f3 + f2 - f3 * f2;
            float f5 = 2.0f * f3 - f4;
            float f6 = f / 360.0f;
            float[] fArray = new float[]{f6 + 0.33333334f, f6, f6 - 0.33333334f};
            for (int i = 0; i < 3; ++i) {
                if (fArray[i] < 0.0f) {
                    int n4 = i;
                    fArray[n4] = (float)((double)fArray[n4] + 1.0);
                } else if (fArray[i] > 1.0f) {
                    int n5 = i;
                    fArray[n5] = (float)((double)fArray[n5] - 1.0);
                }
                fArray[i] = fArray[i] * 6.0f < 1.0f ? f5 + (f4 - f5) * 6.0f * fArray[i] : ((double)fArray[i] * 2.0 < 1.0 ? f4 : ((double)fArray[i] * 3.0 < 2.0 ? f5 + (f4 - f5) * (0.6666667f - fArray[i]) * 6.0f : f5));
            }
            n = (int)((double)fArray[0] * 255.0);
            n2 = (int)((double)fArray[1] * 255.0);
            n3 = (int)((double)fArray[2] * 255.0);
        }
        n = ImageFilterUtils.clamp(0, n, 255);
        n2 = ImageFilterUtils.clamp(0, n2, 255);
        n3 = ImageFilterUtils.clamp(0, n3, 255);
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static int HsvToRgb(float f, float f2, float f3) {
        int n;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f2 == 0.0f) {
            f5 = f6 = f3;
            f4 = f6;
        } else {
            float f7 = f / 60.0f;
            n = (int)Math.floor(f7);
            float f8 = f7 - (float)n;
            float f9 = f3 * (1.0f - f2);
            float f10 = f3 * (1.0f - f2 * f8);
            float f11 = f3 * (1.0f - f2 * (1.0f - f8));
            switch (n) {
                case 0: {
                    f4 = f3;
                    f5 = f11;
                    f6 = f9;
                    break;
                }
                case 1: {
                    f4 = f10;
                    f5 = f3;
                    f6 = f9;
                    break;
                }
                case 2: {
                    f4 = f9;
                    f5 = f3;
                    f6 = f11;
                    break;
                }
                case 3: {
                    f4 = f9;
                    f5 = f10;
                    f6 = f3;
                    break;
                }
                case 4: {
                    f4 = f11;
                    f5 = f9;
                    f6 = f3;
                    break;
                }
                case 5: {
                    f4 = f3;
                    f5 = f9;
                    f6 = f10;
                }
            }
        }
        f4 = ImageFilterUtils.clamp(0.0f, f4, 1.0f);
        f5 = ImageFilterUtils.clamp(0.0f, f5, 1.0f);
        f6 = ImageFilterUtils.clamp(0.0f, f6, 1.0f);
        int n2 = (int)(f4 * 255.0f);
        n = (int)(f5 * 255.0f);
        int n3 = (int)(f6 * 255.0f);
        return 0xFF000000 | n2 << 16 | n << 8 | n3;
    }

    public static void RgbToHsl(int n, float[] fArray) {
        ImageFilterUtils.RgbToHsl(0xFF & n >>> 16, 0xFF & n >>> 8, 0xFF & n, fArray);
    }

    public static void RgbToHsl(int n, int n2, int n3, float[] fArray) {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = (float)n / 255.0f;
        float f6 = (float)n2 / 255.0f;
        float f7 = (float)n3 / 255.0f;
        float f8 = Math.max(f5, Math.max(f6, f7));
        if (f8 == (f = Math.min(f5, Math.min(f6, f7)))) {
            f2 = 0.0f;
        } else if (f8 == f5 && f6 >= f7) {
            f2 = 60.0f * (f6 - f7) / (f8 - f);
        } else if (f8 == f5 && f6 < f7) {
            f2 = 60.0f * (f6 - f7) / (f8 - f) + 360.0f;
        } else if (f8 == f6) {
            f2 = 60.0f * (f7 - f5) / (f8 - f) + 120.0f;
        } else if (f8 == f7) {
            f2 = 60.0f * (f5 - f6) / (f8 - f) + 240.0f;
        }
        f4 = (f8 + f) / 2.0f;
        if (f4 == 0.0f || f8 == f) {
            f3 = 0.0f;
        } else if (0.0f < f4 && (double)f4 <= 0.5) {
            f3 = (f8 - f) / (f8 + f);
        } else if ((double)f4 > 0.5) {
            f3 = (f8 - f) / (2.0f - (f8 + f));
        }
        fArray[0] = ImageFilterUtils.clamp(0.0f, f2, 360.0f);
        fArray[1] = ImageFilterUtils.clamp(0.0f, f3, 1.0f);
        fArray[2] = ImageFilterUtils.clamp(0.0f, f4, 1.0f);
    }

    public static void RgbToHsv(int n, float[] fArray) {
        ImageFilterUtils.RgbToHsv(0xFF & n >>> 16, 0xFF & n >>> 8, 0xFF & n, fArray);
    }

    public static void RgbToHsv(int n, int n2, int n3, float[] fArray) {
        float f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = (float)n / 255.0f;
        float f6 = (float)n2 / 255.0f;
        float f7 = (float)n3 / 255.0f;
        float f8 = Math.max(f5, Math.max(f6, f7));
        if (f8 == (f = Math.min(f5, Math.min(f6, f7)))) {
            f2 = 0.0f;
        } else if (f8 == f5 && f6 >= f7) {
            f2 = 60.0f * (f6 - f7) / (f8 - f);
        } else if (f8 == f5 && f6 < f7) {
            f2 = 60.0f * (f6 - f7) / (f8 - f) + 360.0f;
        } else if (f8 == f6) {
            f2 = 60.0f * (f7 - f5) / (f8 - f) + 120.0f;
        } else if (f8 == f7) {
            f2 = 60.0f * (f5 - f6) / (f8 - f) + 240.0f;
        }
        f4 = f8;
        f3 = f8 == 0.0f ? 0.0f : (f8 - f) / f8;
        fArray[0] = ImageFilterUtils.clamp(0.0f, f2, 360.0f);
        fArray[1] = ImageFilterUtils.clamp(0.0f, f3, 1.0f);
        fArray[2] = ImageFilterUtils.clamp(0.0f, f4, 1.0f);
    }

    public static void interpolate(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        int n = Math.min(fArray.length, fArray2.length);
        for (int i = 0; i < n; ++i) {
            fArray3[i] = fArray[i] + (fArray2[i] - fArray[i]) * f;
        }
    }

    public static int interpolate(int n, int n2, int n3, int n4, int n5) {
        return (int)((float)n3 + (float)n5 * (float)(n4 - n3) / (float)(n2 - n));
    }

    public static int clamp(int n, int n2, int n3) {
        if (n2 <= n) {
            return n;
        }
        if (n2 >= n3) {
            return n3;
        }
        return n2;
    }

    public static float clamp(float f, float f2, float f3) {
        if (f2 <= f) {
            return f;
        }
        if (f2 >= f3) {
            return f3;
        }
        return f2;
    }

    public static int convertColorToGrayscale(int n) {
        return (int)(0.299f * (float)((n & 0xFF0000) >>> 16) + 0.587f * (float)((n & 0xFF00) >>> 8) + 0.114f * (float)(n & 0xFF));
    }

    public static void checkChannelParam(String string, boolean[] blArray) {
        if (string.equalsIgnoreCase("r") || string.equalsIgnoreCase("red")) {
            blArray[0] = true;
        } else if (string.equalsIgnoreCase("g") || string.equalsIgnoreCase("green")) {
            blArray[1] = true;
        } else if (string.equalsIgnoreCase("b") || string.equalsIgnoreCase("blue")) {
            blArray[2] = true;
        } else if (string.equalsIgnoreCase("a") || string.equalsIgnoreCase("alpha")) {
            if (blArray.length >= 4) {
                blArray[3] = true;
            }
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean setProperty(Object object, String string, Object object2) {
        String string2 = "set" + string;
        Method method = null;
        Method[] methodArray = object.getClass().getMethods();
        for (Method method2 : methodArray) {
            if (!string2.equalsIgnoreCase(method2.getName()) || method2.getParameterTypes().length != 1) continue;
            method = method2;
            break;
        }
        if (method == null) {
            Log.w(TAG, "unknown property:" + string + ",obj:" + object);
            return false;
        }
        FilterParamType filterParamType = method.getAnnotation(FilterParamType.class);
        FilterParamType.ParamType paramType = filterParamType == null ? FilterParamType.ParamType.DEFAULT : filterParamType.value();
        Class<?> clazz = method.getParameterTypes()[0];
        try {
            void var9_26;
            block17: {
                block15: {
                    String[] stringArray;
                    Class<?> clazz2;
                    block24: {
                        String string3;
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block16: {
                                                    Object var9_12 = null;
                                                    if (!(object2 instanceof String)) break block15;
                                                    string3 = (String)object2;
                                                    if (!String.class.equals(clazz)) break block16;
                                                    String string4 = string3;
                                                    break block17;
                                                }
                                                if (!Integer.TYPE.equals(clazz)) break block18;
                                                int n = Integer.parseInt(string3);
                                                if (paramType == FilterParamType.ParamType.ICON_SIZE) {
                                                    n = IconCustomizer.hdpiIconSizeToCurrent(n);
                                                }
                                                Integer n2 = n;
                                                break block17;
                                            }
                                            if (!Float.TYPE.equals(clazz)) break block19;
                                            float f = Float.parseFloat(string3);
                                            if (paramType == FilterParamType.ParamType.ICON_SIZE) {
                                                f = IconCustomizer.hdpiIconSizeToCurrent(f);
                                            }
                                            Float f2 = Float.valueOf(f);
                                            break block17;
                                        }
                                        if (!Double.TYPE.equals(clazz)) break block20;
                                        double d = Double.parseDouble(string3);
                                        if (paramType == FilterParamType.ParamType.ICON_SIZE) {
                                            d = IconCustomizer.hdpiIconSizeToCurrent(d);
                                        }
                                        Double d2 = d;
                                        break block17;
                                    }
                                    if (!Boolean.TYPE.equals(clazz)) break block21;
                                    Boolean bl = Boolean.parseBoolean(string3);
                                    break block17;
                                }
                                if (!Bitmap.class.equals(clazz)) break block22;
                                Object object3 = IconCustomizer.getRawIcon(string3);
                                break block17;
                            }
                            if (!clazz.isEnum()) break block23;
                            Object obj = Enum.valueOf(clazz, string3);
                            break block17;
                        }
                        if (!clazz.isArray()) {
                            Log.w(TAG, "unknown param type:" + clazz.getName() + ",obj:" + object + ",property:" + string);
                            return false;
                        }
                        clazz2 = clazz.getComponentType();
                        stringArray = string3.split(",");
                        if (!Integer.TYPE.equals(clazz2)) break block24;
                        int[] nArray = new int[stringArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = Integer.parseInt(stringArray[i].trim());
                            if (paramType != FilterParamType.ParamType.ICON_SIZE) continue;
                            nArray[i] = IconCustomizer.hdpiIconSizeToCurrent(nArray[i]);
                        }
                        int[] nArray2 = nArray;
                        break block17;
                    }
                    if (Float.TYPE.equals(clazz2)) {
                        float[] fArray = new float[stringArray.length];
                        for (int i = 0; i < fArray.length; ++i) {
                            fArray[i] = Float.parseFloat(stringArray[i].trim());
                            if (paramType != FilterParamType.ParamType.ICON_SIZE) continue;
                            fArray[i] = IconCustomizer.hdpiIconSizeToCurrent(fArray[i]);
                        }
                        float[] fArray2 = fArray;
                        break block17;
                    } else if (Double.TYPE.equals(clazz2)) {
                        double[] dArray = new double[stringArray.length];
                        for (int i = 0; i < dArray.length; ++i) {
                            dArray[i] = Float.parseFloat(stringArray[i].trim());
                            if (paramType != FilterParamType.ParamType.ICON_SIZE) continue;
                            dArray[i] = IconCustomizer.hdpiIconSizeToCurrent(dArray[i]);
                        }
                        double[] dArray2 = dArray;
                    }
                    break block17;
                }
                if (object2 instanceof IImageFilter.ImageFilterGroup) {
                    Object object4 = object2;
                }
            }
            method.invoke(object, var9_26);
            return true;
        }
        catch (Exception exception) {
            Log.e(TAG, "set property fail. obj:" + object + ",property:" + string + ",value:" + object2, exception);
            return false;
        }
    }
}

