/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class ThresholdFilter
extends IImageFilter.AbstractImageFilter {
    private int mThresholdLevel = 128;
    private boolean mUniform;

    public void setThresholdLevel(int n) {
        this.mThresholdLevel = n;
    }

    public void setUniform(boolean bl) {
        this.mUniform = bl;
    }

    @Override
    public void processData(ImageData imageData) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = imageData.width;
        int n6 = imageData.height;
        int[] nArray = imageData.pixels;
        int n7 = 0;
        if (!this.mUniform) {
            n7 = this.mThresholdLevel;
        } else {
            n4 = nArray.length;
            int[] nArray2 = new int[256];
            for (n3 = 0; n3 < n6; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    int n8;
                    n = n3 * n5 + n2;
                    int n9 = nArray[n];
                    if ((n9 >>> 24 & 0xFF) < 10) {
                        --n4;
                        continue;
                    }
                    int n10 = n8 = ImageFilterUtils.convertColorToGrayscale(n9);
                    nArray2[n10] = nArray2[n10] + 1;
                }
            }
            n3 = n4 * this.mThresholdLevel / 255;
            n2 = 0;
            for (n = 0; n < 256; ++n) {
                if ((n2 += nArray2[n]) < n3) continue;
                n7 = n;
                break;
            }
        }
        for (n4 = 0; n4 < n6; ++n4) {
            for (int i = 0; i < n5; ++i) {
                n3 = n4 * n5 + i;
                n2 = nArray[n3];
                n = ImageFilterUtils.convertColorToGrayscale(n2);
                nArray[n3] = n >= n7 ? n2 & 0xFF000000 | 0xFFFFFF : n2 & 0xFF000000;
            }
        }
    }
}

