/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.IOException;
import java.io.InputStream;
import org.json.zip.BitReader;

public class BitInputStream
implements BitReader {
    private int available = 0;
    private int unread = 0;
    private InputStream in;
    private long nrBits = 0L;

    public BitInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public boolean bit() throws IOException {
        return this.read(1) != 0;
    }

    @Override
    public long nrBits() {
        return this.nrBits;
    }

    @Override
    public boolean pad(int n) throws IOException {
        boolean bl = true;
        int n2 = (int)this.nrBits % n;
        if (n2 < 0) {
            n2 += n;
        }
        if (n2 != 0) {
            for (int i = n - n2; i > 0; --i) {
                if (!this.bit()) continue;
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public int read(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        if (n < 0 || n > 32) {
            throw new IOException("Bad read width.");
        }
        int n2 = 0;
        while (n > 0) {
            int n3;
            if (this.available == 0) {
                this.unread = this.in.read();
                if (this.unread < 0) {
                    throw new IOException("Attempt to read past end.");
                }
                this.available = 8;
            }
            if ((n3 = n) > this.available) {
                n3 = this.available;
            }
            n2 |= (this.unread >>> this.available - n3 & (1 << n3) - 1) << n - n3;
            this.nrBits += (long)n3;
            this.available -= n3;
            n -= n3;
        }
        return n2;
    }
}

