/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import org.json.JSONException;
import org.json.zip.BitReader;
import org.json.zip.BitWriter;
import org.json.zip.JSONzip;
import org.json.zip.None;
import org.json.zip.PostMortem;

public class Huff
implements None,
PostMortem {
    private final int domain;
    public static final int education = 1000000;
    private final Symbol[] symbols;
    private Symbol table;
    private int toLearn;
    private boolean upToDate = false;
    private int width;

    public Huff(int n) {
        int n2;
        this.domain = n;
        this.toLearn = 1000000;
        int n3 = n * 2 - 1;
        this.symbols = new Symbol[n3];
        for (n2 = 0; n2 < n; ++n2) {
            this.symbols[n2] = new Symbol(n2);
        }
        for (n2 = n; n2 < n3; ++n2) {
            this.symbols[n2] = new Symbol(-1);
        }
    }

    public void generate() {
        if (!this.upToDate) {
            Symbol symbol;
            Symbol symbol2;
            int n;
            Symbol symbol3;
            Symbol symbol4 = symbol3 = this.symbols[0];
            this.table = null;
            symbol3.next = null;
            for (n = 1; n < this.domain; ++n) {
                symbol2 = this.symbols[n];
                if (symbol2.weight < symbol3.weight) {
                    symbol2.next = symbol3;
                    symbol3 = symbol2;
                    continue;
                }
                if (symbol2.weight < symbol4.weight) {
                    symbol4 = symbol3;
                }
                while ((symbol = symbol4.next) != null && symbol2.weight >= symbol.weight) {
                    symbol4 = symbol;
                }
                symbol2.next = symbol;
                symbol4.next = symbol2;
                symbol4 = symbol2;
            }
            n = this.domain;
            symbol4 = symbol3;
            while (true) {
                Symbol symbol5 = symbol3;
                Symbol symbol6 = symbol5.next;
                symbol3 = symbol6.next;
                symbol2 = this.symbols[n];
                ++n;
                symbol2.weight = symbol5.weight + symbol6.weight;
                symbol2.zero = symbol5;
                symbol2.one = symbol6;
                symbol2.back = null;
                symbol5.back = symbol2;
                symbol6.back = symbol2;
                if (symbol3 == null) break;
                if (symbol2.weight < symbol3.weight) {
                    symbol2.next = symbol3;
                    symbol4 = symbol3 = symbol2;
                    continue;
                }
                while ((symbol = symbol4.next) != null && symbol2.weight >= symbol.weight) {
                    symbol4 = symbol;
                }
                symbol2.next = symbol;
                symbol4.next = symbol2;
                symbol4 = symbol2;
            }
            this.table = symbol2;
            this.upToDate = true;
        }
    }

    private boolean postMortem(int n) {
        Symbol symbol;
        int[] nArray = new int[this.domain];
        Symbol symbol2 = this.symbols[n];
        if (symbol2.integer != n) {
            return false;
        }
        int n2 = 0;
        while ((symbol = symbol2.back) != null) {
            if (symbol.zero == symbol2) {
                nArray[n2] = 0;
            } else if (symbol.one == symbol2) {
                nArray[n2] = 1;
            } else {
                return false;
            }
            ++n2;
            symbol2 = symbol;
        }
        if (symbol2 != this.table) {
            return false;
        }
        this.width = 0;
        symbol2 = this.table;
        while (symbol2.integer == -1) {
            symbol2 = nArray[--n2] != 0 ? symbol2.one : symbol2.zero;
        }
        return symbol2.integer == n && n2 == 0;
    }

    @Override
    public boolean postMortem(PostMortem postMortem) {
        for (int i = 0; i < this.domain; ++i) {
            if (this.postMortem(i)) continue;
            JSONzip.log("\nBad huff ");
            JSONzip.logchar(i, i);
            return false;
        }
        return this.table.postMortem(((Huff)postMortem).table);
    }

    public int read(BitReader bitReader) throws JSONException {
        try {
            this.width = 0;
            Symbol symbol = this.table;
            while (symbol.integer == -1) {
                ++this.width;
                symbol = bitReader.bit() ? symbol.one : symbol.zero;
            }
            this.tick(symbol.integer);
            return symbol.integer;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    public void tick(int n) {
        if (this.toLearn > 0) {
            --this.toLearn;
            ++this.symbols[n].weight;
            this.upToDate = false;
        }
    }

    private void write(Symbol symbol, BitWriter bitWriter) throws JSONException {
        try {
            Symbol symbol2 = symbol.back;
            if (symbol2 != null) {
                ++this.width;
                this.write(symbol2, bitWriter);
                if (symbol2.zero == symbol) {
                    bitWriter.zero();
                } else {
                    bitWriter.one();
                }
            }
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    public void write(int n, BitWriter bitWriter) throws JSONException {
        this.width = 0;
        this.write(this.symbols[n], bitWriter);
        this.tick(n);
    }

    private static class Symbol
    implements PostMortem {
        public Symbol back;
        public Symbol next;
        public Symbol zero;
        public Symbol one;
        public final int integer;
        public long weight;

        public Symbol(int n) {
            this.integer = n;
            this.weight = 0L;
            this.next = null;
            this.back = null;
            this.one = null;
            this.zero = null;
        }

        @Override
        public boolean postMortem(PostMortem postMortem) {
            boolean bl = true;
            Symbol symbol = (Symbol)postMortem;
            if (this.integer != symbol.integer || this.weight != symbol.weight) {
                return false;
            }
            if (this.back == null != (symbol.back == null)) {
                return false;
            }
            Symbol symbol2 = this.zero;
            Symbol symbol3 = this.one;
            if (symbol2 == null) {
                if (symbol.zero != null) {
                    return false;
                }
            } else {
                bl = symbol2.postMortem(symbol.zero);
            }
            if (symbol3 == null) {
                if (symbol.one != null) {
                    return false;
                }
            } else {
                bl = symbol3.postMortem(symbol.one);
            }
            return bl;
        }
    }
}

