/*
 * Decompiled with CFR 0.152.
 */
package dnl.logging;

import dnl.logging.Appender;
import dnl.logging.AppendersAddition;
import dnl.logging.CallerData;
import dnl.logging.CallerResolver;
import dnl.logging.LightLogLevel;
import dnl.logging.PrintStreamAppender;
import dnl.logging.SilentAppender;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LightLog {
    private static final String LOG4JREDIRECTOR_CLASS = "ajul.logging.Log4jRedirector";
    private static boolean printShortClassNames = true;
    private static int thresholdLevel = LightLogLevel.INFO.getValue();
    private static Appender appender = new PrintStreamAppender();

    private LightLog() {
    }

    public static void setThresholdLevel(LightLogLevel level) {
        thresholdLevel = level.getValue();
    }

    public static void useLog4j() {
        try {
            Class<?> clazz = Class.forName(LOG4JREDIRECTOR_CLASS);
            appender = (Appender)clazz.newInstance();
        }
        catch (Exception e) {
            System.err.println("Failed loading log4j. Reason: " + e.getMessage());
        }
    }

    public static void shutUp() {
        appender = new SilentAppender();
    }

    public static void useSysoutLogger() {
        appender = new PrintStreamAppender();
    }

    public static void printToFile(File outputFile, boolean outputToConsole) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        PrintStream printStream = new PrintStream(fos, true);
        appender = new PrintStreamAppender(printStream);
        if (outputToConsole) {
            appender = new AppendersAddition(appender, new PrintStreamAppender());
        }
    }

    protected static Appender getLogger() {
        return appender;
    }

    public static void setShowShortNames(boolean shortNames) {
        printShortClassNames = shortNames;
    }

    public static void debug(String s) {
        if (LightLogLevel.DEBUG.getValue() > thresholdLevel) {
            return;
        }
        CallerData caller = CallerResolver.getCallingMethodData();
        appender.debug(caller, s);
    }

    public static void info(String s) {
        if (LightLogLevel.INFO.getValue() > thresholdLevel) {
            return;
        }
        CallerData caller = CallerResolver.getCallingMethodData();
        appender.info(caller, s);
    }

    public static void warn(String s) {
        if (LightLogLevel.WARN.getValue() > thresholdLevel) {
            return;
        }
        CallerData caller = CallerResolver.getCallingMethodData();
        appender.warn(caller, s);
    }

    public static void error(String s) {
        if (LightLogLevel.ERROR.getValue() > thresholdLevel) {
            return;
        }
        CallerData caller = CallerResolver.getCallingMethodData();
        appender.error(caller, s);
    }

    public static void fatal(String s) {
        if (LightLogLevel.FATAL.getValue() > thresholdLevel) {
            return;
        }
        CallerData caller = CallerResolver.getCallingMethodData();
        appender.fatal(caller, s);
    }
}

