/*
 * Decompiled with CFR 0.152.
 */
package dnl.logging;

import dnl.logging.CallerData;
import dnl.logging.CallerResolver;
import dnl.logging.LightLog;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class PerfLog {
    private static HashMap<ThreadCallerPair, Long> thread2Caller = new HashMap();
    private static HashMap<ThreadCallerPair, MethodMarkData> thread2MarkData = new HashMap();

    public static void measure() {
        CallerData caller = CallerResolver.getCallingMethodData();
        ThreadCallerPair key = new ThreadCallerPair(Thread.currentThread(), caller);
        Long t1 = thread2Caller.get(key);
        if (t1 == null) {
            thread2Caller.put(key, new Long(System.currentTimeMillis()));
        } else {
            long t = System.currentTimeMillis() - t1;
            thread2Caller.remove(key);
            LightLog.getLogger().debug(caller, "took " + t + " ms.");
        }
    }

    public static void measureIntermediate(String s) {
        CallerData caller = CallerResolver.getCallingMethodData();
        ThreadCallerPair key = new ThreadCallerPair(Thread.currentThread(), caller);
        Long t1 = thread2Caller.get(key);
        if (t1 == null) {
            thread2Caller.put(key, new Long(System.currentTimeMillis()));
        } else {
            long t = System.currentTimeMillis() - t1;
            LightLog.getLogger().debug(caller, "after " + t + " ms. " + s);
        }
    }

    public static void startMarkContext() {
        thread2MarkData.clear();
    }

    public static void markBegin() {
        PerfLog.markBeginImpl(null);
    }

    public static void markEnd() {
        PerfLog.markEndImpl(null);
    }

    public static void markBegin(String markLabel) {
        PerfLog.markBeginImpl(markLabel);
    }

    public static void markEnd(String markLabel) {
        PerfLog.markEndImpl(markLabel);
    }

    private static void markBeginImpl(String markLabel) {
        CallerData caller = null;
        caller = markLabel == null ? CallerResolver.getCallingMethodData() : new CallerData(String.valueOf(Thread.currentThread().getName()) + ".->" + markLabel);
        ThreadCallerPair key = new ThreadCallerPair(Thread.currentThread(), caller);
        MethodMarkData markData = thread2MarkData.get(key);
        if (markData == null) {
            markData = new MethodMarkData();
            markData.lastMarkTime = System.currentTimeMillis();
            markData.numberOfCalls = 1;
            thread2MarkData.put(key, markData);
        } else {
            markData.lastMarkTime = System.currentTimeMillis();
            ++markData.numberOfCalls;
        }
    }

    public static void markEndImpl(String markLabel) {
        CallerData caller = null;
        caller = markLabel == null ? CallerResolver.getCallingMethodData() : new CallerData(String.valueOf(Thread.currentThread().getName()) + ".->" + markLabel);
        ThreadCallerPair key = new ThreadCallerPair(Thread.currentThread(), caller);
        MethodMarkData markData = thread2MarkData.get(key);
        if (markData == null) {
            LightLog.error("Inconsistent call: " + caller);
        } else {
            long t = System.currentTimeMillis() - markData.lastMarkTime;
            markData.cumulativeTime += t;
        }
    }

    public static void printMarkData(PrintStream ps) {
        for (Map.Entry<ThreadCallerPair, MethodMarkData> me : thread2MarkData.entrySet()) {
            ThreadCallerPair threadAndCaller = me.getKey();
            if (!Thread.currentThread().equals(threadAndCaller.t)) continue;
            MethodMarkData markData = me.getValue();
            ps.println("------------------------------------------------");
            ps.println("Method: " + threadAndCaller.cd.getShortDescription());
            ps.println("Num of calls: " + markData.numberOfCalls);
            ps.println("Cumulative time: " + markData.cumulativeTime + " ms");
        }
    }

    private static class MethodMarkData {
        int numberOfCalls;
        long cumulativeTime;
        long lastMarkTime;

        private MethodMarkData() {
        }
    }

    private static class ThreadCallerPair {
        Thread t;
        CallerData cd;

        ThreadCallerPair(Thread t, CallerData cd) {
            this.t = t;
            this.cd = cd;
        }

        public int hashCode() {
            return this.t.hashCode() * 3 + this.cd.getFullDescription().hashCode() * 7;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ThreadCallerPair)) {
                return false;
            }
            ThreadCallerPair tcp = (ThreadCallerPair)obj;
            return tcp.cd.getFullDescription().equals(this.cd.getFullDescription()) && tcp.t.equals(this.t);
        }
    }
}

