/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.FrameType;
import com.alee.extended.dock.WebDockingPane;
import com.alee.extended.painter.Painter;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WebDockableFrame
extends WebPanel {
    private static ImageIcon dockTop = new ImageIcon(WebDockingPane.class.getResource("icons/dock_top.png"));
    private static ImageIcon dockLeft = new ImageIcon(WebDockingPane.class.getResource("icons/dock_left.png"));
    private static ImageIcon dockRight = new ImageIcon(WebDockingPane.class.getResource("icons/dock_right.png"));
    private static ImageIcon dockBottom = new ImageIcon(WebDockingPane.class.getResource("icons/dock_bottom.png"));
    public static final String ID_PREFIX = "WDF";
    private String frameId;
    private FrameType frameType;
    private WebPanel titlePanel;
    private WebLabel titleLabel;
    private WebButton dock;

    public WebDockableFrame() {
        this("");
    }

    public WebDockableFrame(String string) {
        this(TextUtils.generateId(ID_PREFIX), string);
    }

    public WebDockableFrame(String string, String string2) {
        this(string, null, string2);
    }

    public WebDockableFrame(Icon icon, String string) {
        this(TextUtils.generateId(ID_PREFIX), icon, string);
    }

    public WebDockableFrame(String string, Icon icon, String string2) {
        super(true);
        this.frameId = string;
        this.setShadeWidth(0);
        this.setWebColored(false);
        this.setDrawSides(false, false, false, false);
        this.titlePanel = new WebPanel(true){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setColor(Color.WHITE);
                graphics.drawLine(0, 0, 0, this.getHeight() - 2);
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 2);
            }
        };
        this.titlePanel.setDrawSides(false, false, true, false);
        this.titlePanel.setShadeWidth(0);
        this.add((Component)this.titlePanel, (Object)"North");
        this.titleLabel = new WebLabel(string2, icon);
        this.titleLabel.setMargin(3, 3, 3, 20);
        this.titleLabel.setDrawShade(true);
        this.titlePanel.add((Component)this.titleLabel, (Object)"Center");
        this.dock = new WebButton();
        this.dock.setLeftRightSpacing(0);
        this.dock.setShadeWidth(0);
        this.dock.setDrawSides(false, true, false, false);
        this.titlePanel.add((Component)this.dock, (Object)"East");
    }

    public String getFrameId() {
        return this.frameId;
    }

    public void setFrameId(String string) {
        this.frameId = string;
    }

    public void setIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public Icon getIcon() {
        return this.titleLabel.getIcon();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType frameType) {
        this.frameType = frameType;
        this.setDrawSides(frameType.equals((Object)FrameType.bottom), frameType.equals((Object)FrameType.right), frameType.equals((Object)FrameType.top), frameType.equals((Object)FrameType.left));
        this.dock.setIcon(this.getDockIcon(frameType));
    }

    public void setTitlePainter(Painter painter) {
        this.titlePanel.setPainter(painter);
    }

    public Painter getTitlePainter() {
        return this.titlePanel.getPainter();
    }

    public WebPanel getTitlePanel() {
        return this.titlePanel;
    }

    public WebLabel getTitleLabel() {
        return this.titleLabel;
    }

    private Icon getDockIcon(FrameType frameType) {
        if (frameType.equals((Object)FrameType.top)) {
            return dockTop;
        }
        if (frameType.equals((Object)FrameType.left)) {
            return dockLeft;
        }
        if (frameType.equals((Object)FrameType.right)) {
            return dockRight;
        }
        if (frameType.equals((Object)FrameType.bottom)) {
            return dockBottom;
        }
        return null;
    }
}

