/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.extended.label.WebLinkLabelStyle;
import com.alee.laf.label.WebLabel;
import com.alee.managers.language.LanguageMethods;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.HtmlUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.WebUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebLinkLabel
extends WebLabel
implements LanguageMethods {
    public static final ImageIcon LINK_ICON = new ImageIcon(WebLinkLabel.class.getResource("icons/link.png"));
    public static final ImageIcon EMAIL_ICON = new ImageIcon(WebLinkLabel.class.getResource("icons/email.png"));
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private boolean highlight = WebLinkLabelStyle.highlight;
    private boolean onPressAction = WebLinkLabelStyle.onPressAction;
    private boolean colorVisited = WebLinkLabelStyle.colorVisited;
    private Color foreground = WebLinkLabelStyle.foreground;
    private Color visitedForeground = WebLinkLabelStyle.visitedForeground;
    private Runnable link = null;
    private String actualText = "";
    private boolean mouseover = false;
    private boolean visitedOnce = false;

    public WebLinkLabel() {
        this.initializeSettings();
    }

    public WebLinkLabel(Icon icon) {
        super(icon);
        this.initializeSettings();
    }

    public WebLinkLabel(Icon icon, int n) {
        super(icon, n);
        this.initializeSettings();
    }

    public WebLinkLabel(String string) {
        super(string);
        this.setText(string);
        this.initializeSettings();
    }

    public WebLinkLabel(String string, int n) {
        super(string, n);
        this.setText(string);
        this.initializeSettings();
    }

    public WebLinkLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.setText(string);
        this.initializeSettings();
    }

    private void initializeSettings() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.updateForeground();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (WebLinkLabel.this.onPressAction) {
                    this.performAction(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!WebLinkLabel.this.onPressAction && SwingUtils.size(WebLinkLabel.this).contains(mouseEvent.getPoint())) {
                    this.performAction(mouseEvent);
                }
            }

            private void performAction(MouseEvent mouseEvent) {
                if (WebLinkLabel.this.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    WebLinkLabel.this.visitedOnce = true;
                    WebLinkLabel.this.updateForeground();
                    if (WebLinkLabel.this.link != null) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                WebLinkLabel.this.link.run();
                            }
                        }).start();
                    }
                    WebLinkLabel.this.fireActionPerformed();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (WebLinkLabel.this.isEnabled()) {
                    WebLinkLabel.this.mouseover = true;
                    WebLinkLabel.this.updateText();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (WebLinkLabel.this.highlight) {
                    WebLinkLabel.this.mouseover = false;
                    WebLinkLabel.this.updateText();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (WebLinkLabel.this.highlight) {
                    WebLinkLabel.this.mouseover = false;
                    WebLinkLabel.this.updateText();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public Color getUnvisitedForeground() {
        return this.foreground;
    }

    public void setUnvisitedForeground(Color color) {
        this.setForeground(color);
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        this.updateForeground();
    }

    public Color getVisitedForeground() {
        return this.visitedForeground;
    }

    public void setVisitedForeground(Color color) {
        this.visitedForeground = color;
        this.updateForeground();
    }

    private void updateForeground() {
        WebLinkLabel.super.setForeground(this.colorVisited && this.visitedOnce ? this.visitedForeground : this.foreground);
    }

    public String getActualText() {
        return this.actualText;
    }

    @Override
    public void setText(String string) {
        this.actualText = string;
        this.updateText();
    }

    private void updateText() {
        if (this.mouseover && this.highlight) {
            if (!this.actualText.trim().equals("")) {
                String string = HtmlUtils.hasHtml(this.actualText) ? HtmlUtils.getContent(this.actualText) : this.actualText.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                WebLinkLabel.super.setText("<html><u>" + string + "</u></html>");
            } else {
                WebLinkLabel.super.setText("");
            }
        } else {
            WebLinkLabel.super.setText(this.actualText);
        }
    }

    public boolean isVisitedOnce() {
        return this.visitedOnce;
    }

    public Runnable getLink() {
        return this.link;
    }

    public void setLink(Runnable runnable) {
        this.link = runnable;
    }

    public void setLink(String string, Runnable runnable) {
        this.link = runnable;
    }

    public void setLink(String string) {
        this.setLink(string, true);
    }

    public void setLink(String string, boolean bl) {
        this.setLink(string, string, bl);
    }

    public void setLink(String string, String string2) {
        this.setLink(string, string2, true);
    }

    public void setLink(String string, String string2, boolean bl) {
        this.setLink(string, WebLinkLabel.createAddressLink(string2), bl);
    }

    public void setLink(String string, Runnable runnable, boolean bl) {
        if (bl) {
            this.setIcon(LINK_ICON);
            this.setText(string);
        }
        this.link = runnable;
    }

    public void setEmailLink(String string) {
        this.setEmailLink(string, true);
    }

    public void setEmailLink(String string, boolean bl) {
        this.setEmailLink(string, string, bl);
    }

    public void setEmailLink(String string, String string2) {
        this.setEmailLink(string, string2, true);
    }

    public void setEmailLink(String string, String string2, boolean bl) {
        if (bl) {
            this.setIcon(EMAIL_ICON);
            this.setText(string2);
        }
        this.link = WebLinkLabel.createEmailLink(string2);
    }

    public void setFileLink(File file) {
        this.setFileLink(file, true);
    }

    public void setFileLink(File file, boolean bl) {
        this.setFileLink(FileUtils.getDisplayFileName(file), file, bl);
    }

    public void setFileLink(String string, File file) {
        this.setFileLink(string, file, true);
    }

    public void setFileLink(String string, File file, boolean bl) {
        if (bl) {
            this.setIcon(FileUtils.getFileIcon(file));
            this.setText(string);
        }
        this.link = WebLinkLabel.createFileLink(file);
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean bl) {
        this.highlight = bl;
        this.updateText();
    }

    public boolean isOnPressAction() {
        return this.onPressAction;
    }

    public void setOnPressAction(boolean bl) {
        this.onPressAction = bl;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Link opened");
        for (ActionListener actionListener : CollectionUtils.copy(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private static Runnable createAddressLink(final String string) {
        if (string != null) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        WebUtils.browseSite(string);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
        return null;
    }

    private static Runnable createEmailLink(final String string) {
        if (string != null) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        WebUtils.writeEmail(string);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
        return null;
    }

    private static Runnable createFileLink(final File file) {
        if (file != null) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        WebUtils.openFile(file);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
        return null;
    }
}

