/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;

public class StackLayout
implements LayoutManager {
    public static final String CONTENT = "CONTENT";
    public static final String HIDDEN = "HIDDEN";
    private Map<Component, String> content = new HashMap<Component, String>();

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (!(string == null || string.trim().equals("") || string.equals(CONTENT) || string.equals(HIDDEN))) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be null or an empty/'CONTENT'/'HIDDEN' string");
        }
        this.content.put(component, string == null || string.trim().equals("") ? CONTENT : string);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.content.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        for (Component component : container.getComponents()) {
            if (this.content.get(component) != null && this.content.get(component).equals(HIDDEN)) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        return new Dimension(insets.left + dimension.width + insets.right, insets.top + dimension.height + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        for (Component component : container.getComponents()) {
            if (this.content.get(component) != null && this.content.get(component).equals(HIDDEN)) continue;
            component.setBounds(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
        }
    }
}

