/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListModel;
import com.alee.extended.list.FileViewType;
import com.alee.extended.list.WebFileList;
import com.alee.extended.list.WebFileListCellRenderer;
import com.alee.laf.list.WebListStyle;
import com.alee.laf.list.editor.AbstractListCellEditor;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.utils.FileUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JList;

public class WebFileListCellEditor
extends AbstractListCellEditor<WebTextField, FileElement> {
    private Object savedSelection = null;

    @Override
    protected void installStartEditActions(final JList jList) {
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Hotkey.F2.isTriggered(keyEvent)) {
                    WebFileListCellEditor.this.startEdit(jList, jList.getSelectedIndex());
                }
            }
        };
        jList.addKeyListener(this.keyAdapter);
    }

    @Override
    protected void uninstallStartEditActions(JList jList) {
        jList.removeKeyListener(this.keyAdapter);
    }

    @Override
    public boolean isCellEditable(JList jList, int n, FileElement fileElement) {
        File file = fileElement.getFile();
        return fileElement != null && file.getParentFile() != null && file.canWrite() && file.getParentFile().canWrite() && super.isCellEditable(jList, n, fileElement);
    }

    @Override
    protected WebTextField createCellEditor(JList jList, int n, FileElement fileElement) {
        File file = fileElement.getFile();
        String string = file.getName();
        WebTextField webTextField = WebTextField.createWebTextField(true, WebListStyle.selectionRound, WebListStyle.selectionShadeWidth);
        webTextField.setDrawFocus(false);
        webTextField.setText(string);
        webTextField.setSelectionStart(0);
        webTextField.setSelectionEnd(file.isDirectory() ? string.length() : FileUtils.getFileNamePart(string).length());
        if (jList instanceof WebFileList) {
            boolean bl = ((WebFileList)jList).getFileViewType().equals((Object)FileViewType.tiles);
            webTextField.setHorizontalAlignment(bl ? 2 : 0);
        }
        return webTextField;
    }

    @Override
    protected Rectangle getEditorBounds(JList jList, int n, FileElement fileElement, Rectangle rectangle) {
        if (jList instanceof WebFileList) {
            WebFileListCellRenderer webFileListCellRenderer = ((WebFileList)jList).getWebFileListCellRenderer();
            Rectangle rectangle2 = webFileListCellRenderer.getDescriptionPanel().getBounds();
            Dimension dimension = ((WebTextField)this.editor).getPreferredSize();
            return new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height / 2 - dimension.height / 2, rectangle2.width, dimension.height);
        }
        return super.getEditorBounds(jList, n, fileElement, rectangle);
    }

    @Override
    public FileElement getCellEditorValue(JList jList, int n, FileElement fileElement) {
        this.savedSelection = jList.getSelectedValue();
        File file = new File(fileElement.getFile().getParent(), ((WebTextField)this.editor).getText());
        if (fileElement.getFile().renameTo(file)) {
            if (this.savedSelection == fileElement) {
                this.savedSelection = file;
            }
            return new FileElement(file);
        }
        return fileElement;
    }

    @Override
    public boolean updateListModel(JList jList, int n, FileElement fileElement, FileElement fileElement2, boolean bl) {
        if (jList.getModel() instanceof FileListModel) {
            FileListModel fileListModel = (FileListModel)jList.getModel();
            if (!fileElement.getFile().getAbsolutePath().equals(fileElement2.getFile().getAbsolutePath())) {
                fileListModel.setElementAt(fileElement2, n);
                if (this.savedSelection != null) {
                    jList.setSelectedValue(this.savedSelection, true);
                } else {
                    jList.clearSelection();
                }
                jList.repaint();
                return true;
            }
            return false;
        }
        return super.updateListModel(jList, n, fileElement, fileElement2, bl);
    }

    @Override
    public void editStarted(JList jList, int n) {
        HotkeyManager.disableHotkeys();
        super.editStarted(jList, n);
    }

    @Override
    public void editStopped(JList jList, int n, FileElement fileElement, FileElement fileElement2) {
        HotkeyManager.enableHotkeys();
        super.editStopped(jList, n, fileElement, fileElement2);
    }

    @Override
    public void editCancelled(JList jList, int n) {
        HotkeyManager.enableHotkeys();
        super.editCancelled(jList, n);
    }
}

