/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.statusbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.statusbar.WebStatusBarStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.toolbar.WhiteSpace;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class WebStatusBar
extends JComponent {
    private Color topBgColor = WebStatusBarStyle.topBgColor;
    private Color bottomBgColor = WebStatusBarStyle.bottomBgColor;
    private Insets margin = WebStatusBarStyle.margin;
    private boolean undecorated = WebStatusBarStyle.undecorated;

    public WebStatusBar() {
        SwingUtils.setOrientation(this);
        this.setLayout(new ToolbarLayout());
        this.updateBorder();
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder();
    }

    public void addSeparator() {
        this.addSeparator("START");
    }

    public void addSeparatorToEnd() {
        this.addSeparator("END");
    }

    public void addSeparator(String string) {
        this.add((Component)WebStatusBar.createSeparator(), string);
    }

    public void addToMiddle(Component component) {
        this.add(component, "MIDDLE");
    }

    public void addFill(Component component) {
        this.add(component, "FILL");
    }

    public void addToEnd(Component component) {
        this.add(component, "END");
    }

    public void addSpacing() {
        this.addSpacing(StyleConstants.contentSpacing);
    }

    public void addSpacing(int n) {
        this.addSpacing(n, "START");
    }

    public void addSpacingToEnd() {
        this.addSpacingToEnd(StyleConstants.contentSpacing);
    }

    public void addSpacingToEnd(int n) {
        this.addSpacing(n, "END");
    }

    public void addSpacing(int n, String string) {
        this.add((Component)new WhiteSpace(n), string);
    }

    private void updateBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(this.margin.top + (this.undecorated ? 0 : 1), this.margin.left, this.margin.bottom, this.margin.right));
    }

    public ToolbarLayout getActualLayout() {
        return (ToolbarLayout)this.getLayout();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.undecorated) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(StyleConstants.darkBorderColor);
            graphics2D.drawLine(0, 0, this.getWidth() - 1, 0);
        }
    }

    private static WebSeparator createSeparator() {
        return new WebSeparator(1);
    }
}

