/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeDataProvider;
import com.alee.extended.tree.AsyncTreeListener;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncTreeModelListener;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTreeCellRenderer;
import com.alee.extended.tree.sample.SampleDataProvider;
import com.alee.extended.tree.sample.SampleTreeCellEditor;
import com.alee.extended.tree.sample.SampleTreeCellRenderer;
import com.alee.laf.tree.WebTree;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebAsyncTree<E extends AsyncUniqueNode>
extends WebTree<E>
implements AsyncTreeModelListener<E> {
    private List<AsyncTreeListener> asyncTreeListeners = new ArrayList<AsyncTreeListener>();
    private final Object listenersLock = new Object();
    private AsyncTreeDataProvider dataProvider;

    public WebAsyncTree() {
        this.setDataProvider(new SampleDataProvider());
        this.setCellRenderer(new SampleTreeCellRenderer());
        this.setCellEditor(new SampleTreeCellEditor());
    }

    public WebAsyncTree(AsyncTreeDataProvider asyncTreeDataProvider) {
        this.setDataProvider(asyncTreeDataProvider);
        this.setCellRenderer(new WebAsyncTreeCellRenderer());
        this.setCellEditor(new WebTreeCellEditor());
    }

    public AsyncTreeDataProvider<E> getDataProvider() {
        return this.getAsyncModel().getDataProvider();
    }

    public void setDataProvider(AsyncTreeDataProvider asyncTreeDataProvider) {
        if (asyncTreeDataProvider != null) {
            this.setModel(new AsyncTreeModel(this, asyncTreeDataProvider));
        }
    }

    @Override
    public void setModel(TreeModel treeModel) {
        if (this.getModel() instanceof AsyncTreeModel) {
            this.getAsyncModel().removeAsyncTreeModelListener(this);
        }
        if (treeModel instanceof AsyncTreeModel) {
            ((AsyncTreeModel)treeModel).addAsyncTreeModelListener(this);
        }
        super.setModel(treeModel);
    }

    public AsyncTreeModel getAsyncModel() {
        return (AsyncTreeModel)super.getModel();
    }

    public void reloadSelectedNodes() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                AsyncUniqueNode asyncUniqueNode = (AsyncUniqueNode)this.getNodeForPath(treePath);
                if (asyncUniqueNode == null || asyncUniqueNode.isBusy()) continue;
                this.performReload(asyncUniqueNode, treePath, false);
            }
        }
    }

    public void reloadNode(E e) {
        this.reloadNode(e, false);
    }

    public void reloadNode(E e, boolean bl) {
        if (e != null && !((AsyncUniqueNode)e).isBusy()) {
            this.performReload(e, this.getPathForNode(e), bl);
        }
    }

    public void reloadPath(TreePath treePath) {
        this.reloadPath(treePath, false);
    }

    public void reloadPath(TreePath treePath, boolean bl) {
        AsyncUniqueNode asyncUniqueNode;
        if (treePath != null && (asyncUniqueNode = (AsyncUniqueNode)this.getNodeForPath(treePath)) != null && !asyncUniqueNode.isBusy()) {
            this.performReload(asyncUniqueNode, treePath, bl);
        }
    }

    private void performReload(E e, TreePath treePath, boolean bl) {
        if (bl && !this.isPathSelected(treePath)) {
            this.setSelectionPath(treePath);
        }
        if (!this.isExpanded(treePath)) {
            this.expandPath(treePath);
        }
        if (e != null && !((AsyncUniqueNode)e).isBusy()) {
            this.getAsyncModel().reload((TreeNode)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncTreeListener> getAsyncTreeListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            return CollectionUtils.copy(this.asyncTreeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncTreeListener(AsyncTreeListener asyncTreeListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.asyncTreeListeners.add(asyncTreeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAsyncTreeListener(AsyncTreeListener asyncTreeListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.asyncTreeListeners.add(asyncTreeListener);
        }
    }

    @Override
    public void childsLoadStarted(E e) {
        this.fireChildsLoadStarted(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChildsLoadStarted(E e) {
        List<AsyncTreeListener> list;
        Iterator<AsyncTreeListener> iterator = this.listenersLock;
        synchronized (iterator) {
            list = CollectionUtils.copy(this.asyncTreeListeners);
        }
        for (AsyncTreeListener asyncTreeListener : list) {
            asyncTreeListener.childsLoadStarted(e);
        }
    }

    @Override
    public void childsLoadCompleted(E e, List<E> list) {
        this.fireChildsLoadCompleted(e, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChildsLoadCompleted(E e, List<E> list) {
        List<AsyncTreeListener> list2;
        Iterator<AsyncTreeListener> iterator = this.listenersLock;
        synchronized (iterator) {
            list2 = CollectionUtils.copy(this.asyncTreeListeners);
        }
        for (AsyncTreeListener asyncTreeListener : list2) {
            asyncTreeListener.childsLoadCompleted(e, list);
        }
    }

    @Override
    public final void expandAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            TreePath treePath = this.getPathForRow(i);
            if (this.getModel().isLeaf(this.getNodeForPath(treePath))) continue;
            this.performPathExpand(treePath);
        }
    }

    private void performPathExpand(TreePath treePath) {
        if (this.hasBeenExpanded(treePath)) {
            this.performSyncPathExpand(treePath);
        } else {
            this.performAsyncPathExpand(treePath);
        }
    }

    private void performSyncPathExpand(TreePath treePath) {
        this.expandPath(treePath);
        AsyncUniqueNode asyncUniqueNode = (AsyncUniqueNode)this.getNodeForPath(treePath);
        for (int i = 0; i < asyncUniqueNode.getChildCount(); ++i) {
            this.performPathExpand(this.getPathForNode((AsyncUniqueNode)asyncUniqueNode.getChildAt(i)));
        }
    }

    private void performAsyncPathExpand(final TreePath treePath) {
        this.addAsyncTreeListener(new AsyncTreeAdapter<E>(){

            @Override
            public void childsLoadCompleted(E e, List<E> list) {
                if (e == WebAsyncTree.this.getNodeForPath(treePath)) {
                    for (AsyncUniqueNode asyncUniqueNode : list) {
                        WebAsyncTree.this.performPathExpand(new TreePath(asyncUniqueNode.getPath()));
                    }
                }
            }
        });
        this.expandPath(treePath);
    }
}

