/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.colorchooser.PaletteColorChooserPaint;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PaletteColorChooser
extends WebPanel {
    public static final ImageIcon LOOP_ICON = new ImageIcon(PaletteColorChooser.class.getResource("icons/loop.png"));
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private boolean adjusting = false;
    private boolean webOnlyColors = false;
    private Color sideColor = Color.RED;
    private Color color = Color.WHITE;
    private PaletteColorChooserPaint paletteColorChooserPaint = new PaletteColorChooserPaint(0, 0, 256, 256, this.sideColor);
    private BufferedImage image = ImageUtils.createCompatibleImage(256, 256, 3);
    private Point coordinate = new Point(2, 2);
    private JComponent colorChooser;

    public PaletteColorChooser() {
        this.repaintImage();
        this.setLayout(new TableLayout(new double[][]{{-2.0}, {3.0, -2.0, 3.0}}));
        this.colorChooser = new JComponent(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Shape shape = graphics2D.getClip();
                Area area = new Area(new Rectangle2D.Double(2.0, 2.0, this.getWidth() - 4, this.getHeight() - 4));
                area.intersect(new Area(shape));
                graphics2D.setClip(area);
                graphics2D.drawImage((Image)PaletteColorChooser.this.image, 2, 2, null);
                graphics2D.drawImage(LOOP_ICON.getImage(), ((PaletteColorChooser)PaletteColorChooser.this).coordinate.x - LOOP_ICON.getIconWidth() / 2, ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y - LOOP_ICON.getIconHeight() / 2, LOOP_ICON.getImageObserver());
                graphics2D.setClip(shape);
            }
        };
        this.colorChooser.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createLineBorder(Color.WHITE, 1)));
        this.colorChooser.setPreferredSize(new Dimension(260, 260));
        ColorChooserMouseAdapter colorChooserMouseAdapter = new ColorChooserMouseAdapter();
        this.colorChooser.addMouseListener(colorChooserMouseAdapter);
        this.colorChooser.addMouseMotionListener(colorChooserMouseAdapter);
        this.add((Component)this.colorChooser, (Object)"0,1");
    }

    public JComponent getColorChooser() {
        return this.colorChooser;
    }

    private void repaintImage() {
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setPaint(this.paletteColorChooserPaint);
        graphics2D.fillRect(0, 0, 256, 256);
        graphics2D.dispose();
    }

    private Cursor createLoopCursor() {
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(14, 14);
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(dimension.width, dimension.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(LOOP_ICON.getImage(), 0, 0, LOOP_ICON.getImageObserver());
        graphics2D.dispose();
        return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, new Point(7, 7), "Loop Cursor");
    }

    public Color getSideColor() {
        return this.sideColor;
    }

    public void setSideColor(Color color) {
        this.adjusting = true;
        this.sideColor = color;
        this.paletteColorChooserPaint = new PaletteColorChooserPaint(1, 1, 256, 256, color);
        this.paletteColorChooserPaint.setWebSafe(this.webOnlyColors);
        this.repaintImage();
        this.setColor(this.paletteColorChooserPaint.getColor(this.coordinate.x, this.coordinate.y));
        this.adjusting = false;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (!this.adjusting) {
            this.updateSelectionByColor();
        }
        this.firePropertyChanged();
        this.colorChooser.repaint();
    }

    public boolean isWebOnlyColors() {
        return this.webOnlyColors;
    }

    public void setWebOnlyColors(boolean bl) {
        this.webOnlyColors = bl;
        this.paletteColorChooserPaint.setWebSafe(bl);
        this.repaintImage();
        this.colorChooser.repaint();
        this.firePropertyChanged();
    }

    private void updateSelectionByColor() {
        HSBColor hSBColor = new HSBColor(this.color);
        this.coordinate.x = 2 + Math.round(256.0f * hSBColor.getSaturation());
        this.coordinate.y = 2 + Math.round(256.0f - 256.0f * hSBColor.getBrightness());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void firePropertyChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private class ColorChooserMouseAdapter
    extends MouseAdapter {
        private boolean dragging = false;

        private ColorChooserMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dragging = true;
            PaletteColorChooser.this.adjusting = true;
            this.updateCoordinate(mouseEvent.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateCoordinate(mouseEvent.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
            PaletteColorChooser.this.adjusting = false;
            if (!PaletteColorChooser.this.colorChooser.getVisibleRect().contains(mouseEvent.getPoint())) {
                PaletteColorChooser.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        private void updateCoordinate(Point point) {
            PaletteColorChooser.this.coordinate = point;
            if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.x < 2) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.x = 2;
            } else if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.x > 258) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.x = 258;
            }
            if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.y < 2) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y = 2;
            } else if (((PaletteColorChooser)PaletteColorChooser.this).coordinate.y > 258) {
                ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y = 258;
            }
            PaletteColorChooser.this.setColor(PaletteColorChooser.this.paletteColorChooserPaint.getColor(((PaletteColorChooser)PaletteColorChooser.this).coordinate.x, ((PaletteColorChooser)PaletteColorChooser.this).coordinate.y));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            PaletteColorChooser.this.setCursor(PaletteColorChooser.this.createLoopCursor());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.dragging) {
                PaletteColorChooser.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

