/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.laf.StyleConstants;
import com.alee.laf.menu.MenubarStyle;
import com.alee.laf.menu.WebMenuBarStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class WebMenuBarUI
extends BasicMenuBarUI
implements ShapeProvider {
    private boolean undecorated = WebMenuBarStyle.undecorated;
    private int round = WebMenuBarStyle.round;
    private int shadeWidth = WebMenuBarStyle.shadeWidth;
    private MenubarStyle menubarStyle = WebMenuBarStyle.menubarStyle;
    private Color borderColor = WebMenuBarStyle.borderColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebMenuBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.menuBar);
        this.menuBar.setLayout(new ToolbarLayout(0));
        this.menuBar.setOpaque(false);
        this.updateBorder(this.menuBar);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.menuBar, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder(JComponent jComponent) {
        if (!this.undecorated) {
            if (this.menubarStyle.equals((Object)MenubarStyle.attached)) {
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 1 + this.shadeWidth, 0));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(1 + this.shadeWidth, 1 + this.shadeWidth, 1 + this.shadeWidth, 1 + this.shadeWidth));
            }
        } else {
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
        this.updateBorder(this.menuBar);
    }

    public MenubarStyle getMenubarStyle() {
        return this.menubarStyle;
    }

    public void setMenubarStyle(MenubarStyle menubarStyle) {
        this.menubarStyle = menubarStyle;
        this.updateBorder(this.menuBar);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder(this.menuBar);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.undecorated) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.menubarStyle.equals((Object)MenubarStyle.attached)) {
                Line2D.Double double_ = new Line2D.Double(0.0, jComponent.getHeight() - 1 - this.shadeWidth, jComponent.getWidth() - 1, jComponent.getHeight() - 1 - this.shadeWidth);
                LafUtils.drawShade(graphics2D, double_, StyleConstants.shadeColor, this.shadeWidth);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, StyleConstants.topBgColor, 0.0f, jComponent.getHeight(), new Color(235, 235, 235)));
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight() - this.shadeWidth);
                graphics2D.setPaint(this.borderColor);
                graphics2D.draw(double_);
            } else {
                LafUtils.drawWebStyle(graphics2D, jComponent, StyleConstants.shadeColor, this.shadeWidth, this.round, true, true, this.borderColor);
            }
        }
    }
}

