/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBarUI;
import com.alee.laf.toolbar.WhiteSpace;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Shape;
import java.util.List;
import javax.swing.JToolBar;

public class WebToolBar
extends JToolBar
implements ShapeProvider {
    public WebToolBar() {
    }

    public WebToolBar(String string) {
        super(string);
    }

    public WebToolBar(String string, int n) {
        super(string, n);
    }

    public WebToolBar(int n) {
        super(n);
    }

    public void addToMiddle(Component component) {
        this.add(component, (Object)"MIDDLE");
    }

    public void addFill(Component component) {
        this.add(component, (Object)"FILL");
    }

    public void addToEnd(Component component) {
        this.add(component, (Object)"END");
    }

    @Override
    public void addSeparator() {
        this.addSeparator("START");
    }

    public void addSeparatorToEnd() {
        this.addSeparator("END");
    }

    public void addSeparator(String string) {
        this.add((Component)new JToolBar.Separator(), (Object)string);
    }

    public void addSpacing() {
        this.addSpacing(StyleConstants.contentSpacing);
    }

    public void addSpacing(int n) {
        this.addSpacing(n, "START");
    }

    public void addSpacingToEnd() {
        this.addSpacingToEnd(StyleConstants.contentSpacing);
    }

    public void addSpacingToEnd(int n) {
        this.addSpacing(n, "END");
    }

    public void addSpacing(int n, String string) {
        this.add((Component)new WhiteSpace(n), (Object)string);
    }

    public void add(List<? extends Component> list, int n) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.add(list.get(i), n + i);
            }
        }
    }

    public void add(List<? extends Component> list, String string) {
        if (list != null) {
            for (Component component : list) {
                this.add(component, (Object)string);
            }
        }
    }

    public void add(List<? extends Component> list) {
        if (list != null) {
            for (Component component : list) {
                this.add(component);
            }
        }
    }

    public void add(int n, Component ... componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.add(componentArray[i], n + i);
            }
        }
    }

    public void add(String string, Component ... componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            for (Component component : componentArray) {
                this.add(component, (Object)string);
            }
        }
    }

    public void add(Component ... componentArray) {
        if (componentArray != null && componentArray.length > 0) {
            for (Component component : componentArray) {
                this.add(component);
            }
        }
    }

    public Component getFirstComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public Component getLastComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(this.getComponentCount() - 1);
        }
        return null;
    }

    public boolean isUndecorated() {
        return this.getWebUI().isUndecorated();
    }

    public void setUndecorated(boolean bl) {
        this.getWebUI().setUndecorated(bl);
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public void setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public void setRound(int n) {
        this.getWebUI().setRound(n);
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public void setShadeWidth(int n) {
        this.getWebUI().setShadeWidth(n);
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    @Override
    public void setMargin(Insets insets) {
        this.getWebUI().setMargin(insets);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    public ToolbarStyle getToolbarStyle() {
        return this.getWebUI().getToolbarStyle();
    }

    public void setToolbarStyle(ToolbarStyle toolbarStyle) {
        this.getWebUI().setToolbarStyle(toolbarStyle);
    }

    public int getSpacing() {
        return this.getWebUI().getSpacing();
    }

    public void setSpacing(int n) {
        this.getWebUI().setSpacing(n);
    }

    public Color getTopBgColor() {
        return this.getWebUI().getTopBgColor();
    }

    public void setTopBgColor(Color color) {
        this.getWebUI().setTopBgColor(color);
    }

    public Color getBottomBgColor() {
        return this.getWebUI().getBottomBgColor();
    }

    public void setBottomBgColor(Color color) {
        this.getWebUI().setBottomBgColor(color);
    }

    public Color getBorderColor() {
        return this.getWebUI().getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.getWebUI().setBorderColor(color);
    }

    public ToolbarLayout getToolbarLayout() {
        return (ToolbarLayout)this.getLayout();
    }

    public boolean isFloating() {
        return this.getWebUI().isFloating();
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebToolBarUI getWebUI() {
        return (WebToolBarUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebToolBarUI)) {
            try {
                this.setUI((WebToolBarUI)ReflectUtils.createInstance(WebLookAndFeel.toolBarUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebToolBarUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }
}

