/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.event.KeyEvent;
import java.io.Serializable;

@XStreamAlias(value="HotkeyData")
public class HotkeyData
implements Serializable {
    @XStreamAsAttribute
    private boolean isCtrl;
    @XStreamAsAttribute
    private boolean isAlt;
    @XStreamAsAttribute
    private boolean isShift;
    @XStreamAsAttribute
    private Integer keyCode;
    private transient Integer hashCode;

    public HotkeyData() {
        this.isCtrl = false;
        this.isAlt = false;
        this.isShift = false;
        this.keyCode = null;
        this.hashCode = null;
    }

    public HotkeyData(KeyEvent keyEvent) {
        this.isCtrl = SwingUtils.isCtrl(keyEvent);
        this.isAlt = SwingUtils.isAlt(keyEvent);
        this.isShift = SwingUtils.isShift(keyEvent);
        this.keyCode = keyEvent.getKeyCode();
        this.hashCode = null;
    }

    public HotkeyData(Integer n) {
        this.isCtrl = false;
        this.isAlt = false;
        this.isShift = false;
        this.keyCode = n;
        this.hashCode = null;
    }

    public HotkeyData(boolean bl, boolean bl2, boolean bl3, Integer n) {
        this.isCtrl = bl;
        this.isAlt = bl2;
        this.isShift = bl3;
        this.keyCode = n;
        this.hashCode = null;
    }

    public boolean isCtrl() {
        return this.isCtrl;
    }

    public void setCtrl(boolean bl) {
        this.isCtrl = bl;
        this.hashCode = null;
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public void setAlt(boolean bl) {
        this.isAlt = bl;
        this.hashCode = null;
    }

    public boolean isShift() {
        return this.isShift;
    }

    public void setShift(boolean bl) {
        this.isShift = bl;
        this.hashCode = null;
    }

    public Integer getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(Integer n) {
        this.keyCode = n;
        this.hashCode = null;
    }

    public boolean isHotkeySet() {
        return this.keyCode != null;
    }

    public boolean isTriggered(KeyEvent keyEvent) {
        return this.areControlsTriggered(keyEvent) && this.isKeyTriggered(keyEvent);
    }

    public boolean areControlsTriggered(KeyEvent keyEvent) {
        return SwingUtils.isShortcut(keyEvent) == this.isCtrl && SwingUtils.isAlt(keyEvent) == this.isAlt && SwingUtils.isShift(keyEvent) == this.isShift;
    }

    public boolean isKeyTriggered(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == this.keyCode.intValue();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof HotkeyData && object.hashCode() == this.hashCode();
    }

    public String toString() {
        return SwingUtils.hotkeyToString(this);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }
}

