/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Value;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="record")
public final class Record
implements Serializable,
Cloneable {
    @XStreamAsAttribute
    private String key;
    @XStreamAsAttribute
    private String hotkey;
    @XStreamImplicit
    private List<Value> values;

    public Record() {
        this(null);
    }

    public Record(String string) {
        this(string, new ArrayList<Value>());
    }

    public Record(String string, Value ... valueArray) {
        this.setKey(string);
        this.setValues(CollectionUtils.copy(valueArray));
    }

    public Record(String string, List<Value> list) {
        this.setKey(string);
        this.setValues(CollectionUtils.copy(list));
    }

    public Record(String string, String string2, Value ... valueArray) {
        this.setKey(string);
        this.setHotkey(string2);
        this.setValues(CollectionUtils.copy(valueArray));
    }

    public Record(String string, String string2, List<Value> list) {
        this.setKey(string);
        this.setHotkey(string2);
        this.setValues(CollectionUtils.copy(list));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String string) {
        this.hotkey = string;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public void setValues(List<Value> list) {
        this.values = list;
    }

    public Value addValue(Value value) {
        this.values.add(value);
        return value;
    }

    public void removeValue(Value value) {
        this.values.remove(value);
    }

    public void removeValue(String string) {
        for (int i = 0; i < this.values.size(); ++i) {
            String string2 = this.values.get(i).getLang();
            if (!CompareUtils.equals(string2, string)) continue;
            this.values.remove(i);
        }
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public String getText(String string) {
        return this.getText(string, null);
    }

    public String getText(String string, String string2) {
        Value value = this.getValue(string);
        return value != null ? value.getText(string2) : null;
    }

    public Value getValue(String string) {
        for (Value value : this.values) {
            String string2 = value.getLang();
            if (string2 != null && !CompareUtils.equals(string2, string)) continue;
            return value;
        }
        return null;
    }

    public Record clone() {
        return new Record(this.key, this.hotkey, CollectionUtils.clone(this.values));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        return (bl ? "<html><b>" : "") + this.key + (bl ? "</b>" : "") + (this.hotkey != null ? " (" + this.hotkey + ")" : "") + " -> " + (this.values != null ? "{ " + TextUtils.listToString(this.values, "; ") + " }" : "null") + (bl ? "</html>" : "");
    }
}

