/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.ValueConverter;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="value")
@XStreamConverter(value=ValueConverter.class)
public final class Value
implements Serializable,
Cloneable {
    private String lang;
    private Character mnemonic;
    private String hotkey;
    private List<Text> texts;
    private List<Tooltip> tooltips;

    public Value() {
        this.setTexts(new ArrayList<Text>());
        this.setTooltips(new ArrayList<Tooltip>());
    }

    public Value(String string, String string2) {
        this.setLang(string);
        this.setTexts(CollectionUtils.copy(new Text(string2)));
        this.setTooltips(new ArrayList<Tooltip>());
    }

    public Value(String string, Character c, String string2) {
        this.setLang(string);
        this.setMnemonic(c);
        this.setTexts(CollectionUtils.copy(new Text(string2)));
        this.setTooltips(new ArrayList<Tooltip>());
    }

    public Value(String string, String string2, String string3) {
        this.setLang(string);
        this.setHotkey(string2);
        this.setTexts(CollectionUtils.copy(new Text(string3)));
        this.setTooltips(new ArrayList<Tooltip>());
    }

    public Value(String string, Character c, String string2, String string3) {
        this.setLang(string);
        this.setMnemonic(c);
        this.setHotkey(string2);
        this.setTexts(CollectionUtils.copy(new Text(string3)));
        this.setTooltips(new ArrayList<Tooltip>());
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public Character getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(Character c) {
        this.mnemonic = c;
    }

    public String getHotkey() {
        return this.hotkey;
    }

    public void setHotkey(String string) {
        this.hotkey = string;
    }

    public List<Text> getTexts() {
        return this.texts;
    }

    public void setTexts(List<Text> list) {
        this.texts = list;
    }

    public String getText() {
        return this.getText(null);
    }

    public String getText(String string) {
        return this.getText(string, false);
    }

    public String getText(String string, boolean bl) {
        Text text = this.getTextObject(string, bl);
        return text != null ? text.getText() : null;
    }

    public Text getTextObject() {
        return this.getTextObject(null);
    }

    public Text getTextObject(String string) {
        return this.getTextObject(string, false);
    }

    public Text getTextObject(String string, boolean bl) {
        if (this.texts != null) {
            for (Text text : this.texts) {
                if (!CompareUtils.equals(text.getState(), string) && (!bl || text.getState() != null)) continue;
                return text;
            }
        }
        return null;
    }

    public Text getTextObject(int n) {
        return this.texts.get(n);
    }

    public Text addText(String string) {
        return this.addText(new Text(string));
    }

    public Text addText(String string, String string2) {
        return this.addText(new Text(string, string2));
    }

    public Text addText(Text text) {
        this.texts.add(text);
        return text;
    }

    public void removeText(Text text) {
        this.texts.remove(text);
    }

    public List<Tooltip> getTooltips() {
        return this.tooltips;
    }

    public void setTooltips(List<Tooltip> list) {
        this.tooltips = list;
    }

    public Tooltip addTooltip(String string) {
        return this.addTooltip(new Tooltip(string));
    }

    public Tooltip addTooltip(Integer n, String string) {
        return this.addTooltip(new Tooltip(n, string));
    }

    public Tooltip addTooltip(TooltipWay tooltipWay, String string) {
        return this.addTooltip(new Tooltip(tooltipWay, string));
    }

    public Tooltip addTooltip(TooltipWay tooltipWay, Integer n, String string) {
        return this.addTooltip(new Tooltip(tooltipWay, n, string));
    }

    public Tooltip addTooltip(TooltipType tooltipType, String string) {
        return this.addTooltip(new Tooltip(tooltipType, string));
    }

    public Tooltip addTooltip(Tooltip tooltip) {
        this.tooltips.add(tooltip);
        return tooltip;
    }

    public void removeTooltip(Tooltip tooltip) {
        this.tooltips.remove(tooltip);
    }

    public Tooltip getTooltipObject(int n) {
        return this.tooltips.get(n);
    }

    private String langText() {
        return this.lang != null ? this.lang : "all";
    }

    private String listTexts() {
        if (this.texts == null || this.texts.size() == 0) {
            return "";
        }
        if (this.texts.size() == 1) {
            return this.texts.get(0).toString();
        }
        return "{" + TextUtils.listToString(this.texts, ";") + "}";
    }

    public Value clone() {
        Value value = new Value();
        value.setLang(this.lang);
        value.setMnemonic(this.mnemonic);
        value.setHotkey(this.hotkey);
        value.setTexts(CollectionUtils.clone(this.texts));
        value.setTooltips(CollectionUtils.clone(this.tooltips));
        return value;
    }

    public String toString() {
        return this.langText() + " -> " + this.listTexts() + (this.mnemonic != null ? " (" + this.mnemonic + ")" : "") + (this.hotkey != null ? " (" + this.hotkey + ")" : "") + (this.tooltips != null && this.tooltips.size() > 0 ? " (tooltips: " + this.tooltips.size() + ")" : "");
    }
}

