/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebUtils {
    public static String normalizeUrl(String string) {
        try {
            return new URI(string).normalize().toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return string;
        }
    }

    public static Map<String, List<String>> getUrlParameters(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String[] stringArray = string.split("\\?");
        if (stringArray.length > 1) {
            String string2 = stringArray[1];
            for (String string3 : string2.split("&")) {
                ArrayList<String> arrayList;
                String[] stringArray2 = string3.split("=");
                String string4 = WebUtils.decodeUrl(stringArray2[0]);
                String string5 = "";
                if (stringArray2.length > 1) {
                    string5 = WebUtils.decodeUrl(stringArray2[1]);
                }
                if ((arrayList = (ArrayList<String>)hashMap.get(string4)) == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string4, arrayList);
                }
                arrayList.add(string5);
            }
        }
        return hashMap;
    }

    public static String encodeUrl(String string) {
        try {
            URL uRL = new URL(string);
            URI uRI = new URI(uRL.getProtocol(), uRL.getHost(), uRL.getPath(), uRL.getQuery(), null);
            return uRI.toASCIIString();
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String decodeUrl(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static void shareOnTwitter(final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebUtils.browseSite("http://twitter.com/intent/tweet?text=" + string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static void shareOnVk(final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebUtils.browseSite("http://vkontakte.ru/share.php?url=" + string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static void shareOnFb(final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WebUtils.browseSite("http://www.facebook.com/sharer.php?u=" + string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }

    public static void browseSiteSafely(String string) {
        try {
            WebUtils.browseSite(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void browseSite(String string) throws URISyntaxException, IOException {
        Desktop.getDesktop().browse(new URI(string));
    }

    public static void openFileSafely(File file) {
        try {
            WebUtils.openFile(file);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void openFile(File file) throws IOException {
        Desktop.getDesktop().open(file);
    }

    public static void writeEmailSafely(String string) {
        try {
            WebUtils.writeEmail(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void writeEmail(String string) throws URISyntaxException, IOException {
        WebUtils.writeEmail(string, null, null);
    }

    public static void writeEmailSafely(String string, String string2, String string3) {
        try {
            WebUtils.writeEmail(string, string2, string3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void writeEmail(String string, String string2, String string3) throws URISyntaxException, IOException {
        URI uRI;
        if (!string.startsWith("mailto:")) {
            string = "mailto:" + string;
        }
        if (string2 != null && string3 != null) {
            string2 = string2.replaceAll(" ", "%20");
            string3 = string3.replaceAll(" ", "%20");
            uRI = new URI(string + "?subject=" + string2 + "&body=" + string3);
        } else {
            uRI = new URI(string);
        }
        Desktop.getDesktop().mail(uRI);
    }
}

