/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.laf.StyleConstants;
import com.alee.utils.swing.Timer;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ComponentUpdater
extends Timer
implements AncestorListener {
    private JComponent component;

    public ComponentUpdater(JComponent jComponent) {
        super(StyleConstants.avgAnimationDelay);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, long l) {
        super(l);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, String string, long l) {
        super(string, l);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, long l, long l2) {
        super(l, l2);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, String string, long l, long l2) {
        super(string, l, l2);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, long l, ActionListener actionListener) {
        super(l, actionListener);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, String string, long l, ActionListener actionListener) {
        super(string, l, actionListener);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, long l, long l2, ActionListener actionListener) {
        super(l, l2, actionListener);
        this.initialize(jComponent);
    }

    public ComponentUpdater(JComponent jComponent, String string, long l, long l2, ActionListener actionListener) {
        super(string, l, l2, actionListener);
        this.initialize(jComponent);
    }

    private void initialize(JComponent jComponent) {
        this.component = jComponent;
        jComponent.addAncestorListener(this);
    }

    public void uninstall() {
        this.component.removeAncestorListener(this);
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.start();
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.stop();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public static ComponentUpdater install(JComponent jComponent) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent);
    }

    public static ComponentUpdater install(JComponent jComponent, long l) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, l);
    }

    public static ComponentUpdater install(JComponent jComponent, String string, long l) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, string, l);
    }

    public static ComponentUpdater install(JComponent jComponent, long l, long l2) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, l, l2);
    }

    public static ComponentUpdater install(JComponent jComponent, String string, long l, long l2) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, string, l, l2);
    }

    public static ComponentUpdater install(JComponent jComponent, long l, ActionListener actionListener) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, l, actionListener);
    }

    public static ComponentUpdater install(JComponent jComponent, String string, long l, ActionListener actionListener) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, string, l, actionListener);
    }

    public static ComponentUpdater install(JComponent jComponent, long l, long l2, ActionListener actionListener) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, l, l2, actionListener);
    }

    public static ComponentUpdater install(JComponent jComponent, String string, long l, long l2, ActionListener actionListener) {
        ComponentUpdater.uninstall(jComponent);
        return new ComponentUpdater(jComponent, string, l, l2, actionListener);
    }

    public static void uninstall(JComponent jComponent) {
        for (AncestorListener ancestorListener : jComponent.getAncestorListeners()) {
            if (!(ancestorListener instanceof ComponentUpdater)) continue;
            jComponent.removeAncestorListener(ancestorListener);
        }
    }

    public static boolean isInstalled(JComponent jComponent) {
        for (AncestorListener ancestorListener : jComponent.getAncestorListeners()) {
            if (!(ancestorListener instanceof ComponentUpdater)) continue;
            return true;
        }
        return false;
    }
}

