/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.laf.table.WebTableStyle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class WebDefaultCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    public static final String COMBOBOX_CELL_EDITOR = "JComboBox.isTableCellEditor";
    protected JComponent editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = WebTableStyle.clickCountToStartEdit;

    public WebDefaultCellEditor(final JTextField jTextField) {
        this.editorComponent = jTextField;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object object) {
                jTextField.setText(object != null ? object.toString() : "");
            }

            @Override
            public Object getCellEditorValue() {
                return jTextField.getText();
            }
        };
        jTextField.addActionListener(this.delegate);
    }

    public WebDefaultCellEditor(final JCheckBox jCheckBox) {
        this.editorComponent = jCheckBox;
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object object) {
                boolean bl = false;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                } else if (object instanceof String) {
                    bl = object.equals("true");
                }
                jCheckBox.setSelected(bl);
            }

            @Override
            public Object getCellEditorValue() {
                return jCheckBox.isSelected();
            }
        };
        jCheckBox.addActionListener(this.delegate);
        jCheckBox.setRequestFocusEnabled(false);
    }

    public WebDefaultCellEditor(final JComboBox jComboBox) {
        this.editorComponent = jComboBox;
        if (jComboBox.getUI() instanceof WebComboBoxUI) {
            WebComboBoxUI webComboBoxUI = (WebComboBoxUI)jComboBox.getUI();
            webComboBoxUI.setDrawBorder(false);
        }
        jComboBox.putClientProperty(COMBOBOX_CELL_EDITOR, Boolean.TRUE);
        this.delegate = new EditorDelegate(){

            @Override
            public void setValue(Object object) {
                jComboBox.setSelectedItem(object);
            }

            @Override
            public Object getCellEditorValue() {
                return jComboBox.getSelectedItem();
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    return mouseEvent.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                if (jComboBox.isEditable()) {
                    jComboBox.actionPerformed(new ActionEvent(WebDefaultCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        jComboBox.addActionListener(this.delegate);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.delegate.isCellEditable(eventObject);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.delegate.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.delegate.setValue(string);
        return this.editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.delegate.setValue(object);
        return this.editorComponent;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener,
    Serializable {
        protected Object value;

        protected EditorDelegate() {
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= WebDefaultCellEditor.this.clickCountToStart;
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean startCellEditing(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            WebDefaultCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            WebDefaultCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WebDefaultCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            WebDefaultCellEditor.this.stopCellEditing();
        }
    }
}

