/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class WindowFollowListener
extends ComponentAdapter {
    private boolean enabled = true;
    private Window followingWindow;
    private Window parentWindow;
    private Point ll;

    public static void install(Window window, Window window2) {
        window2.addComponentListener(new WindowFollowListener(window, window2));
    }

    public WindowFollowListener(Window window, Window window2) {
        this.followingWindow = window;
        this.parentWindow = window2;
        this.ll = window2.getLocation();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Window getFollowingWindow() {
        return this.followingWindow;
    }

    public void setFollowingWindow(Window window) {
        this.followingWindow = window;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Window window) {
        this.parentWindow = window;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.ll = this.parentWindow.getLocation();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.enabled && this.followingWindow != null && this.parentWindow != null) {
            Point point = this.parentWindow.getLocation();
            Point point2 = this.followingWindow.getLocation();
            this.followingWindow.setLocation(point2.x + point.x - this.ll.x, point2.y + point.y - this.ll.y);
            this.ll = point;
        }
    }
}

