/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.xml.XMLChar;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StringMapConverter
extends ReflectionConverter {
    public StringMapConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class clazz) {
        return clazz.equals(HashMap.class) || clazz.equals(Hashtable.class) || clazz.equals(LinkedHashMap.class) || clazz.equals(ConcurrentHashMap.class);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (XMLChar.isValidName(string)) {
                hierarchicalStreamWriter.startNode(string);
            } else {
                hierarchicalStreamWriter.startNode("entry");
                hierarchicalStreamWriter.addAttribute("key", string);
            }
            hierarchicalStreamWriter.addAttribute("type", this.mapper.serializedClass(v.getClass()));
            marshallingContext.convertAnother(v);
            hierarchicalStreamWriter.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            String string = hierarchicalStreamReader.getAttribute("key");
            String string2 = string != null ? string : hierarchicalStreamReader.getNodeName();
            Class clazz = this.mapper.realClass(hierarchicalStreamReader.getAttribute("type"));
            hashMap.put(string2, unmarshallingContext.convertAnother(hashMap, clazz));
            hierarchicalStreamReader.moveUp();
        }
        return hashMap;
    }
}

