/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij;

import dnl.confij.ConfigException;
import dnl.confij.Configuration;
import dnl.confij.ConfigurationSource;
import java.io.File;

public abstract class BaseConfigurationSource
implements ConfigurationSource {
    private long lastLoadTimeMillis;
    private long lastSaveTimeMillis;
    private File configFile;

    public BaseConfigurationSource(File configFile) {
        this.configFile = configFile;
    }

    protected abstract void loadConfigurationImpl(Configuration var1) throws ConfigException;

    protected abstract void saveConfigurationImpl(Configuration var1) throws ConfigException;

    public File getConfigFile() {
        return this.configFile;
    }

    public void loadConfiguration(Configuration config) throws ConfigException {
        this.lastLoadTimeMillis = System.currentTimeMillis();
        this.loadConfigurationImpl(config);
    }

    public void saveConfiguration(Configuration config) throws ConfigException {
        this.lastSaveTimeMillis = System.currentTimeMillis();
        this.saveConfigurationImpl(config);
    }

    public long getLastLoadTimeMillis() {
        return this.lastLoadTimeMillis;
    }

    public void setLastLoadTimeMillis(long lastLoadTimeMillis) {
        this.lastLoadTimeMillis = lastLoadTimeMillis;
    }

    public long getLastSaveTimeMillis() {
        return this.lastSaveTimeMillis;
    }

    public void setLastSaveTimeMillis(long lastSaveTimeMillis) {
        this.lastSaveTimeMillis = lastSaveTimeMillis;
    }
}

