/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij;

import dnl.confij.ConfigException;
import dnl.confij.Configuration;
import dnl.confij.ini.IniConfiguration;
import dnl.confij.props.PropertiesConfiguration;
import dnl.logging.LightLog;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ConfigLoader {
    public static Configuration getConfiguration(String appName, String configFileName) throws ConfigException {
        return ConfigLoader.getConfiguration(appName, configFileName, null);
    }

    public static Configuration getConfiguration(String appName, String configFileName, String charset) throws ConfigException {
        File confFile = ConfigLoader.getConfigFile(appName, configFileName, true);
        if (configFileName.endsWith(".properties")) {
            return charset == null ? new PropertiesConfiguration(confFile) : new PropertiesConfiguration(confFile, charset);
        }
        if (confFile.getName().endsWith(".ini")) {
            return new IniConfiguration(confFile);
        }
        throw new UnsupportedOperationException();
    }

    public static File getConfigFile(String appName, String configFileName) {
        return ConfigLoader.getConfigFile(appName, configFileName, false);
    }

    public static File getConfigFile(String appName, String configFileName, boolean create) {
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            if (create) {
                return ConfigLoader.createConfiguration(appName, configFileName);
            }
            return null;
        }
        return configFile;
    }

    public static File getConfigDir(String appName, boolean create) {
        File dir;
        File configFilesDir = null;
        if (create) {
            configFilesDir = ConfigLoader.forceConfDirCreation(appName);
        }
        if (!(dir = ConfigLoader.getConfigFilesDir(appName)).exists()) {
            configFilesDir = new File(".");
        }
        return configFilesDir;
    }

    private static File getHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    private static File getConfigFilesDir(String appName) {
        return new File(ConfigLoader.getHomeDir(), "." + appName);
    }

    public static File createConfiguration(String appName, String configFileName) {
        File configFilesDir = ConfigLoader.forceConfDirCreation(appName);
        File configFile = new File(configFilesDir, configFileName);
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                LightLog.info((String)("Created file " + configFile));
                return configFile;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return configFile;
    }

    private static File forceConfDirCreation(String appName) {
        File configFilesDir = ConfigLoader.getConfigFilesDir(appName);
        if (!configFilesDir.exists()) {
            try {
                FileUtils.forceMkdir((File)configFilesDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return configFilesDir;
    }
}

