/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij.reflected;

import ajul.reflect.Accessors;
import ajul.reflect.Beans;
import ajul.reflect.Fields;
import ajul.reflect.PropertyAccessException;
import dnl.confij.ConfigException;
import dnl.confij.ConfigParam;
import dnl.confij.ConfigSection;
import dnl.confij.Configuration;
import dnl.confij.ConvertersRegistry;
import dnl.confij.ValueConverter;
import dnl.logging.LightLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ReflectedConfiguration {
    private Configuration configuration;
    private Map<String, Object> registeredObjects = new HashMap<String, Object>();

    public ReflectedConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.loadConfiguration();
    }

    public void registerObject(String sectionName, Object regObj) {
        this.registeredObjects.put(sectionName, regObj);
        this.fillObject(sectionName, regObj);
    }

    public void unRegisterObject(String sectionName) {
        this.registeredObjects.remove(sectionName);
    }

    public void loadConfiguration() {
        for (Map.Entry<String, Object> entry : this.registeredObjects.entrySet()) {
            this.fillObject(entry.getKey(), entry.getValue());
        }
    }

    public void saveConfiguration() throws ConfigException {
        for (Map.Entry<String, Object> entry : this.registeredObjects.entrySet()) {
            this.object2Section(entry.getKey(), entry.getValue());
        }
        this.configuration.saveConfiguration();
    }

    private void object2Section(String sectionName, Object regObj) {
        ConfigSection section = this.configuration.getSection(sectionName);
        if (section == null) {
            section = new ConfigSection(sectionName);
            this.configuration.addSection(section);
        }
        try {
            String[] propNames;
            for (String prop : propNames = Beans.getBeanProperties(regObj.getClass())) {
                Object value = Beans.getValue((Object)regObj, (String)prop);
                section.set(prop, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillObject(String sectionName, Object regObj) {
        ConfigSection sect = this.configuration.getSection(sectionName);
        if (sect == null) {
            return;
        }
        Collection<ConfigParam> configParameters = sect.getConfigParameters();
        for (ConfigParam configParam : configParameters) {
            String name = configParam.getName();
            String value = configParam.getValue();
            this.setValue(regObj, name, value);
        }
    }

    private void setValue(Object regObj, String fieldName, String value) {
        LightLog.info((String)("ReflectedConfiguration.setValue(fieldName=" + fieldName + ", value=" + value + ")"));
        Class type = Fields.getFieldType(regObj.getClass(), (String)fieldName);
        if (type == null) {
            return;
        }
        ValueConverter converter = ConvertersRegistry.getInstance().getConverter(type);
        Object val2set = value;
        if (converter != null) {
            val2set = converter.parse(value);
        }
        try {
            Accessors.setPropertyValue((Object)regObj, (String)fieldName, (Object)val2set);
        }
        catch (PropertyAccessException e) {
            e.printStackTrace();
        }
    }
}

