/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class RasterRangesUtils {
    private static final int[] subColMasks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Rectangle)o1).x - ((Rectangle)o2).x;
        }
    };

    public static boolean outputOccupiedRanges(Raster raster, RangesOutput out) {
        DataBuffer data;
        boolean hasAlpha;
        Rectangle bounds = raster.getBounds();
        SampleModel sampleModel = raster.getSampleModel();
        boolean bl = hasAlpha = sampleModel.getNumBands() == 4;
        if (raster.getParent() == null && bounds.x == 0 && bounds.y == 0 && (data = raster.getDataBuffer()).getNumBanks() == 1) {
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel packedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (packedSampleModel.getPixelBitStride() == 1) {
                    return RasterRangesUtils.outputOccupiedRangesOfBinaryPixels(((DataBufferByte)data).getData(), bounds.width, bounds.height, out);
                }
            } else if (sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getDataType() == 3) {
                return RasterRangesUtils.outputOccupiedRanges(((DataBufferInt)data).getData(), bounds.width, bounds.height, hasAlpha ? -16777216 : 0xFFFFFF, out);
            }
        }
        int[] pixels = raster.getPixels(0, 0, bounds.width, bounds.height, (int[])null);
        return RasterRangesUtils.outputOccupiedRanges(pixels, bounds.width, bounds.height, hasAlpha ? -16777216 : 0xFFFFFF, out);
    }

    public static boolean outputOccupiedRangesOfBinaryPixels(byte[] binaryBits, int w, int h, RangesOutput out) {
        HashSet rects = new HashSet();
        TreeSet<Rectangle> prevLine = Collections.EMPTY_SET;
        int scanlineBytes = binaryBits.length / h;
        int row = 0;
        while (row < h) {
            TreeSet<Rectangle> curLine = new TreeSet<Rectangle>(COMPARATOR);
            int rowOffsetBytes = row * scanlineBytes;
            int startCol = -1;
            int byteCol = 0;
            while (byteCol < scanlineBytes) {
                int firstByteCol = byteCol << 3;
                byte byteColBits = binaryBits[rowOffsetBytes + byteCol];
                if (byteColBits == 0) {
                    if (startCol >= 0) {
                        curLine.add(new Rectangle(startCol, row, firstByteCol - startCol, 1));
                        startCol = -1;
                    }
                } else if (byteColBits == 255) {
                    if (startCol < 0) {
                        startCol = firstByteCol;
                    }
                } else {
                    int subCol = 0;
                    while (subCol < 8) {
                        int col = firstByteCol | subCol;
                        if ((byteColBits & subColMasks[subCol]) != 0) {
                            if (startCol < 0) {
                                startCol = col;
                            }
                        } else if (startCol >= 0) {
                            curLine.add(new Rectangle(startCol, row, col - startCol, 1));
                            startCol = -1;
                        }
                        ++subCol;
                    }
                }
                ++byteCol;
            }
            if (startCol >= 0) {
                curLine.add(new Rectangle(startCol, row, w - startCol, 1));
            }
            Set unmerged = RasterRangesUtils.mergeRects(prevLine, curLine);
            rects.addAll(unmerged);
            prevLine = curLine;
            ++row;
        }
        rects.addAll(prevLine);
        for (Rectangle r : rects) {
            if (out.outputRange(r.x, r.y, r.width, r.height)) continue;
            return false;
        }
        return true;
    }

    public static boolean outputOccupiedRanges(int[] pixels, int w, int h, int occupationMask, RangesOutput out) {
        HashSet rects = new HashSet();
        TreeSet<Rectangle> prevLine = Collections.EMPTY_SET;
        int row = 0;
        while (row < h) {
            TreeSet<Rectangle> curLine = new TreeSet<Rectangle>(COMPARATOR);
            int idxOffset = row * w;
            int startCol = -1;
            int col = 0;
            while (col < w) {
                if ((pixels[idxOffset + col] & occupationMask) != 0) {
                    if (startCol < 0) {
                        startCol = col;
                    }
                } else if (startCol >= 0) {
                    curLine.add(new Rectangle(startCol, row, col - startCol, 1));
                    startCol = -1;
                }
                ++col;
            }
            if (startCol >= 0) {
                curLine.add(new Rectangle(startCol, row, w - startCol, 1));
            }
            Set unmerged = RasterRangesUtils.mergeRects(prevLine, curLine);
            rects.addAll(unmerged);
            prevLine = curLine;
            ++row;
        }
        rects.addAll(prevLine);
        for (Rectangle r : rects) {
            if (out.outputRange(r.x, r.y, r.width, r.height)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static Set mergeRects(Set prev, Set current) {
        block4: {
            unmerged = new HashSet<E>(prev);
            if (prev.isEmpty() || current.isEmpty()) break block4;
            pr = prev.toArray(new Rectangle[prev.size()]);
            cr = current.toArray(new Rectangle[current.size()]);
            ipr = 0;
            icr = 0;
            ** GOTO lbl20
            {
                if (++icr == cr.length) {
                    return unmerged;
                }
                do {
                    if (cr[icr].x < pr[ipr].x) continue block0;
                    if (cr[icr].x == pr[ipr].x && cr[icr].width == pr[ipr].width) {
                        unmerged.remove(pr[ipr]);
                        cr[icr].y = pr[ipr].y;
                        cr[icr].height = pr[ipr].height + 1;
                        ++icr;
                        continue;
                    }
                    ++ipr;
lbl20:
                    // 3 sources

                } while (ipr < pr.length && icr < cr.length);
            }
        }
        return unmerged;
    }

    public static interface RangesOutput {
        public boolean outputRange(int var1, int var2, int var3, int var4);
    }
}

