﻿Go
if exists (select * from sysobjects where id = OBJECT_ID('[Products]') and OBJECTPROPERTY(id, 'IsUserTable') = 1) 
	DROP TABLE [Products]
Go

CREATE TABLE [Products] (
ProductID        int IDENTITY (1, 1) NOT NULL,   -- 产品ID
ProductName      nvarchar(40) NOT NULL,          -- 产品名称
SupplierID       int NULL,                       -- 供应商ID
CategoryID       int NULL,                       -- 类别ID
QuantityPerUnit  nvarchar(20) NULL,              -- 数量单位
UnitPrice        money NULL,                     -- 单价
UnitsInStock     smallint NULL,                  -- 库存量
UnitsOnOrder     smallint NULL,                  -- 订购量
ReorderLevel     smallint NULL,                  -- 再订购量
Discontinued     bit NOT NULL                    -- 中止

CONSTRAINT [PK_Products] PRIMARY KEY CLUSTERED ([ProductID])
)
--添加表注释
exec sp_addextendedproperty N'MS_Description', N'产品', N'user', N'dbo', N'table', N'Products'

--添加列注释
exec sp_addextendedproperty N'MS_Description', N'产品ID', N'user', N'dbo', N'table', N'Products', N'column', N'ProductID'
exec sp_addextendedproperty N'MS_Description', N'产品名称', N'user', N'dbo', N'table', N'Products', N'column', N'ProductName'
exec sp_addextendedproperty N'MS_Description', N'供应商ID', N'user', N'dbo', N'table', N'Products', N'column', N'SupplierID'
exec sp_addextendedproperty N'MS_Description', N'类别ID', N'user', N'dbo', N'table', N'Products', N'column', N'CategoryID'
exec sp_addextendedproperty N'MS_Description', N'数量单位', N'user', N'dbo', N'table', N'Products', N'column', N'QuantityPerUnit'
exec sp_addextendedproperty N'MS_Description', N'单价', N'user', N'dbo', N'table', N'Products', N'column', N'UnitPrice'
exec sp_addextendedproperty N'MS_Description', N'库存量', N'user', N'dbo', N'table', N'Products', N'column', N'UnitsInStock'
exec sp_addextendedproperty N'MS_Description', N'订购量', N'user', N'dbo', N'table', N'Products', N'column', N'UnitsOnOrder'
exec sp_addextendedproperty N'MS_Description', N'再订购量', N'user', N'dbo', N'table', N'Products', N'column', N'ReorderLevel'
exec sp_addextendedproperty N'MS_Description', N'中止', N'user', N'dbo', N'table', N'Products', N'column', N'Discontinued'
