﻿    --创建表 Orders 的SQL语句
    CREATE TABLE Orders(
    		[OrderID] [int] IDENTITY (1, 1) NOT NULL,    --订单ID
		[CustomerID] [nchar](5) NULL,    --客户ID
		[EmployeeID] [int] NULL,    --雇员ID
		[OrderDate] [datetime] NULL,    --订购日期
		[RequiredDate] [datetime] NULL,    --发货日期
		[ShippedDate] [datetime] NULL,    --到货日期
		[ShipVia] [int] NULL,    --运货商ID
		[Freight] [money] NULL CONSTRAINT [DF_Orders_Freight] DEFAULT (0),    --运货费
		[ShipName] [nvarchar](40) NULL,    --运货商
		[ShipAddress] [nvarchar](60) NULL,    --货主地址
		[ShipCity] [nvarchar](15) NULL,    --货主城市
		[ShipRegion] [nvarchar](15) NULL,    --货主国家
		[ShipPostalCode] [nvarchar](10) NULL,    --货主邮政编码
		[ShipCountry] [nvarchar](15) NULL    --货主国家
		--key
        CONSTRAINT [PK_Orders] PRIMARY KEY CLUSTERED ([OrderID])
      
    )
   --添加表注释
  exec sp_addextendedproperty N'MS_Description', N'表格备注', N'user', N'dbo', N'table', N'Orders'

   --添加列注释
   
   exec sp_addextendedproperty N'MS_Description', N'订单ID', N'user', N'dbo', N'table', N'Orders', N'column', N'OrderID'
   exec sp_addextendedproperty N'MS_Description', N'客户ID', N'user', N'dbo', N'table', N'Orders', N'column', N'CustomerID'
   exec sp_addextendedproperty N'MS_Description', N'雇员ID', N'user', N'dbo', N'table', N'Orders', N'column', N'EmployeeID'
   exec sp_addextendedproperty N'MS_Description', N'订购日期', N'user', N'dbo', N'table', N'Orders', N'column', N'OrderDate'
   exec sp_addextendedproperty N'MS_Description', N'发货日期', N'user', N'dbo', N'table', N'Orders', N'column', N'RequiredDate'
   exec sp_addextendedproperty N'MS_Description', N'到货日期', N'user', N'dbo', N'table', N'Orders', N'column', N'ShippedDate'
   exec sp_addextendedproperty N'MS_Description', N'运货商ID', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipVia'
   exec sp_addextendedproperty N'MS_Description', N'运货费', N'user', N'dbo', N'table', N'Orders', N'column', N'Freight'
   exec sp_addextendedproperty N'MS_Description', N'运货商', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipName'
   exec sp_addextendedproperty N'MS_Description', N'货主地址', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipAddress'
   exec sp_addextendedproperty N'MS_Description', N'货主城市', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipCity'
   exec sp_addextendedproperty N'MS_Description', N'货主国家', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipRegion'
   exec sp_addextendedproperty N'MS_Description', N'货主邮政编码', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipPostalCode'
   exec sp_addextendedproperty N'MS_Description', N'货主国家', N'user', N'dbo', N'table', N'Orders', N'column', N'ShipCountry'