﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:variable name="YourNameSpace" select="'命名空间'"/>
  <xsl:variable name="YourTableName" select="'表格名称'"/>
  <xsl:variable name="YourClassName" select="'表格类名'"/>
  <xsl:variable name="YourFieldFristKey" select="'主键字段名'"/>
  <xsl:variable name="YourFristKey" select="'主键属性名(主键属性名不同于主键字段名，前者有大小写之分，而后者没有)'"/>
  <xsl:variable name="YourDataTypeFristKey" select="'主键属性的数据类型(目标语言的数据类型如C#的int、string)'"/>
  <xsl:variable name="YourFieldFristTitle" select="'标题字段名(默认以第一个文本字段作为标题列和搜索列)'"/>
  <xsl:variable name="YourAuthor" select="'作者'"/>
  <xsl:variable name="YourCreatDate" select="'创建日期'"/>
  <xsl:template match="/"> 
  using System;
	using System.Data;
	using System.Xml;
  using System.Collections.Generic;
  using <xsl:value-of select="$YourNameSpace"/>.DAL;	
  namespace <xsl:copy-of select="$YourNameSpace"/>.BLL {

      /// &lt;summary&gt;
      /// （<xsl:copy-of select="$YourTableName"/>）
      /// &lt;/summary&gt;
      /// &lt;remarks&gt;
      /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
      /// &lt;para&gt;修改人、日期及内容:&lt;/para&gt;
      /// &lt;/remarks&gt;
      public class <xsl:copy-of select="$YourClassName"/>BLL{
        
        //获取程序集名称(不含后缀名),Web的Bin目录下的程序集
        static string path = System.Configuration.ConfigurationManager.AppSettings["<xsl:copy-of select="$YourNameSpace"/>.<xsl:copy-of select="$YourClassName"/>DAL"];
        
        /// &lt;summary&gt;
        /// 声明接口 
        /// &lt;/summary&gt;
        <xsl:copy-of select="$YourNameSpace"/>.DAL.<xsl:copy-of select="$YourClassName"/>DAL dal;
        public <xsl:copy-of select="$YourClassName"/>BLL() {
          dal = new  <xsl:copy-of select="$YourNameSpace"/>.DAL.<xsl:copy-of select="$YourClassName"/>DAL();//可由工厂模式生成
        }
        
        /// &lt;summary&gt;
        /// 返回DAL最后的底层异常信息    
        ///&lt;/summary&gt;
        /// <returns>异常信息</returns>
        public string GetLastError()
        {
          return dal.GetLastError();
        }

        #region 常规常用方法 查询数据 Exists()、GetModel()、GetList()、GetRecordCount()、GetPage()
        /// &lt;summary&gt;
        /// 是否存在该记录   
        ///&lt;/summary&gt;
        /// &lt;param name=<xsl:copy-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <returns>存在返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/> <xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
    public bool Exists(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>)
        {
          return dal.Exists(<xsl:copy-of select="$YourFristKey"/>);
        }

        /// &lt;summary&gt;
        /// 根据主键获取一个<xsl:copy-of select="$YourClassName"/>对象实体,可以指定属性
        /// &lt;/summary&gt;
        /// &lt;param name=<xsl:copy-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor" /><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public <xsl:copy-of select="$YourNameSpace"/>.Model.<xsl:copy-of select="$YourClassName"/> GetModel(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>)
        {
          return dal.GetModel(<xsl:copy-of select="$YourFristKey"/>);
        }

        /// &lt;summary&gt;
        /// 根据主键获取一个<xsl:copy-of select="$YourClassName"/>对象实体,可以指定属性
        /// &lt;/summary&gt;
        /// &lt;param name=<xsl:copy-of select="$YourFristKey"/>&gt;主键值&lt;/param&gt;
        /// <param name="Fields">要获取的属性名称,即字段名称，多个以逗号“,”分割，获取所有属性留空或者输入null或者“*”</param>
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public <xsl:copy-of select="$YourNameSpace"/>.Model.<xsl:copy-of select="$YourClassName"/> GetModel(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>, string Fields)
        {
          return dal.GetModel(<xsl:copy-of select="$YourFristKey"/>, Fields);
        }

        /// &lt;summary&gt;
        /// 获得数据列表
        /// &lt;/summary&gt;
        /// <param name="strWhere">查询条件</param>
        /// <returns>返回DataSet</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(string strWhere)
        {
          return dal.GetList(strWhere);
        }

        /// &lt;summary&gt;
        /// 获得前几行数据
        /// &lt;/summary&gt;
        /// <param name="Top">记录条数</param>
        /// <param name="fileds">查询字段集合，以逗号,隔开</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strOrder">排序方式</param>
        /// <returns>DataSet</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(int Top, string fileds, string strWhere, string strOrder)
        {
          return dal.GetList(Top, fileds, strWhere, strOrder);
        }

        /// &lt;summary&gt;
        /// 获取记录总数
        /// &lt;/summary&gt;
        /// <param name="strWhere">查询条件</param>
        /// <returns>记录总数</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int GetRecordCount(string strWhere)
        {
          return dal.GetRecordCount(strWhere);
        }

        /// &lt;summary&gt;
        /// 公用万能的获取分页记录的方法
        /// <para>使用前提:表必须有一个自动增长列ID,但不一定是主键</para>
        /// &lt;/summary&gt;
        /// <param name="TableName">表名</param>
        /// <param name="Fields">要查询的字段集合,查询所有设为空值或者null或者星号"*"</param>
        /// <param name="strWhere">查询的条件,无条件就设为空值或者null</param>
        /// <param name="PageSize">页面大小，每页显示数据行数</param>
        /// <param name="PageIndex">页码，从1开始，第一页是1</param>
        /// <param name="strOrderBy">排序字段，支持多个字段排序,不排序就设为空值或者null</param>
        /// <returns>返回DataSet或者null</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetPage(string Fields, string strWhere, int PageSize, int PageIndex, string strOrderBy)
        {
          return dal.GetPage(Fields, strWhere,  PageSize,  PageIndex, strOrderBy);
        }

        #endregion

        #region 常规常用方法 编辑数据  Insert()、Update()、Delete()、

        /// &lt;summary&gt;
        /// 添加一条新<xsl:copy-of select="$YourClassName"/>记录
        /// &lt;/summary&gt;
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回自动编号，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Insert(<xsl:copy-of select="$YourNameSpace"/>.Model.<xsl:copy-of select="$YourClassName"/> model)
        {
          return dal.Insert(model);
        }

        /// &lt;summary&gt;
        /// 更新一条新<xsl:copy-of select="$YourClassName"/>记录
        /// &lt;/summary&gt;
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回影响行数，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Update(<xsl:copy-of select="$YourNameSpace"/>.Model.<xsl:copy-of select="$YourClassName"/> model)
        {
          return dal.Update(model);
        }

        /// &lt;summary&gt;
        /// 删除一条或者多条<xsl:copy-of select="$YourClassName"/>记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// &lt;/summary&gt;
        /// <returns>删除成功返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Delete(<xsl:copy-of select="$YourDataTypeFristKey"/><xsl:text> </xsl:text><xsl:copy-of select="$YourFristKey"/>)
        {
          return dal.Delete(<xsl:copy-of select="$YourFristKey"/>);
        }

        /// &lt;summary&gt;
        /// 删除一条或者多条<xsl:copy-of select="$YourClassName"/>记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// &lt;/summary&gt;
        /// <param name="AccountIDs">待删除的主键</param>
        /// <returns>返回影响行数，如果等于0就说明删除数据失败了，大于0说明全部或者部分删除成功(因为不是事务操作)</returns>
        /// <remarks>
        /// 创建人及日期：<xsl:copy-of select="$YourAuthor"/><xsl:text> </xsl:text><xsl:copy-of select="$YourCreatDate"/>
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int Deletes(string AccountIDs)
        {
          return dal.Deletes(AccountIDs);
        }
        #endregion

        #region 你增加的新方法
        //
        //
        #endregion
      }
    }
  </xsl:template>
</xsl:stylesheet>