﻿if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Suppliers_Insert]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
    drop procedure [dbo].[Suppliers_Insert]
GO
------------------------------------
-- 功能描述：增加一条记录 
-- 所属表格：Suppliers[ ]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
DECLARE @SupplierID int -- 供应商ID
    SET @SupplierID = 
DECLARE @CompanyName nvarchar(40) -- 公司名称
    SET @CompanyName =  ' '
DECLARE @ContactName nvarchar(30) -- 联系人名称
    SET @ContactName =  ' '
DECLARE @ContactTitle nvarchar(30) -- 联系人职务
    SET @ContactTitle =  ' '
DECLARE @Address nvarchar(60) -- 地址
    SET @Address =  ' '
DECLARE @City nvarchar(15) -- 城市
    SET @City =  ' '
DECLARE @Region nvarchar(15) -- 地区
    SET @Region =  ' '
DECLARE @PostalCode nvarchar(10) -- 邮政编码
    SET @PostalCode =  ' '
DECLARE @Country nvarchar(15) -- 国家
    SET @Country =  ' '
DECLARE @Phone nvarchar(24) -- 电话
    SET @Phone =  ' '
DECLARE @Fax nvarchar(24) -- 传真
    SET @Fax =  ' '
DECLARE @HomePage ntext -- 主页
    SET @HomePage =  ' '
 -- 调用存储过程 
 exec [Suppliers_Insert] @SupplierID,@CompanyName,@ContactName,@ContactTitle,@Address,@City,@Region,@PostalCode,@Country,@Phone,@Fax,@HomePage
 */
------------------------------------
CREATE PROCEDURE [Suppliers_Insert] (
@SupplierID    int = NULL,            -- 供应商ID
@CompanyName   nvarchar(40) = NULL,   -- 公司名称
@ContactName   nvarchar(30) = NULL,   -- 联系人名称
@ContactTitle  nvarchar(30) = NULL,   -- 联系人职务
@Address       nvarchar(60) = NULL,   -- 地址
@City          nvarchar(15) = NULL,   -- 城市
@Region        nvarchar(15) = NULL,   -- 地区
@PostalCode    nvarchar(10) = NULL,   -- 邮政编码
@Country       nvarchar(15) = NULL,   -- 国家
@Phone         nvarchar(24) = NULL,   -- 电话
@Fax           nvarchar(24) = NULL,   -- 传真
@HomePage      ntext = NULL           -- 主页

)
AS
INSERT INTO Suppliers(
	[CompanyName],[ContactName],[ContactTitle],[Address],[City],[Region],[PostalCode],[Country],[Phone],[Fax],[HomePage]	 
)VALUES( 
	@CompanyName,@ContactName,@ContactTitle,@Address,@City,@Region,@PostalCode,@Country,@Phone,@Fax,@HomePage	
)
SELECT @ID = SCOPE_IDENTITY() -- 返回新加记录的唯一标识
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Suppliers_Edit]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Suppliers_Edit]
GO
------------------------------------
-- 功能描述：修改一条记录 
-- 所属表格：Suppliers[]
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /* -- 测试代码 --
 -- 参数设置 
DECLARE @SupplierID int -- 供应商ID
    SET @SupplierID = 
DECLARE @CompanyName nvarchar(40) -- 公司名称
    SET @CompanyName =  ' '
DECLARE @ContactName nvarchar(30) -- 联系人名称
    SET @ContactName =  ' '
DECLARE @ContactTitle nvarchar(30) -- 联系人职务
    SET @ContactTitle =  ' '
DECLARE @Address nvarchar(60) -- 地址
    SET @Address =  ' '
DECLARE @City nvarchar(15) -- 城市
    SET @City =  ' '
DECLARE @Region nvarchar(15) -- 地区
    SET @Region =  ' '
DECLARE @PostalCode nvarchar(10) -- 邮政编码
    SET @PostalCode =  ' '
DECLARE @Country nvarchar(15) -- 国家
    SET @Country =  ' '
DECLARE @Phone nvarchar(24) -- 电话
    SET @Phone =  ' '
DECLARE @Fax nvarchar(24) -- 传真
    SET @Fax =  ' '
DECLARE @HomePage ntext -- 主页
    SET @HomePage =  ' '
 -- 调用存储过程 
 exec [Suppliers_Edit] @SupplierID,@CompanyName,@ContactName,@ContactTitle,@Address,@City,@Region,@PostalCode,@Country,@Phone,@Fax,@HomePage 
 */
------------------------------------
CREATE PROCEDURE [Suppliers_Edit]
@SupplierID    int = NULL,            -- 供应商ID
@CompanyName   nvarchar(40) = NULL,   -- 公司名称
@ContactName   nvarchar(30) = NULL,   -- 联系人名称
@ContactTitle  nvarchar(30) = NULL,   -- 联系人职务
@Address       nvarchar(60) = NULL,   -- 地址
@City          nvarchar(15) = NULL,   -- 城市
@Region        nvarchar(15) = NULL,   -- 地区
@PostalCode    nvarchar(10) = NULL,   -- 邮政编码
@Country       nvarchar(15) = NULL,   -- 国家
@Phone         nvarchar(24) = NULL,   -- 电话
@Fax           nvarchar(24) = NULL,   -- 传真
@HomePage      ntext = NULL           -- 主页

AS 
UPDATE Suppliers SET 
	 [CompanyName] = @CompanyName, [ContactName] = @ContactName, [ContactTitle] = @ContactTitle, [Address] = @Address, [City] = @City, [Region] = @Region, [PostalCode] = @PostalCode, [Country] = @Country, [Phone] = @Phone, [Fax] = @Fax, [HomePage] = @HomePage
WHERE 
	 [SupplierID] = @SupplierID
GO


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Suppliers_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Suppliers_Delete]
GO
------------------------------------
-- 功能描述：删除一条记录 
-- 作者名称：
-- 创建日期：
-- 修改日期：
 /*
 -- 测试代码 --
 -- 参数设置 
 -- 调用存储过程 
DECLARE @ID int
    set @ID=0
 exec [Suppliers_Delete] @ID
 */
------------------------------------
CREATE PROCEDURE [Suppliers_Delete]
	@SupplierID int --待删除的主键
AS 
   
	    DELETE FROM [Suppliers]	    WHERE SupplierID = @SupplierID 
     
     
GO   
     


