﻿    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace KuGo.Web.Admin
{
    public partial class OrderDetailsForm : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null && Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                
                int id = Convert.ToInt32(strId);
                 
                ShowInfo(id);
              }else {
                this.OrderIDTextBox.Text = "0";//新建记录
              }
          }
      }
      /// <summary>
      /// 显示一条 数据，为了修改
      /// </summary>
      /// <param name="OrderID">主键</param>
      private void ShowInfo(int OrderID)
      {
          KuGo.Model.OrderDetails model = new KuGo.BLL.OrderDetailsBLL().GetModel(OrderID);
          if (model != null) {
          OrderIDTextBox.Text=model.OrderID.ToString();
        ProductIDTextBox.Text=model.ProductID.ToString();
        UnitPriceTextBox.Text=model.UnitPrice.ToString();
        QuantityTextBox.Text=model.Quantity.ToString();
        DiscountTextBox.Text=model.Discount.ToString();
                    
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// <summary>
      /// 保存一条 数据
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          KuGo.Model.OrderDetails model = new KuGo.Model.OrderDetails();
          //
        model.OrderID =(OrderIDTextBox.Text !="")? Convert.ToInt32(OrderIDTextBox.Text): 0;
        model.ProductID =(ProductIDTextBox.Text !="")? Convert.ToInt32(ProductIDTextBox.Text): 0;
        model.UnitPrice =(UnitPriceTextBox.Text !="")? Convert.ToInt32(UnitPriceTextBox.Text): 0;
        model.Quantity =(QuantityTextBox.Text !="")? Convert.ToInt32(QuantityTextBox.Text): 0;
        model.Discount =(DiscountTextBox.Text !="")? Convert.ToInt32(DiscountTextBox.Text): 0;
        
        string msginfo = "";
        KuGo.BLL.OrderDetailsBLL bll = new KuGo.BLL.OrderDetailsBLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" <script>alert('保存新增数据成功！');window.location.href='OrderDetailsForm.aspx?id=" + model.OrderID.ToString() + "';</script>");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("<script>alert('保存修改数据成功！');window.location.href='OrderDetailsForm.aspx?id=" + model.OrderID.ToString() + "';</script>");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("OrderDetailsList.aspx");
    }
  }
}
  