﻿  using System;
  using System.Data;
  using System.Xml;
  using System.Collections.Generic;
  using Kugo.DALFactory;
  using Kugo.IDAL;	
  namespace Kugo.BLL {

      /// <summary>
      /// （Shippers）
      /// </summary>
      /// <remarks>
      /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
      /// <para>修改人、日期及内容:</para>
      /// </remarks>
      public class ShippersBLL{
        
       //获取程序集名称(不含后缀名),Web的Bin目录下的程序集
       static string path = System.Configuration.ConfigurationManager.AppSettings["KugoDAL"];
        
        /// <summary>
        /// 声明接口 
        /// </summary>
        Kugo.IDAL.IShippers dal;
		
		   /// <summary>
       /// 构造函数
       /// </summary>
       public ShippersBLL() {          
		       //由工厂生成对象实例
		       dal = AbstractFactory.Create<Kugo.IDAL.IShippers>(path, path + ".ShippersDAL");
    }

    /// <summary>
        /// 返回DAL最后的底层异常信息    
        ///</summary>
        /// <returns>异常信息</returns>
        public string GetLastError()
        {
          return dal.GetLastError();
        }

        #region 常规常用方法 查询数据 Exists()、GetModel()、GetList()、GetRecordCount()、GetPage()
        /// <summary>
        /// 是否存在该记录   
        ///</summary>
        /// <param name=ShipperID>主键值</param>
        /// <returns>存在返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Exists(int ShipperID)
        {
          return dal.Exists(ShipperID);
        }

        /// <summary>
        /// 根据主键获取一个Shippers对象实体,可以指定属性
        /// </summary>
        /// <param name=ShipperID>主键值</param>
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public Kugo.Model.Shippers GetModel(int ShipperID)
        {
          return dal.GetModel(ShipperID);
        }

        /// <summary>
        /// 根据主键获取一个Shippers对象实体,可以指定属性
        /// </summary>
        /// <param name=ShipperID>主键值</param>
        /// <param name="Fields">要获取的属性名称,即字段名称，多个以逗号“,”分割，获取所有属性留空或者输入null或者“*”</param>
        /// <returns>返回对象实例或者null</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public Kugo.Model.Shippers GetModel(int ShipperID, string Fields)
        {
          return dal.GetModel(ShipperID, Fields);
        }

        /// <summary>
        /// 获得数据列表
        /// </summary>
        /// <param name="strWhere">查询条件</param>
        /// <returns>返回DataSet</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(string strWhere)
        {
          return dal.GetList(strWhere);
        }

        /// <summary>
        /// 获得前几行数据
        /// </summary>
        /// <param name="Top">记录条数</param>
        /// <param name="fileds">查询字段集合，以逗号,隔开</param>
        /// <param name="strWhere">查询条件</param>
        /// <param name="strOrder">排序方式</param>
        /// <returns>DataSet</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetList(int Top, string fileds, string strWhere, string strOrder)
        {
          return dal.GetList(Top, fileds, strWhere, strOrder);
        }

        /// <summary>
        /// 获取记录总数
        /// </summary>
        /// <param name="strWhere">查询条件</param>
        /// <returns>记录总数</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int GetRecordCount(string strWhere)
        {
          return dal.GetRecordCount(strWhere);
        }

        /// <summary>
        /// 公用万能的获取分页记录的方法
        /// <para>使用前提:表必须有一个自动增长列ID,但不一定是主键</para>
        /// </summary>
        /// <param name="TableName">表名</param>
        /// <param name="Fields">要查询的字段集合,查询所有设为空值或者null或者星号"*"</param>
        /// <param name="strWhere">查询的条件,无条件就设为空值或者null</param>
        /// <param name="PageSize">页面大小，每页显示数据行数</param>
        /// <param name="PageIndex">页码，从1开始，第一页是1</param>
        /// <param name="strOrderBy">排序字段，支持多个字段排序,不排序就设为空值或者null</param>
        /// <returns>返回DataSet或者null</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public DataSet GetPage(string Fields, string strWhere, int PageSize, int PageIndex, string strOrderBy)
        {
          return dal.GetPage(Fields, strWhere,  PageSize,  PageIndex, strOrderBy);
        }

        #endregion

        #region 常规常用方法 编辑数据  Insert()、Update()、Delete()、

        /// <summary>
        /// 添加一条新Shippers记录
        /// </summary>
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回自动编号，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Insert(Kugo.Model.Shippers model)
        {
          return dal.Insert(model);
        }

        /// <summary>
        /// 更新一条新Shippers记录
        /// </summary>
        /// <param name="model">待保存的对象实例</param>
        /// <returns>返回影响行数，如果不大于0就说明保存数据失败了</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Update(Kugo.Model.Shippers model)
        {
          return dal.Update(model);
        }

        /// <summary>
        /// 删除一条或者多条Shippers记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// </summary>
        /// <returns>删除成功返回True,否则返回False</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public bool Delete(int ShipperID)
        {
          return dal.Delete(ShipperID);
        }

        /// <summary>
        /// 删除一条或者多条Shippers记录
        /// <para>如果是删除多条记录，就以逗号分隔主键值</para>
        /// </summary>
        /// <param name="AccountIDs">待删除的主键</param>
        /// <returns>返回影响行数，如果等于0就说明删除数据失败了，大于0说明全部或者部分删除成功(因为不是事务操作)</returns>
        /// <remarks>
        /// 创建人及日期：zhaoshunlu@163.com 2014-03-29日 10:55:21
        /// <para>修改人、日期及内容:</para>
        /// </remarks>
        public int Deletes(string AccountIDs)
        {
          return dal.Deletes(AccountIDs);
        }
        #endregion

        #region 你增加的新方法
        //
        //
        #endregion
      }
    }
  