﻿    
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

namespace Kugo.Web.Admin
{
    public partial class EmployeesForm : Page
    {       
      protected void Page_Load(object sender, EventArgs e)
      {
          if (!Page.IsPostBack)
          {
              if (Request.Params["id"] != null && Request.Params["id"].Trim() != ""){
                string strId = Request.Params["id"];
                
                int id = Convert.ToInt32(strId);
                 
                ShowInfo(id);
              }else {
                this.EmployeeIDTextBox.Text = "0";//新建记录
              }
          }
      }
      /// <summary>
      /// 显示一条 数据，为了修改
      /// </summary>
      /// <param name="EmployeeID">主键</param>
      private void ShowInfo(int EmployeeID)
      {
          Kugo.Model.Employees model = new Kugo.BLL.EmployeesBLL().GetModel(EmployeeID);
          if (model != null) {
          EmployeeIDTextBox.Text=model.EmployeeID.ToString();
        LastNameTextBox.Text=model.LastName;
        FirstNameTextBox.Text=model.FirstName;
        TitleTextBox.Text=model.Title;
        TitleOfCourtesyTextBox.Text=model.TitleOfCourtesy;
        BirthDateTextBox.Text=model.BirthDate.ToString("yyyy-MM-dd HH:mm:ss");
        HireDateTextBox.Text=model.HireDate.ToString("yyyy-MM-dd HH:mm:ss");
        AddressTextBox.Text=model.Address;
        CityTextBox.Text=model.City;
        RegionTextBox.Text=model.Region;
        PostalCodeTextBox.Text=model.PostalCode;
        CountryTextBox.Text=model.Country;
        HomePhoneTextBox.Text=model.HomePhone;
        ExtensionTextBox.Text=model.Extension;
        PhotoTextBox.Text=model.Photo;
        NotesTextBox.Text=model.Notes;
        ReportsToTextBox.Text=model.ReportsTo.ToString();
        PhotoPathTextBox.Text=model.PhotoPath;
                    
          //设置操作状态
          AccessStateHidden.Value = "修改";
        }
      }

      /// <summary>
      /// 保存一条 数据
      /// </summary>
      /// <param name="sender"></param>
      /// <param name="e"></param>
      public void btnSave_Click(object sender, EventArgs e){
          string strErr = ""; 
          if (strErr != ""){
            //请在客户端验证
            return;
          }
          Kugo.Model.Employees model = new Kugo.Model.Employees();
          //
        model.EmployeeID =(EmployeeIDTextBox.Text !="")? Convert.ToInt32(EmployeeIDTextBox.Text): 0;
        model.LastName =LastNameTextBox.Text;
        model.FirstName =FirstNameTextBox.Text;
        model.Title =TitleTextBox.Text;
        model.TitleOfCourtesy =TitleOfCourtesyTextBox.Text;
        model.BirthDate =(BirthDateTextBox.Text !="")? Convert.ToDateTime(BirthDateTextBox.Text): System.DateTime.Now;
        model.HireDate =(HireDateTextBox.Text !="")? Convert.ToDateTime(HireDateTextBox.Text): System.DateTime.Now;
        model.Address =AddressTextBox.Text;
        model.City =CityTextBox.Text;
        model.Region =RegionTextBox.Text;
        model.PostalCode =PostalCodeTextBox.Text;
        model.Country =CountryTextBox.Text;
        model.HomePhone =HomePhoneTextBox.Text;
        model.Extension =ExtensionTextBox.Text;
        model.Photo =PhotoTextBox.Text;
        model.Notes =NotesTextBox.Text;
        model.ReportsTo =(ReportsToTextBox.Text !="")? Convert.ToInt32(ReportsToTextBox.Text): 0;
        model.PhotoPath =PhotoPathTextBox.Text;
        
        string msginfo = "";
        Kugo.BLL.EmployeesBLL bll = new Kugo.BLL.EmployeesBLL();
       
        if (AccessStateHidden.Value != "修改"){        
            if (bll.Insert(model)){
              Response.Write(" <script>alert('保存新增数据成功！');window.location.href='EmployeesForm.aspx?id=" + model.EmployeeID.ToString() + "';</script>");
            }else
              msginfo = bll.GetLastError();
        }else{
            if (bll.Update(model)){
              Response.Write("<script>alert('保存修改数据成功！');window.location.href='EmployeesForm.aspx?id=" + model.EmployeeID.ToString() + "';</script>");
        }else{
            msginfo = bll.GetLastError();
        }
        if (msginfo != ""){
          Response.Write("<script>alert('保存失败！');</script>");//
          Response.Write("<script>alert('原因：" + msginfo + "！');</script>");//
        }
      }
    }
    
    public void btnCancle_Click(object sender, EventArgs e){
      Response.Redirect("EmployeesList.aspx");
    }
  }
}
  