/*
 * Decompiled with CFR 0.152.
 */
package com.mnglpad;

import com.mnglpad.MongolPad;
import com.mongol.encode.MongolianFontUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
implements ActionListener,
ListSelectionListener {
    static JFrame window = new JFrame("Font Chooser");
    MongolPad samp;
    JLabel flist_label;
    JLabel fsize_label;
    JLabel fstyle_label;
    JLabel fprev_label;
    JLabel preview;
    JList flist;
    JList fsize;
    JList fstyle;
    ScrollPane flist_sc;
    ScrollPane fstyle_sc;
    ScrollPane fsize_sc;
    JButton ok;
    JButton cancel;
    GraphicsEnvironment ge;
    String[] font_names;
    Font sample;
    String font_name;
    int font_size;
    int font_style;

    public FontChooser(MongolPad ref) {
        this.samp = ref;
        window.setLayout(null);
        MongolianFontUtil.init();
        this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.font_names = this.ge.getAvailableFontFamilyNames();
        this.flist = new JList<String>(this.font_names);
        this.flist.setSelectionMode(0);
        this.flist_label = new JLabel("Font: ");
        window.add(this.flist_label);
        this.flist_label.setBounds(10, 10, 120, 20);
        this.flist_sc = new ScrollPane();
        this.flist_sc.add(this.flist);
        this.flist_sc.setBounds(10, 30, 120, 200);
        window.add(this.flist_sc);
        this.flist.addListSelectionListener(this);
        String[] styles = new String[]{"Regular", "Bold", "Italic", "Bold Italic"};
        this.fstyle = new JList<String>(styles);
        this.fstyle.setSelectionMode(0);
        this.fstyle_label = new JLabel("Style: ");
        window.add(this.fstyle_label);
        this.fstyle_label.setBounds(140, 10, 80, 20);
        this.fstyle_sc = new ScrollPane();
        this.fstyle_sc.add(this.fstyle);
        this.fstyle_sc.setBounds(140, 30, 80, 70);
        window.add(this.fstyle_sc);
        this.fstyle.addListSelectionListener(this);
        Vector<String> a = new Vector<String>(40, 1);
        int i = 8;
        while (i <= 100) {
            a.addElement(String.valueOf(i));
            i += 2;
        }
        this.fsize = new JList(a);
        this.fsize.setSelectionMode(0);
        this.fsize_label = new JLabel("Size: ");
        this.fsize_label.setBounds(140, 110, 80, 20);
        window.add(this.fsize_label);
        this.fsize_sc = new ScrollPane();
        this.fsize_sc.add(this.fsize);
        this.fsize_sc.setBounds(140, 130, 80, 100);
        window.add(this.fsize_sc);
        this.fsize.addListSelectionListener(this);
        this.ok = new JButton("OK");
        this.ok.setBounds(230, 30, 75, 20);
        this.ok.addActionListener(this);
        window.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.setBounds(230, 50, 75, 20);
        this.cancel.addActionListener(this);
        window.add(this.cancel);
        this.fprev_label = new JLabel("Preview: ");
        this.fprev_label.setBounds(10, 230, 300, 20);
        window.add(this.fprev_label);
        this.preview = new JLabel("Sample Text");
        this.preview.setBounds(10, 250, 290, 85);
        this.preview.setHorizontalAlignment(0);
        this.preview.setOpaque(true);
        this.preview.setBackground(Color.white);
        this.preview.setBorder(new LineBorder(Color.black, 1));
        window.add(this.preview);
        int w = 320;
        int h = 380;
        window.setSize(w, h);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        window.setLocation(center.x - w / 2, center.y - h / 2 + 25);
        window.setDefaultCloseOperation(1);
        window.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.ok();
        } else if (e.getSource() == this.cancel) {
            this.cancel();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent l) {
        if (l.getSource() == this.flist) {
            this.preview.setText(this.flist.getSelectedValue().toString());
            this.changeFontSample();
        } else if (l.getSource() == this.fsize) {
            this.changeFontSample();
        } else if (l.getSource() == this.fstyle) {
            this.changeFontSample();
        }
    }

    private void changeFontSample() {
        try {
            this.font_name = this.flist.getSelectedValue().toString();
        }
        catch (NullPointerException npe) {
            this.font_name = "Verdana";
        }
        try {
            this.font_style = this.getStyle();
        }
        catch (NullPointerException npe) {
            this.font_style = 0;
        }
        try {
            this.font_size = Integer.parseInt(this.fsize.getSelectedValue().toString());
        }
        catch (NullPointerException npe) {
            this.font_size = 18;
        }
        this.sample = new Font(this.font_name, this.font_style, this.font_size);
        this.preview.setFont(this.sample);
    }

    private int getStyle() {
        if (this.fstyle.getSelectedValue().toString().equals("Bold")) {
            return 1;
        }
        if (this.fstyle.getSelectedValue().toString().equals("Italic")) {
            return 2;
        }
        if (this.fstyle.getSelectedValue().toString().equals("Bold Italic")) {
            return 3;
        }
        return 0;
    }

    private void ok() {
        try {
            this.samp.editor.setFont(this.sample);
            this.samp.editor_resize();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        window.setVisible(false);
    }

    private void cancel() {
        window.setVisible(false);
    }
}

