/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.encode;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class ZHConverter {
    private Properties charMap;
    private Set conflictingSets;
    public static final int TRADITIONAL = 0;
    public static final int SIMPLIFIED = 1;
    private static final int NUM_OF_CONVERTERS = 2;
    private static final ZHConverter[] converters = new ZHConverter[2];
    private static final String[] propertyFiles = new String[2];

    static {
        ZHConverter.propertyFiles[0] = "resources/zh2Hant.properties";
        ZHConverter.propertyFiles[1] = "resources/zh2Hans.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZHConverter getInstance(int converterType) {
        if (converterType < 0 || converterType >= 2) return null;
        if (converters[converterType] != null) return converters[converterType];
        Class<ZHConverter> clazz = ZHConverter.class;
        synchronized (ZHConverter.class) {
            if (converters[converterType] != null) return converters[converterType];
            ZHConverter.converters[converterType] = new ZHConverter(propertyFiles[converterType]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return converters[converterType];
        }
    }

    public static String convert(String text, int converterType) {
        ZHConverter instance = ZHConverter.getInstance(converterType);
        return instance.convert(text);
    }

    private ZHConverter(String propertyFile) {
        block22: {
            this.charMap = new Properties();
            this.conflictingSets = new HashSet();
            InputStream is = null;
            is = this.getClass().getResourceAsStream(propertyFile);
            if (is != null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(is));
                    this.charMap.load(reader);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.initializeHelper();
    }

    private void initializeHelper() {
        HashMap<String, Integer> stringPossibilities = new HashMap<String, Integer>();
        for (String string : this.charMap.keySet()) {
            if (string.length() < 1) continue;
            int i = 0;
            while (i < string.length()) {
                String keySubstring = string.substring(0, i + 1);
                if (stringPossibilities.containsKey(keySubstring)) {
                    Integer integer = (Integer)stringPossibilities.get(keySubstring);
                    stringPossibilities.put(keySubstring, new Integer(integer + 1));
                } else {
                    stringPossibilities.put(keySubstring, new Integer(1));
                }
                ++i;
            }
        }
        for (String string : stringPossibilities.keySet()) {
            if ((Integer)stringPossibilities.get(string) <= 1) continue;
            this.conflictingSets.add(string);
        }
    }

    public String convert(String in) {
        StringBuilder outString = new StringBuilder();
        StringBuilder stackString = new StringBuilder();
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            String key = "" + c;
            stackString.append(key);
            if (!this.conflictingSets.contains(stackString.toString())) {
                if (this.charMap.containsKey(stackString.toString())) {
                    outString.append(this.charMap.get(stackString.toString()));
                    stackString.setLength(0);
                } else {
                    CharSequence sequence = stackString.subSequence(0, stackString.length() - 1);
                    stackString.delete(0, stackString.length() - 1);
                    this.flushStack(outString, new StringBuilder(sequence));
                }
            }
            ++i;
        }
        this.flushStack(outString, stackString);
        return outString.toString();
    }

    private void flushStack(StringBuilder outString, StringBuilder stackString) {
        while (stackString.length() > 0) {
            if (this.charMap.containsKey(stackString.toString())) {
                outString.append(this.charMap.get(stackString.toString()));
                stackString.setLength(0);
                continue;
            }
            outString.append("" + stackString.charAt(0));
            stackString.delete(0, 1);
        }
    }

    String parseOneChar(String c) {
        if (this.charMap.containsKey(c)) {
            return (String)this.charMap.get(c);
        }
        return c;
    }
}

