/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing;

import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.text.MStyledEditorKit;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.plaf.TextUI;
import javax.swing.text.EditorKit;

public class MEditorPane
extends JEditorPane
implements MRotation {
    public MEditorPane() {
        this.setEditorKit(new MStyledEditorKit());
    }

    public MEditorPane(int direction, int hint) {
        MStyledEditorKit editorKit = new MStyledEditorKit();
        editorKit.setRotateDirection(direction);
        editorKit.setRotateHint(hint);
        this.setEditorKit(editorKit);
    }

    public MEditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.setEditorKit(new MStyledEditorKit());
    }

    public MEditorPane(String url) throws IOException {
        super(url);
        this.setEditorKit(new MStyledEditorKit());
    }

    public MEditorPane(String type, String text) {
        super(type, text);
        this.setEditorKit(new MStyledEditorKit());
    }

    @Override
    public void setRotateHint(int hint) {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof MStyledEditorKit) {
            ((MStyledEditorKit)editorKit).setRotateHint(hint);
            this.setEditorKit(editorKit);
        }
    }

    @Override
    public int getRotateHint() {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof MStyledEditorKit) {
            return ((MStyledEditorKit)editorKit).getRotateHint();
        }
        return 0;
    }

    @Override
    public void setRotateDirection(int direction) {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof MStyledEditorKit) {
            ((MStyledEditorKit)editorKit).setRotateDirection(direction);
            this.setEditorKit(editorKit);
        }
    }

    @Override
    public int getRotateDirection() {
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof MStyledEditorKit) {
            return ((MStyledEditorKit)editorKit).getRotateDirection();
        }
        return 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getParent() instanceof JViewport) {
            Dimension min;
            JViewport port = (JViewport)this.getParent();
            TextUI ui = this.getUI();
            int prefWidth = d.width;
            int prefHeight = d.height;
            if (!this.getScrollableTracksViewportWidth()) {
                int w = port.getWidth();
                min = ui.getMinimumSize(this);
                if (w != 0 && w < min.width) {
                    prefWidth = min.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                int h = port.getHeight();
                min = ui.getMinimumSize(this);
                if (h != 0 && h < min.height) {
                    prefHeight = min.height;
                }
            }
            if (prefWidth != d.width || prefHeight != d.height) {
                d = new Dimension(prefWidth, prefHeight);
            }
        }
        return d;
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        int dx = this.getX();
        int dy = this.getY();
        Container parent = this.getParent();
        while (parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane)) {
            Rectangle bounds = parent.getBounds();
            dx += bounds.x;
            dy += bounds.y;
            parent = parent.getParent();
        }
        if (parent != null && !(parent instanceof CellRendererPane)) {
            if (this.getRotateDirection() == 0) {
                aRect.x += dx;
                aRect.y += dy;
                ((JComponent)parent).scrollRectToVisible(aRect);
                aRect.x -= dx;
                aRect.y -= dy;
            } else if (this.getRotateHint() != 4) {
                aRect.x += dx - aRect.width / 2;
                aRect.y += dy;
                ((JComponent)parent).scrollRectToVisible(aRect);
                aRect.x -= dx - aRect.width / 2;
                aRect.y -= dy;
            } else {
                aRect.x += dx - aRect.width / 2;
                aRect.y += dy;
                ((JComponent)parent).scrollRectToVisible(aRect);
                aRect.x -= dx - aRect.width / 2;
                aRect.y -= dy;
            }
        }
    }
}

