/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing;

import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;

public class MSwingRotateUtilities {
    public String[] fCharStrings;
    public int[] fCharWidths;
    public int[] fPosition;
    public int fWidth;
    public int fHeight;
    public int fCharHeight;
    public int fDescent;
    static final int POSITION_NORMAL = 0;
    static final int POSITION_TOP_RIGHT = 1;
    static final int POSITION_FAR_TOP_RIGHT = 2;
    public static final int ROTATE_HORIZANTAL = 0;
    public static final int ROTATE_VERTICAL = 1;
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFTTORIGHT = 2;
    public static final int ROTATE_RIGHTTOLEFT = 4;
    static final String sDrawsInTopRight = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    static final String sDrawsInFarTopRight = "\u3001\u3002";
    static final int DEFAULT_CJK = 1;
    static final int LEGAL_ROMAN = 7;
    static final int DEFAULT_ROMAN = 4;
    static final int LEGAL_MUST_ROTATE = 6;
    static final int DEFAULT_MUST_ROTATE = 2;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int kBufferSpace = 5;

    public void calcDimensions(JComponent c, Graphics g, String text, int fRotation) {
        FontMetrics fm = c.getFontMetrics(c.getFont());
        this.fCharHeight = fm.getAscent() + fm.getDescent();
        this.fDescent = fm.getDescent();
        if (fRotation == 1) {
            int len = text.length();
            char[] data = new char[len];
            text.getChars(0, len, data, 0);
            this.fWidth = 0;
            this.fCharStrings = new String[len];
            this.fCharWidths = new int[len];
            this.fPosition = new int[len];
            int i = 0;
            while (i < len) {
                char ch = data[i];
                this.fCharWidths[i] = fm.charWidth(ch);
                if (this.fCharWidths[i] > this.fWidth) {
                    this.fWidth = this.fCharWidths[i];
                }
                this.fCharStrings[i] = new String(data, i, 1);
                this.fPosition[i] = sDrawsInTopRight.indexOf(ch) >= 0 ? 1 : (sDrawsInFarTopRight.indexOf(ch) >= 0 ? 2 : 0);
                ++i;
            }
            this.fHeight = this.fCharHeight * len + this.fDescent;
        } else {
            this.fWidth = this.fCharHeight;
            this.fHeight = fm.stringWidth(text) + 10;
        }
    }

    public static int verifyRotation(String label, int rotateHint) {
        int legal;
        boolean hasCJK = false;
        boolean hasMustRotate = false;
        int len = label.length();
        char[] data = new char[len];
        label.getChars(0, len, data, 0);
        int i = 0;
        while (i < len) {
            char ch = data[i];
            if (ch >= '\u4e00' && ch <= '\u9fff' || ch >= '\u3400' && ch <= '\u4dff' || ch >= '\uf900' && ch <= '\ufaff' || ch >= '\u3040' && ch <= '\u309f' || ch >= '\u30a0' && ch <= '\u30ff') {
                hasCJK = true;
            }
            if (ch >= '\u0590' && ch <= '\u05ff' || ch >= '\u0600' && ch <= '\u06ff' || ch >= '\u0700' && ch <= '\u074f') {
                hasMustRotate = true;
            }
            ++i;
        }
        if (hasCJK) {
            return 1;
        }
        int n = legal = hasMustRotate ? 6 : 7;
        if ((rotateHint & legal) > 0) {
            return rotateHint;
        }
        return hasMustRotate ? 2 : 4;
    }
}

