/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing;

import com.mongol.swing.MSwingRotateUtilities;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.print.PrinterGraphics;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.font.FontDesignMetrics;
import sun.print.ProxyPrintGraphics;
import sun.swing.ImageIconUIResource;
import sun.swing.PrintColorUIResource;

public class MSwingUtilities {
    public static final Object LAF_STATE_KEY = new StringBuffer("LookAndFeel State");
    private static final int STRONG_BEARING_CACHE_SIZE = 10;
    private static BearingCacheEntry[] strongBearingCache = new BearingCacheEntry[10];
    private static int strongBearingCacheNextIndex = 0;
    private static Set<SoftReference<BearingCacheEntry>> softBearingCache = new HashSet<SoftReference<BearingCacheEntry>>();
    public static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    public static final Object AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextInfoPropertyKey");
    private static final StringBuilder SKIP_CLICK_COUNT = new StringBuilder("skipClickCount");
    public static final Object COMPONENT_UI_PROPERTY_KEY = new StringBuffer("ComponentUIPropertyKey");
    public static final Object BASICMENUITEMUI_MAX_TEXT_OFFSET = new StringBuilder("maxTextOffset");
    private static Field inputEvent_CanAccessSystemClipboard_Field = null;
    private static final String UntrustedClipboardAccess = "UNTRUSTED_CLIPBOARD_ACCESS_KEY";
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];

    public static final boolean isComplexLayout(char[] text, int start, int limit) {
        return true;
    }

    public static AATextInfo drawTextAntialiased(JComponent c) {
        if (c != null) {
            return (AATextInfo)c.getClientProperty(AA_TEXT_PROPERTY_KEY);
        }
        return null;
    }

    public static int getLeftSideBearing(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return MSwingUtilities.getLeftSideBearing(c, fm, string.charAt(0));
    }

    public static int getLeftSideBearing(JComponent c, FontMetrics fm, char firstChar) {
        return MSwingUtilities.getBearing(c, fm, firstChar, true);
    }

    public static int getRightSideBearing(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return MSwingUtilities.getRightSideBearing(c, fm, string.charAt(string.length() - 1));
    }

    public static int getRightSideBearing(JComponent c, FontMetrics fm, char lastChar) {
        return MSwingUtilities.getBearing(c, fm, lastChar, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getBearing(JComponent comp, FontMetrics fm, char c, boolean isLeftBearing) {
        if (fm == null) {
            if (comp == null) {
                return 0;
            }
            fm = comp.getFontMetrics(comp.getFont());
        }
        Class<MSwingUtilities> clazz = MSwingUtilities.class;
        synchronized (MSwingUtilities.class) {
            BearingCacheEntry entry = null;
            BearingCacheEntry searchKey = new BearingCacheEntry(fm);
            BearingCacheEntry[] bearingCacheEntryArray = strongBearingCache;
            int n = strongBearingCache.length;
            int n2 = 0;
            while (n2 < n) {
                BearingCacheEntry cacheEntry = bearingCacheEntryArray[n2];
                if (searchKey.equals(cacheEntry)) {
                    entry = cacheEntry;
                    break;
                }
                ++n2;
            }
            if (entry == null) {
                Iterator<SoftReference<BearingCacheEntry>> iter = softBearingCache.iterator();
                while (iter.hasNext()) {
                    BearingCacheEntry cacheEntry = iter.next().get();
                    if (cacheEntry == null) {
                        iter.remove();
                        continue;
                    }
                    if (!searchKey.equals(cacheEntry)) continue;
                    entry = cacheEntry;
                    MSwingUtilities.putEntryInStrongCache(entry);
                    break;
                }
            }
            if (entry == null) {
                entry = searchKey;
                MSwingUtilities.cacheEntry(entry);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return isLeftBearing ? entry.getLeftSideBearing(c) : entry.getRightSideBearing(c);
        }
    }

    private static synchronized void cacheEntry(BearingCacheEntry entry) {
        BearingCacheEntry oldestEntry = strongBearingCache[strongBearingCacheNextIndex];
        if (oldestEntry != null) {
            softBearingCache.add(new SoftReference<BearingCacheEntry>(oldestEntry));
        }
        MSwingUtilities.putEntryInStrongCache(entry);
    }

    private static synchronized void putEntryInStrongCache(BearingCacheEntry entry) {
        MSwingUtilities.strongBearingCache[MSwingUtilities.strongBearingCacheNextIndex] = entry;
        strongBearingCacheNextIndex = (strongBearingCacheNextIndex + 1) % 10;
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g) {
        return MSwingUtilities.getFontMetrics(c, g, g.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g, Font font) {
        if (c != null) {
            return c.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        return fm.stringWidth(string);
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        if (string == null || string.equals("")) {
            return "";
        }
        int textWidth = MSwingUtilities.stringWidth(c, fm, string);
        if (textWidth > availTextWidth) {
            return MSwingUtilities.clipString(c, fm, string, availTextWidth);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        String clipString = "...";
        int stringLength = string.length();
        availTextWidth -= MSwingUtilities.stringWidth(c, fm, clipString);
        boolean needsTextLayout = false;
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < stringLength) {
                charsBuffer = string.toCharArray();
            } else {
                string.getChars(0, stringLength, charsBuffer, 0);
            }
            needsTextLayout = MSwingUtilities.isComplexLayout(charsBuffer, 0, stringLength);
            if (!needsTextLayout) {
                int width = 0;
                int nChars = 0;
                while (nChars < stringLength) {
                    if ((width += fm.charWidth(charsBuffer[nChars])) > availTextWidth) {
                        string = string.substring(0, nChars);
                        break;
                    }
                    ++nChars;
                }
            }
        }
        if (needsTextLayout) {
            FontRenderContext frc = MSwingUtilities.getFontRenderContext(c, fm);
            AttributedString aString = new AttributedString(string);
            LineBreakMeasurer measurer = new LineBreakMeasurer(aString.getIterator(), frc);
            int nChars = measurer.nextOffset(availTextWidth);
            string = string.substring(0, nChars);
        }
        return String.valueOf(string) + clipString;
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        MSwingUtilities.drawString(c, g, text, x, y, 0, 0);
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y, int rotate_direction, int rotate_hint) {
        if (text == null || text.length() <= 0) {
            return;
        }
        Graphics2D g2d = MSwingUtilities.getGraphics2D(g);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform transform = g2d.getTransform();
        if (rotate_direction == 0 || rotate_hint == 0 || rotate_hint == 2 || rotate_hint == 4) {
            if (MSwingUtilities.isPrinting(g) && (g2d = MSwingUtilities.getGraphics2D(g)) != null) {
                float screenWidth = (float)g2d.getFont().getStringBounds(text, DEFAULT_FRC).getWidth();
                TextLayout layout = new TextLayout(text, g2d.getFont(), g2d.getFontRenderContext());
                layout = layout.getJustifiedLayout(screenWidth);
                Color col = g2d.getColor();
                if (col instanceof PrintColorUIResource) {
                    g2d.setColor(((PrintColorUIResource)col).getPrintColor());
                }
                layout.draw(g2d, x, y);
                g2d.setColor(col);
                return;
            }
            AATextInfo info = MSwingUtilities.drawTextAntialiased(c);
            if (info != null && g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Object oldContrast = null;
                Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                if (info.aaHint != oldAAValue) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, info.aaHint);
                } else {
                    oldAAValue = null;
                }
                if (info.lcdContrastHint != null) {
                    oldContrast = g2.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                    if (info.lcdContrastHint.equals(oldContrast)) {
                        oldContrast = null;
                    } else {
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, info.lcdContrastHint);
                    }
                }
                g.drawString(text, x, y);
                if (oldAAValue != null) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
                }
                if (oldContrast != null) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, oldContrast);
                }
            } else {
                g.drawString(text, x, y);
            }
        } else {
            g.setColor(c.getForeground());
            g.setFont(c.getFont());
            MSwingRotateUtilities rt = new MSwingRotateUtilities();
            rt.calcDimensions(c, g, text, rotate_hint);
            if (rotate_hint == 1) {
                ((Graphics2D)g).rotate(-1.5707963267948966);
                int xPos = -y;
                int yPos = x + rt.fCharHeight;
                int i = 0;
                while (i < rt.fCharStrings.length) {
                    switch (rt.fPosition[i]) {
                        case 0: {
                            g2d.drawString(rt.fCharStrings[i], xPos + (rt.fWidth - rt.fCharWidths[i]) / 2, yPos);
                            break;
                        }
                        case 1: {
                            int tweak = rt.fCharHeight / 3;
                            g2d.drawString(rt.fCharStrings[i], xPos + tweak / 2, yPos - tweak);
                            break;
                        }
                        case 2: {
                            int tweak = rt.fCharHeight - rt.fCharHeight / 3;
                            g2d.drawString(rt.fCharStrings[i], xPos + tweak / 2, yPos - tweak);
                        }
                    }
                    yPos += rt.fCharHeight;
                    ++i;
                }
            }
        }
        g2d.setTransform(transform);
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        MSwingUtilities.drawStringUnderlineCharAt(c, g, text, underlinedIndex, x, y, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y, int rotate_direction, int rotate_hint) {
        if (text == null || text.length() <= 0) {
            return;
        }
        MSwingUtilities.drawString(c, g, text, x, y, rotate_direction, rotate_hint);
        int textLength = text.length();
        if (underlinedIndex >= 0 && underlinedIndex < textLength) {
            int underlineRectY = y;
            int underlineRectHeight = 1;
            int underlineRectX = 0;
            int underlineRectWidth = 0;
            boolean isPrinting = MSwingUtilities.isPrinting(g);
            boolean needsTextLayout = isPrinting;
            if (!needsTextLayout) {
                Object object = charsBufferLock;
                synchronized (object) {
                    if (charsBuffer == null || charsBuffer.length < textLength) {
                        charsBuffer = text.toCharArray();
                    } else {
                        text.getChars(0, textLength, charsBuffer, 0);
                    }
                    needsTextLayout = MSwingUtilities.isComplexLayout(charsBuffer, 0, textLength);
                }
            }
            if (!needsTextLayout) {
                FontMetrics fm = g.getFontMetrics();
                underlineRectX = x + MSwingUtilities.stringWidth(c, fm, text.substring(0, underlinedIndex));
                underlineRectWidth = fm.charWidth(text.charAt(underlinedIndex));
            } else {
                Graphics2D g2d = MSwingUtilities.getGraphics2D(g);
                if (g2d != null) {
                    TextLayout layout = new TextLayout(text, g2d.getFont(), g2d.getFontRenderContext());
                    if (isPrinting) {
                        float screenWidth = (float)g2d.getFont().getStringBounds(text, DEFAULT_FRC).getWidth();
                        layout = layout.getJustifiedLayout(screenWidth);
                    }
                    TextHitInfo leading = TextHitInfo.leading(underlinedIndex);
                    TextHitInfo trailing = TextHitInfo.trailing(underlinedIndex);
                    Shape shape = layout.getVisualHighlightShape(leading, trailing);
                    Rectangle rect = shape.getBounds();
                    underlineRectX = x + rect.x;
                    underlineRectWidth = rect.width;
                }
            }
            g.fillRect(underlineRectX, underlineRectY + 1, underlineRectWidth, underlineRectHeight);
        }
    }

    public static int loc2IndexFileList(JList list, Point point) {
        Object bySize;
        int index = list.locationToIndex(point);
        if (index != -1 && (bySize = list.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)bySize).booleanValue() && !MSwingUtilities.pointIsInActualBounds(list, index, point)) {
            index = -1;
        }
        return index;
    }

    private static boolean pointIsInActualBounds(JList list, int index, Point point) {
        ListCellRenderer renderer = list.getCellRenderer();
        ListModel dataModel = list.getModel();
        Object value = dataModel.getElementAt(index);
        Component item = renderer.getListCellRendererComponent(list, value, index, false, false);
        Dimension itemSize = item.getPreferredSize();
        Rectangle cellBounds = list.getCellBounds(index, index);
        if (!item.getComponentOrientation().isLeftToRight()) {
            cellBounds.x += cellBounds.width - itemSize.width;
        }
        cellBounds.width = itemSize.width;
        return cellBounds.contains(point);
    }

    public static boolean pointOutsidePrefSize(JTable table, int row, int column, Point p) {
        if (table.convertColumnIndexToModel(column) != 0 || row == -1) {
            return true;
        }
        TableCellRenderer tcr = table.getCellRenderer(row, column);
        Object value = table.getValueAt(row, column);
        Component cell = tcr.getTableCellRendererComponent(table, value, false, false, row, column);
        Dimension itemSize = cell.getPreferredSize();
        Rectangle cellBounds = table.getCellRect(row, column, false);
        cellBounds.width = itemSize.width;
        cellBounds.height = itemSize.height;
        assert (p.x >= cellBounds.x && p.y >= cellBounds.y);
        return p.x > cellBounds.x + cellBounds.width || p.y > cellBounds.y + cellBounds.height;
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel model, int lead, int anchor) {
        if (anchor == -1) {
            anchor = lead;
        }
        if (lead == -1) {
            model.setAnchorSelectionIndex(-1);
            model.setLeadSelectionIndex(-1);
        } else {
            if (model.isSelectedIndex(lead)) {
                model.addSelectionInterval(lead, lead);
            } else {
                model.removeSelectionInterval(lead, lead);
            }
            model.setAnchorSelectionIndex(anchor);
        }
    }

    public static boolean shouldIgnore(MouseEvent me, JComponent c) {
        return c == null || !c.isEnabled() || !SwingUtilities.isLeftMouseButton(me) || me.isConsumed();
    }

    public static void adjustFocus(JComponent c) {
        if (!c.hasFocus() && c.isRequestFocusEnabled()) {
            c.requestFocus();
        }
    }

    public static int drawCharsWithFont(JComponent c, Graphics g, Font font, char[] data, int offset, int length, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(font);
        int nextX = MSwingUtilities.drawChars(c, g2, data, offset, length, x, y);
        g2.dispose();
        return nextX;
    }

    public static int drawChars(JComponent c, Graphics g, char[] data, int offset, int length, int x, int y) {
        AATextInfo info;
        if (length <= 0) {
            return x;
        }
        int nextX = x + MSwingUtilities.getFontMetrics(c, g).charsWidth(data, offset, length);
        if (MSwingUtilities.isPrinting(g)) {
            Graphics2D g2d = MSwingUtilities.getGraphics2D(g);
            Font font = g2d.getFont();
            if (g2d != null) {
                FontRenderContext deviceFontRenderContext = g2d.getFontRenderContext();
                FontRenderContext frc = MSwingUtilities.getFontRenderContext(c);
                if (frc != null && !MSwingUtilities.isFontRenderContextPrintCompatible(deviceFontRenderContext, frc)) {
                    TextLayout layout = new TextLayout(new String(data, offset, length), g2d.getFont(), deviceFontRenderContext);
                    float screenWidth = (float)g2d.getFont().getStringBounds(data, offset, offset + length, frc).getWidth();
                    layout = layout.getJustifiedLayout(screenWidth);
                    Color col = g2d.getColor();
                    if (col instanceof PrintColorUIResource) {
                        g2d.setColor(((PrintColorUIResource)col).getPrintColor());
                    }
                    layout.draw(g2d, x, y);
                    g2d.setColor(col);
                    return nextX;
                }
            }
        }
        if ((info = MSwingUtilities.drawTextAntialiased(c)) != null && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Object oldContrast = null;
            Object oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (info.aaHint != null && info.aaHint != oldAAValue) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, info.aaHint);
            } else {
                oldAAValue = null;
            }
            if (info.lcdContrastHint != null) {
                oldContrast = g2.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (info.lcdContrastHint.equals(oldContrast)) {
                    oldContrast = null;
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, info.lcdContrastHint);
                }
            }
            g.drawChars(data, offset, length, x, y);
            if (oldAAValue != null) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
            }
            if (oldContrast != null) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, oldContrast);
            }
        } else {
            g.drawChars(data, offset, length, x, y);
        }
        return nextX;
    }

    public static float drawString(JComponent c, Graphics g, AttributedCharacterIterator iterator, int x, int y) {
        float retVal;
        Graphics2D g2d;
        boolean isPrinting = MSwingUtilities.isPrinting(g);
        Color col = g.getColor();
        if (isPrinting && col instanceof PrintColorUIResource) {
            g.setColor(((PrintColorUIResource)col).getPrintColor());
        }
        if ((g2d = MSwingUtilities.getGraphics2D(g)) == null) {
            g.drawString(iterator, x, y);
            retVal = x;
        } else {
            FontRenderContext deviceFRC;
            FontRenderContext frc;
            if (isPrinting) {
                frc = MSwingUtilities.getFontRenderContext(c);
                if (frc.isAntiAliased() || frc.usesFractionalMetrics()) {
                    frc = new FontRenderContext(frc.getTransform(), false, false);
                }
            } else {
                frc = MSwingUtilities.getFRCProperty(c);
                if (frc == null) {
                    frc = g2d.getFontRenderContext();
                }
            }
            TextLayout layout = new TextLayout(iterator, frc);
            if (isPrinting && !MSwingUtilities.isFontRenderContextPrintCompatible(frc, deviceFRC = g2d.getFontRenderContext())) {
                float screenWidth = layout.getAdvance();
                layout = new TextLayout(iterator, deviceFRC);
                layout = layout.getJustifiedLayout(screenWidth);
            }
            layout.draw(g2d, x, y);
            retVal = layout.getAdvance();
        }
        if (isPrinting) {
            g.setColor(col);
        }
        return retVal;
    }

    private static boolean isFontRenderContextPrintCompatible(FontRenderContext frc1, FontRenderContext frc2) {
        if (frc1 == frc2) {
            return true;
        }
        if (frc1 == null || frc2 == null) {
            return false;
        }
        if (frc1.getFractionalMetricsHint() != frc2.getFractionalMetricsHint()) {
            return false;
        }
        if (!frc1.isTransformed() && !frc2.isTransformed()) {
            return true;
        }
        double[] mat1 = new double[4];
        double[] mat2 = new double[4];
        frc1.getTransform().getMatrix(mat1);
        frc2.getTransform().getMatrix(mat2);
        return mat1[0] == mat2[0] && mat1[1] == mat2[1] && mat1[2] == mat2[2] && mat1[3] == mat2[3];
    }

    public static Graphics2D getGraphics2D(Graphics g) {
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        if (g instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)g).getGraphics();
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component c) {
        assert (c != null);
        if (c == null) {
            return DEFAULT_FRC;
        }
        return c.getFontMetrics(c.getFont()).getFontRenderContext();
    }

    private static FontRenderContext getFontRenderContext(Component c, FontMetrics fm) {
        assert (fm != null || c != null);
        return fm != null ? fm.getFontRenderContext() : MSwingUtilities.getFontRenderContext(c);
    }

    public static FontMetrics getFontMetrics(JComponent c, Font font) {
        FontRenderContext frc = MSwingUtilities.getFRCProperty(c);
        if (frc == null) {
            frc = DEFAULT_FRC;
        }
        return FontDesignMetrics.getMetrics(font, frc);
    }

    private static FontRenderContext getFRCProperty(JComponent c) {
        AATextInfo info;
        if (c != null && (info = (AATextInfo)c.getClientProperty(AA_TEXT_PROPERTY_KEY)) != null) {
            return info.frc;
        }
        return null;
    }

    static boolean isPrinting(Graphics g) {
        return g instanceof PrinterGraphics || g instanceof PrintGraphics;
    }

    public static boolean useSelectedTextColor(Highlighter.Highlight h, JTextComponent c) {
        Highlighter.HighlightPainter painter = h.getPainter();
        String painterClass = painter.getClass().getName();
        if (painterClass.indexOf("javax.swing.text.DefaultHighlighter") != 0 && painterClass.indexOf("com.sun.java.swing.plaf.windows.WindowsTextUI") != 0) {
            return false;
        }
        try {
            DefaultHighlighter.DefaultHighlightPainter defPainter = (DefaultHighlighter.DefaultHighlightPainter)painter;
            return defPainter.getColor() == null || defPainter.getColor().equals(c.getSelectionColor());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static boolean canAccessSystemClipboard() {
        boolean canAccess = false;
        if (!GraphicsEnvironment.isHeadless()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                canAccess = true;
            } else {
                try {
                    sm.checkSystemClipboardAccess();
                    canAccess = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (canAccess && !MSwingUtilities.isTrustedContext()) {
                    canAccess = MSwingUtilities.canCurrentEventAccessSystemClipboard(true);
                }
            }
        }
        return canAccess;
    }

    public static boolean canCurrentEventAccessSystemClipboard() {
        return MSwingUtilities.isTrustedContext() || MSwingUtilities.canCurrentEventAccessSystemClipboard(false);
    }

    public static boolean canEventAccessSystemClipboard(AWTEvent e) {
        return MSwingUtilities.isTrustedContext() || MSwingUtilities.canEventAccessSystemClipboard(e, false);
    }

    private static synchronized boolean inputEvent_canAccessSystemClipboard(InputEvent ie) {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Field field = null;
                    try {
                        field = InputEvent.class.getDeclaredField("canAccessSystemClipboard");
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            return false;
        }
        boolean ret = false;
        try {
            ret = inputEvent_CanAccessSystemClipboard_Field.getBoolean(ie);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return ret;
    }

    private static boolean isAccessClipboardGesture(InputEvent ie) {
        boolean allowedGesture = false;
        if (ie instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)ie;
            int keyCode = ke.getKeyCode();
            int keyModifiers = ke.getModifiers();
            switch (keyCode) {
                case 67: 
                case 86: 
                case 88: {
                    allowedGesture = keyModifiers == 2;
                    break;
                }
                case 155: {
                    allowedGesture = keyModifiers == 2 || keyModifiers == 1;
                    break;
                }
                case 65485: 
                case 65487: 
                case 65489: {
                    allowedGesture = true;
                    break;
                }
                case 127: {
                    allowedGesture = keyModifiers == 1;
                }
            }
        }
        return allowedGesture;
    }

    private static boolean canEventAccessSystemClipboard(AWTEvent e, boolean checkGesture) {
        if (EventQueue.isDispatchThread()) {
            if (e instanceof InputEvent && (!checkGesture || MSwingUtilities.isAccessClipboardGesture((InputEvent)e))) {
                return MSwingUtilities.inputEvent_canAccessSystemClipboard((InputEvent)e);
            }
            return false;
        }
        return true;
    }

    private static boolean canCurrentEventAccessSystemClipboard(boolean checkGesture) {
        AWTEvent event = EventQueue.getCurrentEvent();
        return MSwingUtilities.canEventAccessSystemClipboard(event, checkGesture);
    }

    private static boolean isTrustedContext() {
        return System.getSecurityManager() == null || AppContext.getAppContext().get(UntrustedClipboardAccess) == null;
    }

    public static String displayPropertiesToCSS(Font font, Color fg) {
        StringBuffer rule = new StringBuffer("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        if (fg != null) {
            rule.append(" color: #");
            if (fg.getRed() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getRed()));
            if (fg.getGreen() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getGreen()));
            if (fg.getBlue() < 16) {
                rule.append('0');
            }
            rule.append(Integer.toHexString(fg.getBlue()));
            rule.append(" ; ");
        }
        rule.append(" }");
        return rule.toString();
    }

    public static Object makeIcon(final Class<?> baseClass, final Class<?> rootClass, final String imageFile) {
        return new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                byte[] buffer = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        InputStream resource;
                        block5: {
                            resource = null;
                            Class srchClass = baseClass;
                            while (srchClass != null) {
                                resource = srchClass.getResourceAsStream(imageFile);
                                if (resource != null || srchClass == rootClass) break;
                                srchClass = srchClass.getSuperclass();
                            }
                            if (resource != null) break block5;
                            return null;
                        }
                        try {
                            int n;
                            BufferedInputStream in = new BufferedInputStream(resource);
                            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                            byte[] buffer = new byte[1024];
                            while ((n = in.read(buffer)) > 0) {
                                out.write(buffer, 0, n);
                            }
                            in.close();
                            out.flush();
                            return out.toByteArray();
                        }
                        catch (IOException ioe) {
                            System.err.println(ioe.toString());
                            return null;
                        }
                    }
                });
                if (buffer == null) {
                    return null;
                }
                if (buffer.length == 0) {
                    System.err.println("warning: " + imageFile + " is zero-length");
                    return null;
                }
                return new ImageIconUIResource(buffer);
            }
        };
    }

    public static boolean isLocalDisplay() {
        try {
            String osname = System.getProperty("os.name");
            if (osname != null && osname.startsWith("Windows")) {
            }
            Class<?> x11Class = Class.forName("sun.awt.X11GraphicsEnvironment");
            Method isDisplayLocalMethod = x11Class.getMethod("isDisplayLocal", new Class[0]);
            return (Boolean)isDisplayLocalMethod.invoke(null, null);
        }
        finally {
            return true;
        }
    }

    public static int getUIDefaultsInt(Object key) {
        return MSwingUtilities.getUIDefaultsInt(key, 0);
    }

    public static int getUIDefaultsInt(Object key, Locale l) {
        return MSwingUtilities.getUIDefaultsInt(key, l, 0);
    }

    public static int getUIDefaultsInt(Object key, int defaultValue) {
        return MSwingUtilities.getUIDefaultsInt(key, null, defaultValue);
    }

    public static int getUIDefaultsInt(Object key, Locale l, int defaultValue) {
        Object value = UIManager.get(key, l);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            FocusTraversalPolicy policy2;
            Component comp2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp2 = (policy2 = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp2.requestFocus();
                return comp2;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null && (comp = (policy = rootAncestor.getFocusTraversalPolicy()).getComponentAfter(rootAncestor, container)) != null && SwingUtilities.isDescendingFrom(comp, container)) {
                comp.requestFocus();
                return comp;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        if (comp != null) {
            if (comp.isFocusTraversable()) {
                MSwingUtilities.compositeRequestFocus(comp);
                return true;
            }
            if (comp instanceof JComponent && ((JComponent)comp).requestDefaultFocus()) {
                return true;
            }
        }
        return false;
    }

    public static <V> Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<V> future = new FutureTask<V>(task);
        MSwingUtilities.execute(future);
        return future;
    }

    public static <V> Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<V> future = new FutureTask<V>(task, result);
        MSwingUtilities.execute(future);
        return future;
    }

    private static void execute(Runnable command) {
        SwingUtilities.invokeLater(command);
    }

    public static void setSkipClickCount(Component comp, int count) {
        if (comp instanceof JTextComponent && ((JTextComponent)comp).getCaret() instanceof DefaultCaret) {
            ((JTextComponent)comp).putClientProperty(SKIP_CLICK_COUNT, count);
        }
    }

    public static int getAdjustedClickCount(JTextComponent comp, MouseEvent e) {
        int cc = e.getClickCount();
        if (cc == 1) {
            comp.putClientProperty(SKIP_CLICK_COUNT, null);
        } else {
            Integer sub = (Integer)comp.getClientProperty(SKIP_CLICK_COUNT);
            if (sub != null) {
                return cc - sub;
            }
        }
        return cc;
    }

    private static Section liesIn(Rectangle rect, Point p, boolean horizontal, boolean ltr, boolean three) {
        boolean forward;
        int length;
        int pComp;
        int p0;
        if (horizontal) {
            p0 = rect.x;
            pComp = p.x;
            length = rect.width;
            forward = ltr;
        } else {
            p0 = rect.y;
            pComp = p.y;
            length = rect.height;
            forward = true;
        }
        if (three) {
            int boundary;
            int n = boundary = length >= 30 ? 10 : length / 3;
            if (pComp < p0 + boundary) {
                return forward ? Section.LEADING : Section.TRAILING;
            }
            if (pComp >= p0 + length - boundary) {
                return forward ? Section.TRAILING : Section.LEADING;
            }
            return Section.MIDDLE;
        }
        int middle = p0 + length / 2;
        if (forward) {
            return pComp >= middle ? Section.TRAILING : Section.LEADING;
        }
        return pComp < middle ? Section.TRAILING : Section.LEADING;
    }

    public static Section liesInHorizontal(Rectangle rect, Point p, boolean ltr, boolean three) {
        return MSwingUtilities.liesIn(rect, p, true, ltr, three);
    }

    public static Section liesInVertical(Rectangle rect, Point p, boolean three) {
        return MSwingUtilities.liesIn(rect, p, false, false, three);
    }

    public static class AATextInfo {
        Object aaHint;
        Integer lcdContrastHint;
        FontRenderContext frc;

        private static AATextInfo getAATextInfoFromMap(Map hints) {
            Object aaHint = hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object contHint = hints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
            if (aaHint == null || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                return null;
            }
            return new AATextInfo(aaHint, (Integer)contHint);
        }

        public static AATextInfo getAATextInfo(boolean lafCondition) {
            SunToolkit.setAAFontSettingsCondition(lafCondition);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Object map = tk.getDesktopProperty("awt.font.desktophints");
            if (map instanceof Map) {
                return AATextInfo.getAATextInfoFromMap((Map)map);
            }
            return null;
        }

        public AATextInfo(Object aaHint, Integer lcdContrastHint) {
            if (aaHint == null) {
                throw new InternalError("null not allowed here");
            }
            if (aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                throw new InternalError("AA must be on");
            }
            this.aaHint = aaHint;
            this.lcdContrastHint = lcdContrastHint;
            this.frc = new FontRenderContext(null, aaHint, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }

    private static class BearingCacheEntry {
        private FontMetrics fontMetrics;
        private Font font;
        private FontRenderContext frc;
        private Map<Character, Short> cache;
        private static final char[] oneChar = new char[1];

        public BearingCacheEntry(FontMetrics fontMetrics) {
            this.fontMetrics = fontMetrics;
            this.font = fontMetrics.getFont();
            this.frc = fontMetrics.getFontRenderContext();
            this.cache = new HashMap<Character, Short>();
            assert (this.font != null && this.frc != null);
        }

        public int getLeftSideBearing(char aChar) {
            Short bearing = this.cache.get(Character.valueOf(aChar));
            if (bearing == null) {
                bearing = this.calcBearing(aChar);
                this.cache.put(Character.valueOf(aChar), bearing);
            }
            return ((0xFF00 & bearing) >>> 8) - 127;
        }

        public int getRightSideBearing(char aChar) {
            Short bearing = this.cache.get(Character.valueOf(aChar));
            if (bearing == null) {
                bearing = this.calcBearing(aChar);
                this.cache.put(Character.valueOf(aChar), bearing);
            }
            return (0xFF & bearing) - 127;
        }

        private short calcBearing(char aChar) {
            Object aaHint;
            BearingCacheEntry.oneChar[0] = aChar;
            GlyphVector gv = this.font.createGlyphVector(this.frc, oneChar);
            Rectangle pixelBounds = gv.getGlyphPixelBounds(0, this.frc, 0.0f, 0.0f);
            int lsb = pixelBounds.x;
            int rsb = pixelBounds.width - this.fontMetrics.charWidth(aChar);
            if (lsb < 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                ++lsb;
            }
            if (rsb > 0 && ((aaHint = this.frc.getAntiAliasingHint()) == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR)) {
                --rsb;
            }
            if (lsb < -127 || lsb > 127) {
                lsb = 0;
            }
            if (rsb < -127 || rsb > 127) {
                rsb = 0;
            }
            int bearing = (lsb + 127 << 8) + (rsb + 127);
            return (short)bearing;
        }

        public boolean equals(Object entry) {
            if (entry == this) {
                return true;
            }
            if (!(entry instanceof BearingCacheEntry)) {
                return false;
            }
            BearingCacheEntry oEntry = (BearingCacheEntry)entry;
            return this.font.equals(oEntry.font) && this.frc.equals(oEntry.frc);
        }

        public int hashCode() {
            int result = 17;
            if (this.font != null) {
                result = 37 * result + this.font.hashCode();
            }
            if (this.frc != null) {
                result = 37 * result + this.frc.hashCode();
            }
            return result;
        }
    }

    public static enum Section {
        LEADING,
        MIDDLE,
        TRAILING;

    }
}

