/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing;

import com.mongol.swing.MEditorPane;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class MTextPane
extends MEditorPane {
    private static final String uiClassID = "TextPaneUI";

    public MTextPane() {
    }

    public MTextPane(int direction, int hint) {
        super(direction, hint);
    }

    public MTextPane(StyledDocument doc) {
        this();
        this.setStyledDocument(doc);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setStyledDocument(StyledDocument doc) {
        super.setDocument(doc);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    @Override
    public void replaceSelection(String content) {
        this.replaceSelection(content, true);
    }

    private void replaceSelection(String content, boolean checkEditable) {
        if (checkEditable && !this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        StyledDocument doc = this.getStyledDocument();
        if (doc != null) {
            try {
                Caret caret = this.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                AttributeSet attr = this.getInputAttributes().copyAttributes();
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)((Object)doc)).replace(p0, p1 - p0, content, attr);
                } else {
                    if (p0 != p1) {
                        doc.remove(p0, p1 - p0);
                    }
                    if (content != null && content.length() > 0) {
                        doc.insertString(p0, content, attr);
                    }
                }
            }
            catch (BadLocationException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
            this.repaint();
        }
    }

    public void insertComponent(Component c) {
        MutableAttributeSet inputAttributes = this.getInputAttributes();
        inputAttributes.removeAttributes(inputAttributes);
        StyleConstants.setComponent(inputAttributes, c);
        this.replaceSelection(" ", false);
        inputAttributes.removeAttributes(inputAttributes);
    }

    public void insertIcon(Icon g) {
        MutableAttributeSet inputAttributes = this.getInputAttributes();
        inputAttributes.removeAttributes(inputAttributes);
        StyleConstants.setIcon(inputAttributes, g);
        this.replaceSelection(" ", false);
        inputAttributes.removeAttributes(inputAttributes);
    }

    public Style addStyle(String nm, Style parent) {
        StyledDocument doc = this.getStyledDocument();
        return doc.addStyle(nm, parent);
    }

    public void removeStyle(String nm) {
        StyledDocument doc = this.getStyledDocument();
        doc.removeStyle(nm);
    }

    public Style getStyle(String nm) {
        StyledDocument doc = this.getStyledDocument();
        return doc.getStyle(nm);
    }

    public void setLogicalStyle(Style s) {
        StyledDocument doc = this.getStyledDocument();
        doc.setLogicalStyle(this.getCaretPosition(), s);
    }

    public Style getLogicalStyle() {
        StyledDocument doc = this.getStyledDocument();
        return doc.getLogicalStyle(this.getCaretPosition());
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element run = doc.getCharacterElement(this.getCaretPosition());
        if (run != null) {
            return run.getAttributes();
        }
        return null;
    }

    public void setCharacterAttributes(AttributeSet attr, boolean replace) {
        int p1;
        int p0 = this.getSelectionStart();
        if (p0 != (p1 = this.getSelectionEnd())) {
            StyledDocument doc = this.getStyledDocument();
            doc.setCharacterAttributes(p0, p1 - p0, attr, replace);
        } else {
            MutableAttributeSet inputAttributes = this.getInputAttributes();
            if (replace) {
                inputAttributes.removeAttributes(inputAttributes);
            }
            inputAttributes.addAttributes(attr);
        }
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element paragraph = doc.getParagraphElement(this.getCaretPosition());
        if (paragraph != null) {
            return paragraph.getAttributes();
        }
        return null;
    }

    public void setParagraphAttributes(AttributeSet attr, boolean replace) {
        int p0 = this.getSelectionStart();
        int p1 = this.getSelectionEnd();
        StyledDocument doc = this.getStyledDocument();
        doc.setParagraphAttributes(p0, p1 - p0, attr, replace);
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    @Override
    public final void setEditorKit(EditorKit kit) {
        if (!(kit instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("Must be StyledEditorKit");
        }
        super.setEditorKit(kit);
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }
}

