/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.plaf;

import com.mongol.encode.MongolianConverter;
import com.mongol.swing.MSwingUtilities;
import com.mongol.swing.plaf.MRotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class MLabelUI
extends BasicLabelUI
implements MRotation {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private int rotate_direction = 0;
    private int rotate_hint = 0;

    public MLabelUI() {
    }

    public MLabelUI(int rotate) {
        this.setRotateHint(rotate);
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int mnemIndex = l.getDisplayedMnemonicIndex();
        g.setColor(l.getForeground());
        MongolianConverter converter = new MongolianConverter();
        String t = converter.convert(s);
        MSwingUtilities.drawStringUnderlineCharAt(l, g, t, mnemIndex, textX, textY, this.rotate_direction, this.rotate_hint);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonicIndex();
        Color background = l.getBackground();
        g.setColor(background.brighter());
        MongolianConverter converter = new MongolianConverter();
        String t = converter.convert(s);
        MSwingUtilities.drawStringUnderlineCharAt(l, g, t, accChar, textX + 1, textY + 1, this.rotate_direction, this.rotate_hint);
        g.setColor(background.darker());
        MSwingUtilities.drawStringUnderlineCharAt(l, g, t, accChar, textX, textY, this.rotate_direction, this.rotate_hint);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        if (this.rotate_direction == 0) {
            FontMetrics fm = MSwingUtilities.getFontMetrics((JComponent)label, g);
            String clippedText = this.layout(label, fm, c.getWidth(), c.getHeight());
            if (icon != null) {
                icon.paintIcon(c, g, this.paintIconR.x, this.paintIconR.y);
            }
            if (text != null) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.paintTextR);
                } else {
                    int textX = this.paintTextR.x;
                    int textY = this.paintTextR.y + fm.getAscent();
                    if (label.isEnabled()) {
                        this.paintEnabledText(label, g, clippedText, textX, textY);
                    } else {
                        this.paintDisabledText(label, g, clippedText, textX, textY);
                    }
                }
            }
        } else {
            Insets insets = c.getInsets(new Insets(0, 0, 0, 0));
            MongolianConverter converter = new MongolianConverter();
            String target = converter.convert(text);
            this.paintViewR = new Rectangle();
            this.paintViewR.y = insets.left;
            this.paintViewR.x = insets.top;
            this.paintViewR.height = c.getWidth() - (insets.left + insets.right);
            this.paintViewR.width = c.getHeight() - (insets.top + insets.bottom);
            this.paintIconR.height = 0;
            this.paintIconR.width = 0;
            this.paintIconR.y = 0;
            this.paintIconR.x = 0;
            this.paintTextR.height = 0;
            this.paintTextR.width = 0;
            this.paintTextR.y = 0;
            this.paintTextR.x = 0;
            FontMetrics fm = MSwingUtilities.getFontMetrics((JComponent)label, g);
            String clippedText = this.layoutCL(label, fm, target, icon, this.paintViewR, this.paintIconR, this.paintTextR);
            if (icon != null) {
                icon.paintIcon(c, g, this.paintIconR.y, this.paintIconR.x);
            }
            ((Graphics2D)g).rotate(1.5707963267948966);
            if (text != null) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.paintTextR);
                } else {
                    int textX = this.paintTextR.x;
                    int textY = -this.paintTextR.y - fm.getDescent();
                    if (label.isEnabled()) {
                        this.paintEnabledText(label, g, clippedText, textX, textY);
                    } else {
                        this.paintDisabledText(label, g, clippedText, textX, textY);
                    }
                }
            }
        }
    }

    private String layout(JLabel label, FontMetrics fm, int width, int height) {
        Insets insets = label.getInsets(null);
        String text = label.getText();
        MongolianConverter converter = new MongolianConverter();
        String target = converter.convert(text);
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Rectangle paintViewR = new Rectangle();
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = width - (insets.left + insets.right);
        paintViewR.height = height - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(label, fm, target, icon, paintViewR, this.paintIconR, this.paintTextR);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JLabel label = (JLabel)c;
        String text = label.getText();
        MongolianConverter converter = new MongolianConverter();
        String target = converter.convert(text);
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Insets insets = label.getInsets(null);
        Font font = label.getFont();
        if (this.rotate_direction == 0) {
            int dx = insets.left + insets.right;
            int dy = insets.top + insets.bottom;
            if (icon == null && (target == null || target != null && font == null)) {
                return new Dimension(dx, dy);
            }
            if (target == null || icon != null && font == null) {
                return new Dimension(icon.getIconWidth() + dx, icon.getIconHeight() + dy);
            }
            FontMetrics fm = label.getFontMetrics(font);
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            Rectangle viewR = new Rectangle();
            iconR.height = 0;
            iconR.width = 0;
            iconR.y = 0;
            iconR.x = 0;
            textR.height = 0;
            textR.width = 0;
            textR.y = 0;
            textR.x = 0;
            viewR.x = dx;
            viewR.y = dy;
            viewR.height = Short.MAX_VALUE;
            viewR.width = Short.MAX_VALUE;
            this.layoutCL(label, fm, target, icon, viewR, iconR, textR);
            int x1 = Math.min(iconR.x, textR.x);
            int x2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
            int y1 = Math.min(iconR.y, textR.y);
            int y2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
            Dimension rv = new Dimension(x2 - x1, y2 - y1);
            rv.width += dx;
            rv.height += dy;
            return rv;
        }
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        if (icon == null && (target == null || target != null && font == null)) {
            return new Dimension(dy, dx);
        }
        if (target == null || icon != null && font == null) {
            return new Dimension(icon.getIconWidth() + dy, icon.getIconHeight() + dx);
        }
        FontMetrics fm = label.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle();
        iconR.height = 0;
        iconR.width = 0;
        iconR.y = 0;
        iconR.x = 0;
        textR.height = 0;
        textR.width = 0;
        textR.y = 0;
        textR.x = 0;
        viewR.x = dy;
        viewR.y = dx;
        viewR.height = Short.MAX_VALUE;
        viewR.width = Short.MAX_VALUE;
        this.layoutCL(label, fm, target, icon, viewR, iconR, textR);
        int y1 = Math.min(iconR.x, textR.x);
        int y2 = Math.max(iconR.x + iconR.width, textR.x + textR.width);
        int x1 = Math.min(iconR.y, textR.y);
        int x2 = Math.max(iconR.y + iconR.height, textR.y + textR.height);
        Dimension rv = new Dimension(x2 - x1, y2 - y1);
        rv.width += dy;
        rv.height += dx;
        return rv;
    }
}

