/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.plaf;

import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.text.MPlainView;
import com.mongol.swing.text.MWrappedPlainView;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class MTextAreaUI
extends BasicTextAreaUI
implements MRotation {
    private int rotate_direction = 0;
    private int rotate_hint = 0;
    private MRotation view = null;

    public static ComponentUI createUI(JComponent ta) {
        return new MTextAreaUI();
    }

    public MTextAreaUI() {
    }

    public MTextAreaUI(int rotate) {
        this.setRotateHint(rotate);
    }

    @Override
    public View create(Element elem) {
        Document doc = elem.getDocument();
        JTextComponent c = this.getComponent();
        if (c instanceof JTextArea) {
            View v;
            JTextArea area = (JTextArea)c;
            if (area.getLineWrap()) {
                MWrappedPlainView mview = new MWrappedPlainView(elem, area.getWrapStyleWord());
                this.view = mview;
                this.view.setRotateDirection(this.rotate_direction);
                this.view.setRotateHint(this.rotate_hint);
                if (this.rotate_direction != 0) {
                    mview.setAxis(0);
                }
                v = mview;
            } else {
                MPlainView mview = new MPlainView(elem);
                this.view = mview;
                this.view.setRotateDirection(this.rotate_direction);
                this.view.setRotateHint(this.rotate_hint);
                v = mview;
            }
            return v;
        }
        return null;
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        JTextComponent editor = super.getComponent();
        Rectangle alloc = editor.getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
        if (this.view != null) {
            this.view.setRotateHint(hint);
        }
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
        if (this.view != null) {
            this.view.setRotateDirection(direction);
        }
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }
}

