/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.plaf;

import com.mongol.swing.border.RoundBorder;
import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.text.MFieldView;
import com.mongol.swing.text.MPlainView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class MTextFieldUI
extends BasicTextFieldUI
implements MRotation {
    private int rotate_direction = 0;
    private int rotate_hint = 0;
    private MPlainView view = null;

    public static ComponentUI createUI(JComponent c) {
        return new MTextFieldUI();
    }

    public MTextFieldUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent editor = this.getComponent();
        if (!editor.isOpaque()) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(UIManager.getColor("TextField.background"));
            Border border = this.getComponent().getBorder();
            if (this.rotate_direction == 0 && border instanceof RoundBorder) {
                g2d.fillRoundRect(0, 0, editor.getWidth() - 1, editor.getHeight() - 1, editor.getHeight(), editor.getHeight());
            }
            g2d.dispose();
        }
        super.paintSafely(g);
    }

    @Override
    public View create(Element elem) {
        Document doc = elem.getDocument();
        Object i18nFlag = doc.getProperty("i18n");
        if (Boolean.TRUE.equals(i18nFlag)) {
            return super.create(elem);
        }
        this.view = new MFieldView(elem);
        this.view.setRotateDirection(this.rotate_direction);
        this.view.setRotateHint(this.rotate_hint);
        return this.view;
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        int dot = super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
        return dot;
    }

    public MTextFieldUI(int rotate) {
        this.setRotateHint(rotate);
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
        if (this.view != null) {
            this.view.setRotateHint(hint);
        }
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
        if (this.view != null) {
            this.view.setRotateDirection(direction);
        }
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }
}

