/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import com.mongol.swing.MSwingUtilities;
import com.mongol.swing.text.MSegmentCache;
import com.mongol.swing.text.MStateInvariantError;
import com.mongol.swing.text.MUtilities;
import com.mongol.swing.text.MWhitespaceBasedBreakIterator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.text.BreakIterator;
import java.util.BitSet;
import java.util.Locale;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MGlyphView
extends View
implements TabableView,
Cloneable {
    private int rotate_direction = 0;
    private int rotate_hint = 0;
    private byte[] selections = null;
    int offset = 0;
    int length = 0;
    boolean impliedCR;
    boolean skipWidth;
    TabExpander expander;
    private float minimumSpan = -1.0f;
    private int[] breakSpots = null;
    int x;
    GlyphPainter painter;
    static GlyphPainter defaultPainter;
    private JustificationInfo justificationInfo = null;

    public MGlyphView(Element elem) {
        super(elem);
        Element parent = elem.getParentElement();
        AttributeSet attr = elem.getAttributes();
        this.impliedCR = attr != null && attr.getAttribute("cr") != null && parent != null && parent.getElementCount() > 1;
        this.skipWidth = elem.getName().equals("br");
    }

    public MGlyphView(Element elem, int direction, int hint) {
        super(elem);
        Element parent = elem.getParentElement();
        AttributeSet attr = elem.getAttributes();
        this.impliedCR = attr != null && attr.getAttribute("cr") != null && parent != null && parent.getElementCount() > 1;
        this.skipWidth = elem.getName().equals("br");
        this.rotate_direction = direction;
        this.rotate_hint = hint;
    }

    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
    }

    public int getRotateHint() {
        return this.rotate_hint;
    }

    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
    }

    public int getRotateDirection() {
        return this.rotate_direction;
    }

    protected final Object clone() {
        Object o;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            o = null;
        }
        return o;
    }

    public GlyphPainter getGlyphPainter() {
        return this.painter;
    }

    public void setGlyphPainter(GlyphPainter p) {
        this.painter = p;
    }

    public Segment getText(int p0, int p1) {
        Segment text = MSegmentCache.getSharedSegment();
        try {
            Document doc = this.getDocument();
            doc.getText(p0, p1 - p0, text);
        }
        catch (BadLocationException bl) {
            throw new MStateInvariantError("GlyphView: Stale view: " + bl);
        }
        return text;
    }

    public Color getBackground() {
        AttributeSet attr;
        Document doc = this.getDocument();
        if (doc instanceof StyledDocument && (attr = this.getAttributes()).isDefined(StyleConstants.Background)) {
            return ((StyledDocument)doc).getBackground(attr);
        }
        return null;
    }

    public Color getForeground() {
        Document doc = this.getDocument();
        if (doc instanceof StyledDocument) {
            AttributeSet attr = this.getAttributes();
            return ((StyledDocument)doc).getForeground(attr);
        }
        Container c = this.getContainer();
        if (c != null) {
            return c.getForeground();
        }
        return null;
    }

    public Font getFont() {
        Document doc = this.getDocument();
        if (doc instanceof StyledDocument) {
            AttributeSet attr = this.getAttributes();
            return ((StyledDocument)doc).getFont(attr);
        }
        Container c = this.getContainer();
        if (c != null) {
            return c.getFont();
        }
        return null;
    }

    public boolean isUnderline() {
        AttributeSet attr = this.getAttributes();
        return StyleConstants.isUnderline(attr);
    }

    public boolean isStrikeThrough() {
        AttributeSet attr = this.getAttributes();
        return StyleConstants.isStrikeThrough(attr);
    }

    public boolean isSubscript() {
        AttributeSet attr = this.getAttributes();
        return StyleConstants.isSubscript(attr);
    }

    public boolean isSuperscript() {
        AttributeSet attr = this.getAttributes();
        return StyleConstants.isSuperscript(attr);
    }

    public TabExpander getTabExpander() {
        return this.expander;
    }

    protected void checkPainter() {
        if (this.painter == null) {
            if (defaultPainter == null) {
                String classname = "com.linguinet.swing.text.MGlyphPainter1";
                try {
                    ClassLoader loader = this.getClass().getClassLoader();
                    Class<?> c = loader != null ? loader.loadClass(classname) : Class.forName(classname);
                    Object o = c.newInstance();
                    if (o instanceof GlyphPainter) {
                        defaultPainter = (GlyphPainter)o;
                    }
                }
                catch (Throwable e) {
                    throw new MStateInvariantError("GlyphView: Can't load glyph painter: " + classname);
                }
            }
            this.setGlyphPainter(defaultPainter.getPainter(this, this.getStartOffset(), this.getEndOffset()));
        }
    }

    @Override
    public float getTabbedSpan(float x, TabExpander e) {
        this.checkPainter();
        TabExpander old = this.expander;
        this.expander = e;
        if (this.expander != old) {
            this.preferenceChanged(null, true, false);
        }
        this.x = (int)x;
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        float width = this.painter.getSpan(this, p0, p1, this.expander, x);
        return width;
    }

    @Override
    public float getPartialSpan(int p0, int p1) {
        this.checkPainter();
        float width = this.painter.getSpan(this, p0, p1, this.expander, this.x);
        return width;
    }

    @Override
    public int getStartOffset() {
        Element e = this.getElement();
        return this.length > 0 ? e.getStartOffset() + this.offset : e.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        Element e = this.getElement();
        return this.length > 0 ? e.getStartOffset() + this.offset + this.length : e.getEndOffset();
    }

    private void initSelections(int p0, int p1) {
        int viewPosCount = p1 - p0 + 1;
        if (this.selections == null || viewPosCount > this.selections.length) {
            this.selections = new byte[viewPosCount];
            return;
        }
        int i = 0;
        while (i < viewPosCount) {
            this.selections[i++] = 0;
        }
    }

    @Override
    public void paint(Graphics g, Shape a) {
        if (this.getRotateDirection() == 0) {
            this.paintHorizantal(g, a);
        } else if (this.getRotateHint() != 4) {
            this.paintVerticalL2R(g, a);
        } else {
            this.paintVerticalR2L(g, a);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void paintHorizantal(Graphics g, Shape a) {
        block13: {
            block12: {
                this.checkPainter();
                paintedText = false;
                c = this.getContainer();
                p0 = this.getStartOffset();
                p1 = this.getEndOffset();
                alloc = a instanceof Rectangle != false ? (Rectangle)a : a.getBounds();
                bg = this.getBackground();
                fg = this.getForeground();
                if (c != null && !c.isEnabled()) {
                    v0 = fg = c instanceof JTextComponent != false ? ((JTextComponent)c).getDisabledTextColor() : UIManager.getColor("textInactiveText");
                }
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                }
                if (c instanceof JTextComponent && (h = (tc = (JTextComponent)c).getHighlighter()) instanceof LayeredHighlighter) {
                    ((LayeredHighlighter)h).paintLayeredHighlights(g, p0, p1, a, tc, this);
                }
                if (!MUtilities.isComposedTextElement(this.getElement())) break block12;
                MUtilities.paintComposedText(g, a.getBounds(), this);
                paintedText = true;
                break block13;
            }
            if (!(c instanceof JTextComponent)) break block13;
            tc = (JTextComponent)c;
            selFG = tc.getSelectedTextColor();
            if (tc.getHighlighter() == null || selFG == null || selFG.equals(fg) || (h = tc.getHighlighter().getHighlights()).length == 0) break block13;
            initialized = false;
            viewSelectionCount = 0;
            i = 0;
            while (i < h.length) {
                highlight = h[i];
                hStart = highlight.getStartOffset();
                hEnd = highlight.getEndOffset();
                if (hStart <= p1 && hEnd >= p0 && MSwingUtilities.useSelectedTextColor(highlight, tc)) {
                    if (hStart <= p0 && hEnd >= p1) {
                        this.paintTextUsingColor(g, a, selFG, p0, p1);
                        paintedText = true;
                        break;
                    }
                    if (!initialized) {
                        this.initSelections(p0, p1);
                        initialized = true;
                    }
                    hStart = Math.max(p0, hStart);
                    hEnd = Math.min(p1, hEnd);
                    this.paintTextUsingColor(g, a, selFG, hStart, hEnd);
                    v1 = hStart - p0;
                    this.selections[v1] = (byte)(this.selections[v1] + 1);
                    v2 = hEnd - p0;
                    this.selections[v2] = (byte)(this.selections[v2] - 1);
                    ++viewSelectionCount;
                }
                ++i;
            }
            if (paintedText || viewSelectionCount <= 0) break block13;
            curPos = -1;
            startPos = 0;
            viewLen = p1 - p0;
            ** GOTO lbl65
            {
                ++curPos;
                do {
                    if (curPos < viewLen && this.selections[curPos] == 0) continue block1;
                    if (startPos != curPos) {
                        this.paintTextUsingColor(g, a, fg, p0 + startPos, p0 + curPos);
                    }
                    checkSum = 0;
                    while (curPos < viewLen && (checkSum += this.selections[curPos]) != 0) {
                        ++curPos;
                    }
                    startPos = curPos;
lbl65:
                    // 2 sources

                } while (curPos++ < viewLen);
            }
            paintedText = true;
        }
        if (!paintedText) {
            this.paintTextUsingColor(g, a, fg, p0, p1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void paintVerticalL2R(Graphics g, Shape a) {
        block13: {
            block12: {
                this.checkPainter();
                paintedText = false;
                c = this.getContainer();
                p0 = this.getStartOffset();
                p1 = this.getEndOffset();
                alloc = a instanceof Rectangle != false ? (Rectangle)a : a.getBounds();
                bg = this.getBackground();
                fg = this.getForeground();
                if (c != null && !c.isEnabled()) {
                    v0 = fg = c instanceof JTextComponent != false ? ((JTextComponent)c).getDisabledTextColor() : UIManager.getColor("textInactiveText");
                }
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                }
                if (c instanceof JTextComponent && (h = (tc = (JTextComponent)c).getHighlighter()) instanceof LayeredHighlighter) {
                    ((LayeredHighlighter)h).paintLayeredHighlights(g, p0, p1, a, tc, this);
                }
                if (!MUtilities.isComposedTextElement(this.getElement())) break block12;
                MUtilities.paintComposedText(g, a.getBounds(), this);
                paintedText = true;
                break block13;
            }
            if (!(c instanceof JTextComponent)) break block13;
            tc = (JTextComponent)c;
            selFG = tc.getSelectedTextColor();
            if (tc.getHighlighter() == null || selFG == null || selFG.equals(fg) || (h = tc.getHighlighter().getHighlights()).length == 0) break block13;
            initialized = false;
            viewSelectionCount = 0;
            i = 0;
            while (i < h.length) {
                highlight = h[i];
                hStart = highlight.getStartOffset();
                hEnd = highlight.getEndOffset();
                if (hStart <= p1 && hEnd >= p0 && MSwingUtilities.useSelectedTextColor(highlight, tc)) {
                    if (hStart <= p0 && hEnd >= p1) {
                        this.paintTextUsingColor(g, a, selFG, p0, p1);
                        paintedText = true;
                        break;
                    }
                    if (!initialized) {
                        this.initSelections(p0, p1);
                        initialized = true;
                    }
                    hStart = Math.max(p0, hStart);
                    hEnd = Math.min(p1, hEnd);
                    this.paintTextUsingColor(g, a, selFG, hStart, hEnd);
                    v1 = hStart - p0;
                    this.selections[v1] = (byte)(this.selections[v1] + 1);
                    v2 = hEnd - p0;
                    this.selections[v2] = (byte)(this.selections[v2] - 1);
                    ++viewSelectionCount;
                }
                ++i;
            }
            if (paintedText || viewSelectionCount <= 0) break block13;
            curPos = -1;
            startPos = 0;
            viewLen = p1 - p0;
            ** GOTO lbl65
            {
                ++curPos;
                do {
                    if (curPos < viewLen && this.selections[curPos] == 0) continue block1;
                    if (startPos != curPos) {
                        this.paintTextUsingColor(g, a, fg, p0 + startPos, p0 + curPos);
                    }
                    checkSum = 0;
                    while (curPos < viewLen && (checkSum += this.selections[curPos]) != 0) {
                        ++curPos;
                    }
                    startPos = curPos;
lbl65:
                    // 2 sources

                } while (curPos++ < viewLen);
            }
            paintedText = true;
        }
        if (!paintedText) {
            this.paintTextUsingColor(g, a, fg, p0, p1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void paintVerticalR2L(Graphics g, Shape a) {
        block13: {
            block12: {
                this.checkPainter();
                paintedText = false;
                c = this.getContainer();
                clipbounds = c.getBounds();
                p0 = this.getStartOffset();
                p1 = this.getEndOffset();
                alloc = a instanceof Rectangle != false ? new Rectangle((Rectangle)a) : a.getBounds();
                alloc.x = clipbounds.width - alloc.x - alloc.width;
                bg = this.getBackground();
                fg = this.getForeground();
                if (c != null && !c.isEnabled()) {
                    v0 = fg = c instanceof JTextComponent != false ? ((JTextComponent)c).getDisabledTextColor() : UIManager.getColor("textInactiveText");
                }
                if (bg != null) {
                    g.setColor(bg);
                    g.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                }
                if (c instanceof JTextComponent && (h = (tc = (JTextComponent)c).getHighlighter()) instanceof LayeredHighlighter) {
                    ((LayeredHighlighter)h).paintLayeredHighlights(g, p0, p1, alloc, tc, this);
                }
                if (!MUtilities.isComposedTextElement(this.getElement())) break block12;
                MUtilities.paintComposedText(g, alloc, this);
                paintedText = true;
                break block13;
            }
            if (!(c instanceof JTextComponent)) break block13;
            tc = (JTextComponent)c;
            selFG = tc.getSelectedTextColor();
            if (tc.getHighlighter() == null || selFG == null || selFG.equals(fg) || (h = tc.getHighlighter().getHighlights()).length == 0) break block13;
            initialized = false;
            viewSelectionCount = 0;
            i = 0;
            while (i < h.length) {
                highlight = h[i];
                hStart = highlight.getStartOffset();
                hEnd = highlight.getEndOffset();
                if (hStart <= p1 && hEnd >= p0 && MSwingUtilities.useSelectedTextColor(highlight, tc)) {
                    if (hStart <= p0 && hEnd >= p1) {
                        this.paintTextUsingColor(g, a, selFG, p0, p1);
                        paintedText = true;
                        break;
                    }
                    if (!initialized) {
                        this.initSelections(p0, p1);
                        initialized = true;
                    }
                    hStart = Math.max(p0, hStart);
                    hEnd = Math.min(p1, hEnd);
                    this.paintTextUsingColor(g, a, selFG, hStart, hEnd);
                    v1 = hStart - p0;
                    this.selections[v1] = (byte)(this.selections[v1] + 1);
                    v2 = hEnd - p0;
                    this.selections[v2] = (byte)(this.selections[v2] - 1);
                    ++viewSelectionCount;
                }
                ++i;
            }
            if (paintedText || viewSelectionCount <= 0) break block13;
            curPos = -1;
            startPos = 0;
            viewLen = p1 - p0;
            ** GOTO lbl67
            {
                ++curPos;
                do {
                    if (curPos < viewLen && this.selections[curPos] == 0) continue block1;
                    if (startPos != curPos) {
                        this.paintTextUsingColor(g, a, fg, p0 + startPos, p0 + curPos);
                    }
                    checkSum = 0;
                    while (curPos < viewLen && (checkSum += this.selections[curPos]) != 0) {
                        ++curPos;
                    }
                    startPos = curPos;
lbl67:
                    // 2 sources

                } while (curPos++ < viewLen);
            }
            paintedText = true;
        }
        if (!paintedText) {
            this.paintTextUsingColor(g, a, fg, p0, p1);
        }
    }

    final void paintTextUsingColor(Graphics g, Shape a, Color c, int p0, int p1) {
        g.setColor(c);
        this.painter.paint(this, g, a, p0, p1);
        boolean underline = this.isUnderline();
        boolean strike = this.isStrikeThrough();
        if (underline || strike) {
            int yTmp;
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            View parent = this.getParent();
            if (parent != null && parent.getEndOffset() == p1) {
                Segment s = this.getText(p0, p1);
                while (Character.isWhitespace(s.last())) {
                    --p1;
                    --s.count;
                }
                MSegmentCache.releaseSharedSegment(s);
            }
            int x0 = alloc.x;
            int p = this.getStartOffset();
            if (p != p0) {
                x0 += (int)this.painter.getSpan(this, p, p0, this.getTabExpander(), x0);
            }
            int x1 = x0 + (int)this.painter.getSpan(this, p0, p1, this.getTabExpander(), x0);
            int y = alloc.y + alloc.height - (int)this.painter.getDescent(this);
            if (underline) {
                yTmp = y + 1;
                g.drawLine(x0, yTmp, x1, yTmp);
            }
            if (strike) {
                yTmp = y - (int)(this.painter.getAscent(this) * 0.3f);
                g.drawLine(x0, yTmp, x1, yTmp);
            }
        }
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (this.getRotateDirection() == 0) {
            switch (axis) {
                case 0: {
                    if (this.minimumSpan < 0.0f) {
                        this.minimumSpan = 0.0f;
                        int p0 = this.getStartOffset();
                        int p1 = this.getEndOffset();
                        while (p1 > p0) {
                            int breakSpot = this.getBreakSpot(p0, p1);
                            if (breakSpot == -1) {
                                breakSpot = p0;
                            }
                            this.minimumSpan = Math.max(this.minimumSpan, this.getPartialSpan(breakSpot, p1));
                            p1 = breakSpot - 1;
                        }
                    }
                    return this.minimumSpan;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
        switch (axis) {
            case 1: {
                if (this.minimumSpan < 0.0f) {
                    this.minimumSpan = 0.0f;
                    int p0 = this.getStartOffset();
                    int p1 = this.getEndOffset();
                    while (p1 > p0) {
                        int breakSpot = this.getBreakSpot(p0, p1);
                        if (breakSpot == -1) {
                            breakSpot = p0;
                        }
                        this.minimumSpan = Math.max(this.minimumSpan, this.getPartialSpan(breakSpot, p1));
                        p1 = breakSpot - 1;
                    }
                }
                return this.minimumSpan;
            }
            case 0: {
                return super.getMinimumSpan(axis);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.impliedCR) {
            return 0.0f;
        }
        if (this.rotate_direction == 0) {
            this.checkPainter();
            int p0 = this.getStartOffset();
            int p1 = this.getEndOffset();
            switch (axis) {
                case 0: {
                    if (this.skipWidth) {
                        return 0.0f;
                    }
                    return this.painter.getSpan(this, p0, p1, this.expander, this.x);
                }
                case 1: {
                    float h = this.painter.getHeight(this);
                    if (this.isSuperscript()) {
                        h += h / 3.0f;
                    }
                    return h;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
        this.checkPainter();
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        switch (axis) {
            case 1: {
                if (this.skipWidth) {
                    return 0.0f;
                }
                return this.painter.getSpan(this, p0, p1, this.expander, this.x);
            }
            case 0: {
                float h = this.painter.getHeight(this);
                if (this.isSuperscript()) {
                    h += h / 3.0f;
                }
                return h;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public float getAlignment(int axis) {
        this.checkPainter();
        if (axis == 1) {
            boolean sup = this.isSuperscript();
            boolean sub = this.isSubscript();
            float h = this.painter.getHeight(this);
            float d = this.painter.getDescent(this);
            float a = this.painter.getAscent(this);
            float align = sup ? 1.0f : (sub ? (h > 0.0f ? (h - (d + a / 2.0f)) / h : 0.0f) : (h > 0.0f ? (h - d) / h : 0.0f));
            return align;
        }
        return 0.0f;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        this.checkPainter();
        return this.painter.modelToView(this, pos, b, a);
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        this.checkPainter();
        return this.painter.viewToModel(this, x, y, a, biasReturn);
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        if (this.getRotateDirection() == 0) {
            if (axis == 0) {
                this.checkPainter();
                int p0 = this.getStartOffset();
                int p1 = this.painter.getBoundedPosition(this, p0, pos, len);
                return p1 == p0 ? 0 : (this.getBreakSpot(p0, p1) != -1 ? 2000 : 1000);
            }
            return super.getBreakWeight(axis, pos, len);
        }
        if (axis == 1) {
            this.checkPainter();
            int p0 = this.getStartOffset();
            int p1 = this.painter.getBoundedPosition(this, p0, pos, len);
            return p1 == p0 ? 0 : (this.getBreakSpot(p0, p1) != -1 ? 2000 : 1000);
        }
        return super.getBreakWeight(axis, pos, len);
    }

    @Override
    public View breakView(int axis, int p0, float pos, float len) {
        if (this.getRotateDirection() == 0) {
            if (axis == 0) {
                this.checkPainter();
                int p1 = this.painter.getBoundedPosition(this, p0, pos, len);
                int breakSpot = this.getBreakSpot(p0, p1);
                if (breakSpot != -1) {
                    p1 = breakSpot;
                }
                if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                    return this;
                }
                MGlyphView v = (MGlyphView)this.createFragment(p0, p1);
                v.x = (int)pos;
                return v;
            }
            return this;
        }
        if (axis == 1) {
            this.checkPainter();
            int p1 = this.painter.getBoundedPosition(this, p0, pos, len);
            int breakSpot = this.getBreakSpot(p0, p1);
            if (breakSpot != -1) {
                p1 = breakSpot;
            }
            if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                return this;
            }
            MGlyphView v = (MGlyphView)this.createFragment(p0, p1);
            v.x = (int)pos;
            return v;
        }
        return this;
    }

    private int getBreakSpot(int p0, int p1) {
        if (this.breakSpots == null) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            int[] bs = new int[end + 1 - start];
            int ix = 0;
            Element parent = this.getElement().getParentElement();
            int pstart = parent == null ? start : parent.getStartOffset();
            int pend = parent == null ? end : parent.getEndOffset();
            Segment s = this.getText(pstart, pend);
            s.first();
            BreakIterator breaker = this.getBreaker();
            breaker.setText(s);
            int startFrom = end + (pend > end ? 1 : 0);
            while ((startFrom = breaker.preceding(s.offset + (startFrom - pstart)) + (pstart - s.offset)) > start) {
                bs[ix++] = startFrom;
            }
            MSegmentCache.releaseSharedSegment(s);
            this.breakSpots = new int[ix];
            System.arraycopy(bs, 0, this.breakSpots, 0, ix);
        }
        int breakSpot = -1;
        int i = 0;
        while (i < this.breakSpots.length) {
            int bsp = this.breakSpots[i];
            if (bsp <= p1) {
                if (bsp <= p0) break;
                breakSpot = bsp;
                break;
            }
            ++i;
        }
        return breakSpot;
    }

    private BreakIterator getBreaker() {
        Document doc = this.getDocument();
        if (doc != null && Boolean.TRUE.equals(doc.getProperty("multiByte"))) {
            Container c = this.getContainer();
            Locale locale = c == null ? Locale.getDefault() : c.getLocale();
            return BreakIterator.getLineInstance(locale);
        }
        return new MWhitespaceBasedBreakIterator();
    }

    @Override
    public View createFragment(int p0, int p1) {
        this.checkPainter();
        Element elem = this.getElement();
        MGlyphView v = (MGlyphView)this.clone();
        v.offset = p0 - elem.getStartOffset();
        v.length = p1 - p0;
        v.painter = this.painter.getPainter(v, p0, p1);
        v.justificationInfo = null;
        return v;
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return this.painter.getNextVisualPositionFrom(this, pos, b, a, direction, biasRet);
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.justificationInfo = null;
        this.breakSpots = null;
        this.minimumSpan = -1.0f;
        this.syncCR();
        this.preferenceChanged(null, true, false);
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.justificationInfo = null;
        this.breakSpots = null;
        this.minimumSpan = -1.0f;
        this.syncCR();
        this.preferenceChanged(null, true, false);
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.minimumSpan = -1.0f;
        this.syncCR();
        this.preferenceChanged(null, true, true);
    }

    private void syncCR() {
        if (this.impliedCR) {
            Element parent = this.getElement().getParentElement();
            this.impliedCR = parent != null && parent.getElementCount() > 1;
        }
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        if (this.getRotateDirection() == 0) {
            return this.modelToViewHorizantal(p0, b0, p1, b1, a);
        }
        if (this.getRotateHint() != 4) {
            return this.modelToViewVerticalL2R(p0, b0, p1, b1, a);
        }
        return this.modelToViewVerticalR2L(p0, b0, p1, b1, a);
    }

    private Shape modelToViewHorizantal(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Rectangle r0 = s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        return r0;
    }

    private Shape modelToViewVerticalL2R(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Rectangle r0 = s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        return r0;
    }

    private Shape modelToViewVerticalR2L(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Container c = this.getContainer();
        Rectangle clipbounds = c.getBounds();
        Rectangle r0 = s0.getBounds();
        r0.x = clipbounds.width - r0.x;
        Rectangle r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        r1.x = clipbounds.width - r1.x;
        if (r0.x != r1.x) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.y = alloc.y;
            r0.height = alloc.height;
        }
        r0.add(r1);
        return r0;
    }

    JustificationInfo getJustificationInfo(int rowStartOffset) {
        if (this.justificationInfo != null) {
            return this.justificationInfo;
        }
        boolean TRAILING = false;
        boolean CONTENT = true;
        int SPACES = 2;
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        Segment segment = this.getText(startOffset, endOffset);
        int txtOffset = segment.offset;
        int txtEnd = segment.offset + segment.count - 1;
        int startContentPosition = txtEnd + 1;
        int endContentPosition = txtOffset - 1;
        int lastTabPosition = txtOffset - 1;
        int trailingSpaces = 0;
        int contentSpaces = 0;
        int leadingSpaces = 0;
        boolean hasTab = false;
        BitSet spaceMap = new BitSet(endOffset - startOffset + 1);
        int i = txtEnd;
        int state = 0;
        while (i >= txtOffset) {
            if (' ' == segment.array[i]) {
                spaceMap.set(i - txtOffset);
                if (state == 0) {
                    ++trailingSpaces;
                } else if (state == 1) {
                    state = 2;
                    leadingSpaces = 1;
                } else if (state == 2) {
                    ++leadingSpaces;
                }
            } else {
                if ('\t' == segment.array[i]) {
                    hasTab = true;
                    break;
                }
                if (state == 0) {
                    if ('\n' != segment.array[i] && '\r' != segment.array[i]) {
                        state = 1;
                        endContentPosition = i;
                    }
                } else if (state != 1 && state == 2) {
                    contentSpaces += leadingSpaces;
                    leadingSpaces = 0;
                }
                startContentPosition = i;
            }
            --i;
        }
        MSegmentCache.releaseSharedSegment(segment);
        int startJustifiableContent = -1;
        if (startContentPosition < txtEnd) {
            startJustifiableContent = startContentPosition - txtOffset;
        }
        int endJustifiableContent = -1;
        if (endContentPosition > txtOffset) {
            endJustifiableContent = endContentPosition - txtOffset;
        }
        this.justificationInfo = new JustificationInfo(startJustifiableContent, endJustifiableContent, leadingSpaces, contentSpaces, trailingSpaces, hasTab, spaceMap);
        return this.justificationInfo;
    }

    public static abstract class GlyphPainter {
        public abstract float getSpan(MGlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public abstract float getHeight(MGlyphView var1);

        public abstract float getAscent(MGlyphView var1);

        public abstract float getDescent(MGlyphView var1);

        public abstract void paint(MGlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(MGlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(MGlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract int getBoundedPosition(MGlyphView var1, int var2, float var3, float var4);

        public GlyphPainter getPainter(MGlyphView v, int p0, int p1) {
            return this;
        }

        public int getNextVisualPositionFrom(MGlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (v.getRotateDirection() == 0) {
                return this.getNextVisualPositionFromHorizantal(v, pos, b, a, direction, biasRet);
            }
            if (v.getRotateHint() != 4) {
                return this.getNextVisualPositionFromVerticalL2R(v, pos, b, a, direction, biasRet);
            }
            return this.getNextVisualPositionFromVerticalR2L(v, pos, b, a, direction, biasRet);
        }

        private int getNextVisualPositionFromHorizantal(MGlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int startOffset = v.getStartOffset();
            int endOffset = v.getEndOffset();
            switch (direction) {
                case 1: 
                case 5: {
                    Point magicPoint;
                    if (pos != -1) {
                        return -1;
                    }
                    Container container = v.getContainer();
                    if (!(container instanceof JTextComponent)) break;
                    Caret c = ((JTextComponent)container).getCaret();
                    Point point = magicPoint = c != null ? c.getMagicCaretPosition() : null;
                    if (magicPoint == null) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    int value = v.viewToModel(magicPoint.x, 0.0f, a, biasRet);
                    return value;
                }
                case 3: {
                    if (startOffset == v.getDocument().getLength()) {
                        if (pos == -1) {
                            biasRet[0] = Position.Bias.Forward;
                            return startOffset;
                        }
                        return -1;
                    }
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    if (pos == endOffset) {
                        return -1;
                    }
                    if (++pos == endOffset) {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return pos;
                }
                case 7: {
                    if (startOffset == v.getDocument().getLength()) {
                        if (pos == -1) {
                            biasRet[0] = Position.Bias.Forward;
                            return startOffset;
                        }
                        return -1;
                    }
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return endOffset - 1;
                    }
                    if (pos == startOffset) {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return pos - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + direction);
                }
            }
            return pos;
        }

        private int getNextVisualPositionFromVerticalL2R(MGlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int startOffset = v.getStartOffset();
            int endOffset = v.getEndOffset();
            switch (direction) {
                case 3: 
                case 7: {
                    Point magicPoint;
                    if (pos != -1) {
                        return -1;
                    }
                    Container container = v.getContainer();
                    if (!(container instanceof JTextComponent)) break;
                    Caret c = ((JTextComponent)container).getCaret();
                    Point point = magicPoint = c != null ? c.getMagicCaretPosition() : null;
                    if (magicPoint == null) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    int value = v.viewToModel(magicPoint.x, 0.0f, a, biasRet);
                    return value;
                }
                case 5: {
                    if (startOffset == v.getDocument().getLength()) {
                        if (pos == -1) {
                            biasRet[0] = Position.Bias.Forward;
                            return startOffset;
                        }
                        return -1;
                    }
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    if (pos == endOffset) {
                        return -1;
                    }
                    if (++pos == endOffset) {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return pos;
                }
                case 1: {
                    if (startOffset == v.getDocument().getLength()) {
                        if (pos == -1) {
                            biasRet[0] = Position.Bias.Forward;
                            return startOffset;
                        }
                        return -1;
                    }
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return endOffset - 1;
                    }
                    if (pos == startOffset) {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return pos - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + direction);
                }
            }
            return pos;
        }

        private int getNextVisualPositionFromVerticalR2L(MGlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int startOffset = v.getStartOffset();
            int endOffset = v.getEndOffset();
            switch (direction) {
                case 3: 
                case 7: {
                    Point magicPoint;
                    if (pos != -1) {
                        return -1;
                    }
                    Container container = v.getContainer();
                    if (!(container instanceof JTextComponent)) break;
                    Caret c = ((JTextComponent)container).getCaret();
                    Point point = magicPoint = c != null ? c.getMagicCaretPosition() : null;
                    if (magicPoint == null) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    int value = v.viewToModel(magicPoint.x, 0.0f, a, biasRet);
                    return value;
                }
                case 5: {
                    if (startOffset == v.getDocument().getLength()) {
                        if (pos == -1) {
                            biasRet[0] = Position.Bias.Forward;
                            return startOffset;
                        }
                        return -1;
                    }
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    if (pos == endOffset) {
                        return -1;
                    }
                    if (++pos == endOffset) {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return pos;
                }
                case 1: {
                    if (startOffset == v.getDocument().getLength()) {
                        if (pos == -1) {
                            biasRet[0] = Position.Bias.Forward;
                            return startOffset;
                        }
                        return -1;
                    }
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return endOffset - 1;
                    }
                    if (pos == startOffset) {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return pos - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + direction);
                }
            }
            return pos;
        }
    }

    static class JustificationInfo {
        final int start;
        final int end;
        final int leadingSpaces;
        final int contentSpaces;
        final int trailingSpaces;
        final boolean hasTab;
        final BitSet spaceMap;

        JustificationInfo(int start, int end, int leadingSpaces, int contentSpaces, int trailingSpaces, boolean hasTab, BitSet spaceMap) {
            this.start = start;
            this.end = end;
            this.leadingSpaces = leadingSpaces;
            this.contentSpaces = contentSpaces;
            this.trailingSpaces = trailingSpaces;
            this.hasTab = hasTab;
            this.spaceMap = spaceMap;
        }
    }
}

