/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import com.mongol.encode.MongolianFontUtil;
import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.text.MSegmentCache;
import com.mongol.swing.text.MStateInvariantError;
import com.mongol.swing.text.MUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MPlainView
extends View
implements TabExpander,
MRotation {
    protected FontMetrics metrics;
    protected FontMetrics defaultmetrics;
    Element longLine;
    Font font;
    Segment lineBuffer;
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;
    int firstLineOffset;
    private int rotate_direction = 0;
    private int rotate_hint = 0;
    float width = 0.0f;
    float height = 0.0f;

    public MPlainView(Element elem) {
        super(elem);
    }

    protected int getTabSize() {
        Integer i = (Integer)this.getDocument().getProperty("tabSize");
        int size = i != null ? i : 8;
        return size;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        Element line = this.getElement().getElement(lineIndex);
        try {
            if (line.isLeaf()) {
                this.drawElement(lineIndex, line, g, x, y);
            } else {
                int count = line.getElementCount();
                int i = 0;
                while (i < count) {
                    Element elem = line.getElement(i);
                    x = this.drawElement(lineIndex, elem, g, x, y);
                    ++i;
                }
            }
        }
        catch (BadLocationException e) {
            throw new MStateInvariantError("Can't render line: " + lineIndex);
        }
    }

    private int drawElement(int lineIndex, Element elem, Graphics g, int x, int y) throws BadLocationException {
        AttributeSet attr;
        int p0 = elem.getStartOffset();
        int p1 = elem.getEndOffset();
        p1 = Math.min(this.getDocument().getLength(), p1);
        if (lineIndex == 0) {
            x += this.firstLineOffset;
        }
        if (MUtilities.isComposedTextAttributeDefined(attr = elem.getAttributes())) {
            g.setColor(this.unselected);
            x = MUtilities.drawComposedText(this, attr, g, x, y, p0 - elem.getStartOffset(), p1 - elem.getStartOffset());
        } else if (this.sel0 == this.sel1 || this.selected == this.unselected) {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        } else if (p0 >= this.sel0 && p0 <= this.sel1 && p1 >= this.sel0 && p1 <= this.sel1) {
            x = this.drawSelectedText(g, x, y, p0, p1);
        } else if (this.sel0 >= p0 && this.sel0 <= p1) {
            if (this.sel1 >= p0 && this.sel1 <= p1) {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, this.sel1);
                x = this.drawUnselectedText(g, x, y, this.sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, p1);
            }
        } else if (this.sel1 >= p0 && this.sel1 <= p1) {
            x = this.drawSelectedText(g, x, y, p0, this.sel1);
            x = this.drawUnselectedText(g, x, y, this.sel1, p1);
        } else {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        }
        return x;
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.unselected);
        Document doc = this.getDocument();
        Segment s = MSegmentCache.getSharedSegment();
        doc.getText(p0, p1 - p0, s);
        int ret = MUtilities.drawTabbedText(this, s, x, y, g, this, p0);
        MSegmentCache.releaseSharedSegment(s);
        return ret;
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selected);
        Document doc = this.getDocument();
        Segment s = MSegmentCache.getSharedSegment();
        doc.getText(p0, p1 - p0, s);
        int ret = MUtilities.drawTabbedText(this, s, x, y, g, this, p0);
        MSegmentCache.releaseSharedSegment(s);
        return ret;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    protected void updateMetrics() {
        Container host = this.getContainer();
        Font f = host.getFont();
        if (this.font != f) {
            this.calculateLongestLine();
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        switch (axis) {
            case 0: {
                return this.getLineWidth(this.longLine);
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public void paint(Graphics g, Shape a) {
        if (this.rotate_direction == 0) {
            this.paintHorizantal(g, a);
        } else if (this.rotate_hint != 4) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform transform = g2d.getTransform();
            ((Graphics2D)g).rotate(1.5707963267948966);
            this.paintVerticalL2R(g, a);
            g2d.setTransform(transform);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform transform = g2d.getTransform();
            ((Graphics2D)g).rotate(1.5707963267948966);
            g2d.translate(0.0, -this.height);
            this.paintVerticalR2L(g, a);
            g2d.setTransform(transform);
        }
    }

    private void paintHorizantal(Graphics g, Shape a) {
        int linesTotal;
        int linesAbove;
        int linesBelow;
        Shape originalA = a;
        a = this.adjustPaintRegion(a);
        Rectangle alloc = (Rectangle)a;
        this.tabBase = alloc.x;
        JTextComponent host = (JTextComponent)this.getContainer();
        Highlighter h = host.getHighlighter();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.unselected = host.isEnabled() ? host.getForeground() : host.getDisabledTextColor();
        Caret c = host.getCaret();
        this.selected = c.isSelectionVisible() && h != null ? host.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle clip = g.getClipBounds();
        int fontHeight = this.metrics.getHeight();
        int heightBelow = alloc.y + alloc.height - (clip.y + clip.height);
        int heightAbove = clip.y - alloc.y;
        if (fontHeight > 0) {
            linesBelow = Math.max(0, heightBelow / fontHeight);
            linesAbove = Math.max(0, heightAbove / fontHeight);
            linesTotal = alloc.height / fontHeight;
            if (alloc.height % fontHeight != 0) {
                ++linesTotal;
            }
        } else {
            linesTotal = 0;
            linesAbove = 0;
            linesBelow = 0;
        }
        Rectangle lineArea = this.lineToRect(a, linesAbove);
        int y = lineArea.y + this.metrics.getAscent();
        int x = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int endLine = Math.min(lineCount, linesTotal - linesBelow);
        --lineCount;
        LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        int line = linesAbove;
        while (line < endLine) {
            if (dh != null) {
                Element lineElement = map.getElement(line);
                if (line == lineCount) {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset(), originalA, host, this);
                } else {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset() - 1, originalA, host, this);
                }
            }
            this.drawLine(line, g, x, y);
            y += fontHeight;
            if (line == 0) {
                x -= this.firstLineOffset;
            }
            ++line;
        }
    }

    private void paintVerticalL2R(Graphics g, Shape a) {
        int linesTotal;
        int linesBelow;
        int linesAbove;
        Shape originalA = a;
        a = this.adjustPaintRegion(a);
        Rectangle alloc = new Rectangle((Rectangle)a);
        int tmp = alloc.x;
        alloc.x = alloc.y;
        alloc.y = tmp;
        tmp = alloc.width;
        alloc.width = alloc.height;
        alloc.height = tmp;
        this.tabBase = alloc.x;
        JTextComponent host = (JTextComponent)this.getContainer();
        Highlighter h = host.getHighlighter();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.unselected = host.isEnabled() ? host.getForeground() : host.getDisabledTextColor();
        Caret c = host.getCaret();
        this.selected = c.isSelectionVisible() && h != null ? host.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle clip = g.getClipBounds();
        int fontHeight = this.metrics.getHeight();
        int heightBelow = alloc.y + alloc.height - (clip.y + clip.height);
        int heightAbove = clip.y - alloc.y;
        if (fontHeight > 0) {
            linesAbove = Math.max(0, heightBelow / fontHeight);
            linesBelow = Math.max(0, heightAbove / fontHeight);
            linesTotal = alloc.height / fontHeight;
            if (alloc.height % fontHeight != 0) {
                ++linesTotal;
            }
        } else {
            linesTotal = 0;
            linesAbove = 0;
            linesBelow = 0;
        }
        Rectangle lineArea = this.lineToRect(alloc, linesBelow);
        int y = -lineArea.y - fontHeight + this.metrics.getAscent() + 2;
        int x = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int endLine = Math.min(lineCount, linesTotal - linesBelow);
        --lineCount;
        LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        int line = linesBelow;
        while (line < endLine) {
            if (dh != null) {
                Element lineElement = map.getElement(line);
                if (line == lineCount) {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset(), originalA, host, this);
                } else {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset() - 1, originalA, host, this);
                }
            }
            this.drawLine(line, g, x, y);
            y -= fontHeight;
            if (line == 0) {
                x -= this.firstLineOffset;
            }
            ++line;
        }
    }

    private void paintVerticalR2L(Graphics g, Shape a) {
        int linesTotal;
        int linesBelow;
        int linesAbove;
        Shape originalA = a;
        a = this.adjustPaintRegion(a);
        Rectangle alloc = new Rectangle((Rectangle)a);
        int tmp = alloc.x;
        alloc.x = alloc.y;
        alloc.y = tmp;
        tmp = alloc.width;
        alloc.width = alloc.height;
        alloc.height = tmp;
        this.tabBase = alloc.x;
        JTextComponent host = (JTextComponent)this.getContainer();
        Highlighter h = host.getHighlighter();
        g.setFont(host.getFont());
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.unselected = host.isEnabled() ? host.getForeground() : host.getDisabledTextColor();
        Caret c = host.getCaret();
        this.selected = c.isSelectionVisible() && h != null ? host.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle clip = g.getClipBounds();
        int fontHeight = this.metrics.getHeight();
        int heightBelow = alloc.y + alloc.height - (clip.y + clip.height);
        int heightAbove = clip.y - alloc.y;
        if (fontHeight > 0) {
            linesAbove = Math.max(0, heightBelow / fontHeight);
            linesBelow = Math.max(0, heightAbove / fontHeight);
            linesTotal = alloc.height / fontHeight;
            if (alloc.height % fontHeight != 0) {
                ++linesTotal;
            }
        } else {
            linesTotal = 0;
            linesAbove = 0;
            linesBelow = 0;
        }
        Rectangle lineArea = this.lineToRect(alloc, linesAbove);
        int y = lineArea.y + this.metrics.getAscent();
        int x = lineArea.x;
        Element map = this.getElement();
        int lineCount = map.getElementCount();
        int endLine = Math.min(lineCount, linesTotal - linesBelow);
        --lineCount;
        LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
        int line = linesAbove;
        while (line < endLine) {
            if (dh != null) {
                Element lineElement = map.getElement(line);
                if (line == lineCount) {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset(), originalA, host, this);
                } else {
                    dh.paintLayeredHighlights(g, lineElement.getStartOffset(), lineElement.getEndOffset() - 1, originalA, host, this);
                }
            }
            this.drawLine(line, g, x, y);
            y += fontHeight;
            if (line == 0) {
                x -= this.firstLineOffset;
            }
            ++line;
        }
    }

    Shape adjustPaintRegion(Shape a) {
        return a;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (this.rotate_direction == 0) {
            Shape s = this.modelToViewHorizantal(pos, a, b);
            return s;
        }
        if (this.rotate_hint != 4) {
            Shape s = this.modelToViewVerticalL2R(pos, a, b);
            Rectangle alloc = s.getBounds();
            int tmp = alloc.x;
            alloc.x = alloc.y + alloc.height / 2;
            alloc.y = tmp;
            tmp = alloc.width;
            alloc.width = alloc.height;
            alloc.height = tmp;
            JTextComponent c = (JTextComponent)this.getContainer();
            c.putClientProperty("caretWidth", new Integer(alloc.width));
            c.repaint();
            return alloc;
        }
        Shape s = this.modelToViewVerticalR2L(pos, a, b);
        Rectangle alloc = s.getBounds();
        int tmp = alloc.x;
        alloc.x = alloc.y + alloc.height / 2;
        alloc.y = tmp;
        tmp = alloc.width;
        alloc.width = alloc.height;
        alloc.height = tmp;
        JTextComponent c = (JTextComponent)this.getContainer();
        c.putClientProperty("caretWidth", new Integer(alloc.width));
        c.repaint();
        return alloc;
    }

    private Shape modelToViewHorizantal(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Document doc = this.getDocument();
        Element map = this.getElement();
        int lineIndex = map.getElementIndex(pos);
        if (lineIndex < 0) {
            return this.lineToRect(a, 0);
        }
        Rectangle lineArea = this.lineToRect(a, lineIndex);
        this.tabBase = lineArea.x;
        Element line = map.getElement(lineIndex);
        int p0 = line.getStartOffset();
        Segment s = MSegmentCache.getSharedSegment();
        doc.getText(p0, pos - p0, s);
        int xOffs = MUtilities.getTabbedTextWidth(s, this.metrics, this.defaultmetrics, this.tabBase, this, p0);
        MSegmentCache.releaseSharedSegment(s);
        lineArea.x += xOffs;
        lineArea.width = 1;
        lineArea.height = this.metrics.getHeight();
        return lineArea;
    }

    private Shape modelToViewVerticalL2R(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle alloc = new Rectangle((Rectangle)a);
        int tmp = alloc.x;
        alloc.x = alloc.y;
        alloc.y = tmp;
        tmp = alloc.width;
        alloc.width = alloc.height;
        alloc.height = tmp;
        Document doc = this.getDocument();
        Element map = this.getElement();
        int lineIndex = map.getElementIndex(pos);
        if (lineIndex < 0) {
            return this.lineToRect(a, 0);
        }
        Rectangle lineArea = this.lineToRect(alloc, lineIndex);
        this.tabBase = lineArea.x;
        Element line = map.getElement(lineIndex);
        int p0 = line.getStartOffset();
        Segment s = MSegmentCache.getSharedSegment();
        doc.getText(p0, pos - p0, s);
        int xOffs = MUtilities.getTabbedTextWidth(s, this.metrics, this.defaultmetrics, this.tabBase, this, p0);
        MSegmentCache.releaseSharedSegment(s);
        lineArea.x += xOffs;
        lineArea.width = 1;
        lineArea.height = this.metrics.getHeight();
        return lineArea;
    }

    private Shape modelToViewVerticalR2L(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Rectangle alloc = new Rectangle((Rectangle)a);
        int tmp = alloc.x;
        alloc.x = alloc.y;
        alloc.y = tmp;
        tmp = alloc.width;
        alloc.width = alloc.height;
        alloc.height = tmp;
        Document doc = this.getDocument();
        Element map = this.getElement();
        int lineIndex = map.getElementIndex(pos);
        if (lineIndex < 0) {
            return this.lineToRect(a, 0);
        }
        Rectangle lineArea = this.lineToRect(alloc, lineIndex);
        this.tabBase = lineArea.x;
        Element line = map.getElement(lineIndex);
        int p0 = line.getStartOffset();
        Segment s = MSegmentCache.getSharedSegment();
        doc.getText(p0, pos - p0, s);
        int xOffs = MUtilities.getTabbedTextWidth(s, this.metrics, this.defaultmetrics, this.tabBase, this, p0);
        MSegmentCache.releaseSharedSegment(s);
        lineArea.x += xOffs;
        int w = (int)this.height;
        lineArea.y = w - lineArea.y - this.metrics.getHeight();
        lineArea.width = 1;
        lineArea.height = this.metrics.getHeight();
        return lineArea;
    }

    @Override
    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        Rectangle alloc = a.getBounds();
        if (this.rotate_direction == 0) {
            return this.viewToModelHorizantal(fx, fy, a, bias);
        }
        if (this.rotate_hint != 4) {
            return this.viewToModelVertical(fx, fy, alloc, bias);
        }
        return this.viewToModelVertical(fx, fy, alloc, bias);
    }

    private int viewToModelHorizantal(float fx, float fy, Shape a, Position.Bias[] bias) {
        int lineIndex;
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        Document doc = this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (y < alloc.y) {
            return this.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            return this.getEndOffset() - 1;
        }
        Element map = doc.getDefaultRootElement();
        int fontHeight = this.metrics.getHeight();
        int n = lineIndex = fontHeight > 0 ? Math.abs((y - alloc.y) / fontHeight) : map.getElementCount() - 1;
        if (lineIndex >= map.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = map.getElement(lineIndex);
        boolean dx = false;
        if (lineIndex == 0) {
            alloc.x += this.firstLineOffset;
            alloc.width -= this.firstLineOffset;
        }
        if (x < alloc.x) {
            return line.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return line.getEndOffset() - 1;
        }
        try {
            int p0 = line.getStartOffset();
            int p1 = line.getEndOffset() - 1;
            Segment s = MSegmentCache.getSharedSegment();
            doc.getText(p0, p1 - p0, s);
            this.tabBase = alloc.x;
            int offs = p0 + MUtilities.getTabbedTextOffset(s, this.metrics, this.defaultmetrics, this.tabBase, x, this, p0);
            MSegmentCache.releaseSharedSegment(s);
            return offs;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    private int viewToModelVertical(float fx, float fy, Shape a, Position.Bias[] bias) {
        int lineIndex;
        bias[0] = Position.Bias.Forward;
        Rectangle alloc = a.getBounds();
        Document doc = this.getDocument();
        int x = (int)fx;
        int y = (int)fy;
        if (x < alloc.x) {
            return this.getStartOffset();
        }
        if (x > alloc.x + alloc.width) {
            return this.getEndOffset() - 1;
        }
        Element map = doc.getDefaultRootElement();
        int fontHeight = this.metrics.getHeight();
        int n = lineIndex = fontHeight > 0 ? Math.abs((x - alloc.x) / fontHeight) : map.getElementCount() - 1;
        if (lineIndex >= map.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element line = map.getElement(lineIndex);
        boolean dx = false;
        if (lineIndex == 0) {
            alloc.y += this.firstLineOffset;
            alloc.height -= this.firstLineOffset;
        }
        if (y < alloc.y) {
            return line.getStartOffset();
        }
        if (y > alloc.y + alloc.height) {
            return line.getEndOffset() - 1;
        }
        try {
            int p0 = line.getStartOffset();
            int p1 = line.getEndOffset() - 1;
            Segment s = MSegmentCache.getSharedSegment();
            doc.getText(p0, p1 - p0, s);
            this.tabBase = alloc.y;
            int offs = p0 + MUtilities.getTabbedTextOffset(s, this.metrics, this.defaultmetrics, this.tabBase, y, this, p0);
            MSegmentCache.releaseSharedSegment(s);
            return offs;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        if (this.rotate_direction == 0) {
            return this.modelToViewHorizantal(p0, b0, p1, b1, a);
        }
        if (this.rotate_hint != 4) {
            return this.modelToViewVerticalL2R(p0, b0, p1, b1, a);
        }
        return this.modelToViewVerticalR2L(p0, b0, p1, b1, a);
    }

    private Shape modelToViewHorizantal(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Rectangle r0 = s0.getBounds();
        Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        if (r0.y != r1.y) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        return r0;
    }

    private Shape modelToViewVerticalL2R(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        Rectangle r0 = s0.getBounds();
        int tmp = r0.x;
        r0.x = r0.y;
        r0.y = -tmp - r0.width / 2;
        tmp = r0.width;
        r0.width = r0.height;
        r0.height = tmp;
        Rectangle r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        tmp = r1.x;
        r1.x = r1.y;
        r1.y = -tmp - r1.width / 2;
        tmp = r1.width;
        r1.width = r1.height;
        r1.height = tmp;
        if (r0.y != r1.y) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        return r0;
    }

    private Shape modelToViewVerticalR2L(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle alloc;
        Shape s1;
        Shape s0 = this.modelToView(p0, a, b0);
        if (p1 == this.getEndOffset()) {
            try {
                s1 = this.modelToView(p1, a, b1);
            }
            catch (BadLocationException ble) {
                s1 = null;
            }
            if (s1 == null) {
                alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
            }
        } else {
            s1 = this.modelToView(p1, a, b1);
        }
        alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Rectangle r0 = s0.getBounds();
        int tmp = r0.x;
        r0.x = r0.y;
        r0.y = alloc.width - tmp - r0.width / 2;
        tmp = r0.width;
        r0.width = r0.height;
        r0.height = tmp;
        Rectangle r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
        tmp = r1.x;
        r1.x = r1.y;
        r1.y = alloc.width - tmp - r1.width / 2;
        tmp = r1.width;
        r1.width = r1.height;
        r1.height = tmp;
        if (r0.y != r1.y) {
            r0.x = alloc.x;
            r0.width = alloc.width;
        }
        r0.add(r1);
        return r0;
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        if (this.rotate_direction == 0) {
            return this.getNextVisualPositionFromHorizantal(pos, b, a, direction, biasRet);
        }
        if (this.rotate_hint != 4) {
            return this.getNextVisualPositionFromVerticalL2R(pos, b, a, direction, biasRet);
        }
        return this.getNextVisualPositionFromVerticalR2L(pos, b, a, direction, biasRet);
    }

    protected int getNextVisualPositionFromHorizantal(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 1: 
            case 5: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 1 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int x = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 1) {
                    pos = MUtilities.getPositionAbove(target, pos, x);
                    break;
                }
                pos = MUtilities.getPositionBelow(target, pos, x);
                break;
            }
            case 7: {
                if (pos == -1) {
                    pos = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                break;
            }
            case 3: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    private int getNextVisualPositionFromVerticalL2R(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 3: 
            case 7: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 7 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int x = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 7) {
                    pos = MUtilities.getPositionAboveL2R(target, pos, x);
                    break;
                }
                pos = MUtilities.getPositionBelowL2R(target, pos, x);
                break;
            }
            case 1: {
                if (pos == -1) {
                    pos = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                break;
            }
            case 5: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    private int getNextVisualPositionFromVerticalR2L(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 3: 
            case 7: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 3 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int y = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.y) : mcp.y;
                if (direction == 3) {
                    pos = MUtilities.getPositionAboveR2L(target, pos, y);
                    break;
                }
                pos = MUtilities.getPositionBelowR2L(target, pos, y);
                break;
            }
            case 1: {
                if (pos == -1) {
                    pos = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                break;
            }
            case 5: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    @Override
    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.updateDamage(changes, a, f);
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.width = height;
        this.height = width;
        this.updateMetrics();
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        if (this.tabSize == 0) {
            return x;
        }
        int ntabs = ((int)x - this.tabBase) / this.tabSize;
        return this.tabBase + (ntabs + 1) * this.tabSize;
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removed;
        Container host = this.getContainer();
        this.updateMetrics();
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = changes.getChange(elem);
        Element[] added = ec != null ? ec.getChildrenAdded() : null;
        Element[] elementArray = removed = ec != null ? ec.getChildrenRemoved() : null;
        if (added != null && added.length > 0 || removed != null && removed.length > 0) {
            if (added != null) {
                int currWide = this.getLineWidth(this.longLine);
                int i = 0;
                while (i < added.length) {
                    int w = this.getLineWidth(added[i]);
                    if (w > currWide) {
                        currWide = w;
                        this.longLine = added[i];
                    }
                    ++i;
                }
            }
            if (removed != null) {
                int i = 0;
                while (i < removed.length) {
                    if (removed[i] == this.longLine) {
                        this.calculateLongestLine();
                        break;
                    }
                    ++i;
                }
            }
            this.preferenceChanged(null, true, true);
            host.repaint();
        } else {
            Element map = this.getElement();
            int line = map.getElementIndex(changes.getOffset());
            this.damageLineRange(line, line, a, host);
            if (changes.getType() == DocumentEvent.EventType.INSERT) {
                int w = this.getLineWidth(this.longLine);
                Element e = map.getElement(line);
                if (e == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(e) > w) {
                    this.longLine = e;
                    this.preferenceChanged(null, true, false);
                }
            } else if (changes.getType() == DocumentEvent.EventType.REMOVE && map.getElement(line) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }

    protected void damageLineRange(int line0, int line1, Shape a, Component host) {
        if (this.rotate_direction == 0) {
            if (a != null) {
                Rectangle area0 = this.lineToRect(a, line0);
                Rectangle area1 = this.lineToRect(a, line1);
                if (area0 != null && area1 != null) {
                    Rectangle damage = area0.union(area1);
                    host.repaint(damage.x, damage.y, damage.width, damage.height);
                } else {
                    host.repaint();
                }
            }
        } else if (this.rotate_hint != 4) {
            Rectangle area0 = this.lineToRect(a, line0);
            int tmp = area0.x;
            area0.x = area0.y;
            area0.y = tmp;
            tmp = area0.width;
            area0.width = area0.height;
            area0.height = tmp;
            Rectangle area1 = this.lineToRect(a, line1);
            tmp = area1.x;
            area1.x = area1.y;
            area1.y = tmp;
            tmp = area1.width;
            area1.width = area1.height;
            area1.height = tmp;
            if (area0 != null && area1 != null) {
                Rectangle damage = area0.union(area1);
                host.repaint(damage.x, damage.y, damage.width, damage.height);
            } else {
                host.repaint();
            }
        } else {
            host.repaint();
        }
    }

    protected Rectangle lineToRect(Shape a, int line) {
        Rectangle r = null;
        this.updateMetrics();
        if (this.rotate_direction == 0 || this.rotate_hint == 4) {
            if (this.metrics != null) {
                Rectangle alloc = a.getBounds();
                if (line == 0) {
                    alloc.x += this.firstLineOffset;
                    alloc.width -= this.firstLineOffset;
                }
                r = new Rectangle(alloc.x, alloc.y + line * this.metrics.getHeight(), alloc.width, this.metrics.getHeight());
            }
        } else if (this.metrics != null) {
            Rectangle alloc = a.getBounds();
            if (line == 0) {
                alloc.x += this.firstLineOffset;
                alloc.width -= this.firstLineOffset;
            }
            r = new Rectangle(alloc.x, alloc.y + line * this.metrics.getHeight(), alloc.width, this.metrics.getHeight());
        }
        return r;
    }

    private void calculateLongestLine() {
        Container c = this.getContainer();
        this.font = c.getFont();
        this.metrics = c.getFontMetrics(this.font);
        Font alternative_font = MongolianFontUtil.getAltFont(this.font, "TextField.font");
        this.defaultmetrics = c.getFontMetrics(alternative_font);
        if (!MongolianFontUtil.isMongolianFont(this.font)) {
            FontMetrics tmpfont = this.metrics;
            this.metrics = this.defaultmetrics;
            this.defaultmetrics = tmpfont;
        }
        Document doc = this.getDocument();
        Element lines = this.getElement();
        int n = lines.getElementCount();
        int maxWidth = -1;
        int i = 0;
        while (i < n) {
            Element line = lines.getElement(i);
            int w = this.getLineWidth(line);
            if (w > maxWidth) {
                maxWidth = w;
                this.longLine = line;
            }
            ++i;
        }
    }

    private int getLineWidth(Element line) {
        int w;
        if (line == null) {
            return 0;
        }
        int p0 = line.getStartOffset();
        int p1 = line.getEndOffset();
        Segment s = MSegmentCache.getSharedSegment();
        try {
            line.getDocument().getText(p0, p1 - p0, s);
            w = MUtilities.getTabbedTextWidth(s, this.metrics, this.defaultmetrics, this.tabBase, this, p0);
        }
        catch (BadLocationException ble) {
            w = 0;
        }
        MSegmentCache.releaseSharedSegment(s);
        return w;
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (this.rotate_direction == 0) {
            return super.getMinimumSpan(axis);
        }
        if (axis == 0) {
            return super.getMinimumSpan(1);
        }
        return super.getMinimumSpan(0);
    }

    @Override
    public float getMaximumSpan(int axis) {
        if (this.rotate_direction == 0) {
            return super.getMaximumSpan(axis);
        }
        if (axis == 0) {
            return super.getMaximumSpan(1);
        }
        return super.getMaximumSpan(0);
    }

    protected FontMetrics getFontMetrics() {
        Container c = this.getContainer();
        return c.getFontMetrics(c.getFont());
    }

    protected FontMetrics getDefaultFontMetrics() {
        Container c = this.getContainer();
        Font font = c.getFont();
        Font defaultfont = UIManager.getFont("TextField.font");
        int size = (font.getSize() + defaultfont.getSize()) / 2;
        defaultfont = defaultfont.deriveFont(0, size);
        return c.getFontMetrics(defaultfont);
    }
}

